/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cloudfront;

import ch.cyberduck.core.ConnectionCanceledException;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.ErrorListener;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LoginCanceledException;
import ch.cyberduck.core.LoginController;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.cdn.Distribution;
import ch.cyberduck.core.cdn.DistributionConfiguration;
import ch.cyberduck.core.http.HTTP3Session;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.threading.BackgroundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.jets3t.service.CloudFrontService;
import org.jets3t.service.CloudFrontServiceException;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.model.cloudfront.CustomOrigin;
import org.jets3t.service.model.cloudfront.Distribution;
import org.jets3t.service.model.cloudfront.DistributionConfig;
import org.jets3t.service.model.cloudfront.InvalidationSummary;
import org.jets3t.service.model.cloudfront.LoggingStatus;
import org.jets3t.service.model.cloudfront.Origin;
import org.jets3t.service.model.cloudfront.S3Origin;
import org.jets3t.service.model.cloudfront.StreamingDistribution;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.security.ProviderCredentials;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloudFrontDistributionConfiguration
extends HTTP3Session
implements DistributionConfiguration {
    private static Logger log = Logger.getLogger(CloudFrontDistributionConfiguration.class);
    private CloudFrontService client;
    private LoginController login;
    private ErrorListener listener;
    protected Map<Distribution.Method, Map<String, ch.cyberduck.core.cdn.Distribution>> distributionStatus = new HashMap<Distribution.Method, Map<String, ch.cyberduck.core.cdn.Distribution>>();

    public CloudFrontDistributionConfiguration(LoginController parent, Credentials credentials, ErrorListener listener) {
        super(new Host(Protocol.S3_SSL, Protocol.S3_SSL.getDefaultHostname(), credentials));
        this.login = parent;
        this.listener = listener;
        this.clear();
    }

    protected CloudFrontService getClient() throws ConnectionCanceledException {
        if (null == this.client) {
            throw new ConnectionCanceledException();
        }
        return this.client;
    }

    @Override
    protected void connect() throws IOException {
        if (this.isConnected()) {
            return;
        }
        this.fireConnectionWillOpenEvent();
        this.login();
        this.fireConnectionDidOpenEvent();
    }

    @Override
    protected void login() throws IOException {
        this.login(this.login);
    }

    @Override
    protected void login(LoginController controller, Credentials credentials) throws IOException {
        try {
            URI endpoint = new URI("https://cloudfront.amazonaws.com/", false);
            HostConfiguration hostconfig = this.getHostConfiguration(new Host(Protocol.S3_SSL, endpoint.getHost(), endpoint.getPort()));
            this.client = new CloudFrontService((ProviderCredentials)new AWSCredentials(credentials.getUsername(), credentials.getPassword()), this.getUserAgent(), null, new Jets3tProperties(), hostconfig);
            this.client.listDistributions();
        }
        catch (CloudFrontServiceException e) {
            log.warn((Object)("Invalid CloudFront account:" + e.getMessage()));
            this.message(Locale.localizedString("Login failed", "Credentials"));
            controller.fail(this.host.getProtocol(), credentials);
            this.login();
        }
        catch (URIException e) {
            IOException f = new IOException();
            f.initCause(e);
            throw f;
        }
    }

    @Override
    protected void prompt(LoginController login) throws LoginCanceledException {
        login.check(this.host, this.toString(), null, true, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            if (this.isConnected()) {
                this.fireConnectionWillCloseEvent();
            }
            Object var2_1 = null;
            this.clear();
            this.client = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.clear();
            this.client = null;
            this.fireConnectionDidCloseEvent();
            throw throwable;
        }
        this.fireConnectionDidCloseEvent();
    }

    @Override
    public void error(Path path, String message, Throwable e) {
        this.listener.error(new BackgroundException(this, path, message, e));
    }

    @Override
    public String toString() {
        return Locale.localizedString("Amazon CloudFront", "S3");
    }

    @Override
    public String toString(Distribution.Method method) {
        return this.toString();
    }

    @Override
    public boolean isConfigured(Distribution.Method method) {
        return !this.distributionStatus.get(method).isEmpty();
    }

    @Override
    public String getOrigin(Distribution.Method method, String container) {
        return container + ".s3.amazonaws.com";
    }

    @Override
    public List<Distribution.Method> getMethods() {
        return Arrays.asList(ch.cyberduck.core.cdn.Distribution.DOWNLOAD, ch.cyberduck.core.cdn.Distribution.STREAMING);
    }

    @Override
    public ch.cyberduck.core.cdn.Distribution read(String origin, Distribution.Method method) {
        if ((method.equals(ch.cyberduck.core.cdn.Distribution.DOWNLOAD) || method.equals(ch.cyberduck.core.cdn.Distribution.STREAMING) || method.equals(ch.cyberduck.core.cdn.Distribution.CUSTOM) || method.equals(ch.cyberduck.core.cdn.Distribution.WEBSITE_CDN)) && (!this.distributionStatus.get(method).containsKey(origin) || !this.distributionStatus.get(method).get(origin).isDeployed())) {
            try {
                this.check();
                this.message(MessageFormat.format(Locale.localizedString("Reading CDN configuration of {0}", "Status"), origin));
                Iterator<ch.cyberduck.core.cdn.Distribution> i$ = this.listDistributions(origin, method).iterator();
                if (i$.hasNext()) {
                    ch.cyberduck.core.cdn.Distribution d = i$.next();
                    this.distributionStatus.get(method).put(origin, d);
                }
            }
            catch (CloudFrontServiceException e) {
                this.error("Cannot read CDN configuration", e);
            }
            catch (LoginCanceledException canceled) {
                this.distributionStatus.get(method).put(origin, new ch.cyberduck.core.cdn.Distribution(null, origin, method, false, null, canceled.getMessage()));
            }
            catch (IOException e) {
                this.error("Cannot read CDN configuration", e);
            }
        }
        if (this.distributionStatus.get(method).containsKey(origin)) {
            return this.distributionStatus.get(method).get(origin);
        }
        return new ch.cyberduck.core.cdn.Distribution(origin, method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(boolean enabled, String origin, Distribution.Method method, String[] cnames, boolean logging, String defaultRootObject) {
        block20: {
            try {
                block19: {
                    try {
                        this.check();
                        LoggingStatus loggingStatus = null;
                        if (logging && this.isLoggingSupported(method)) {
                            loggingStatus = new LoggingStatus(origin, Preferences.instance().getProperty("cloudfront.logging.prefix"));
                        }
                        StringBuilder name = new StringBuilder(Locale.localizedString("Amazon CloudFront", "S3")).append(" ").append(method.toString());
                        if (enabled) {
                            this.message(MessageFormat.format(Locale.localizedString("Enable {0} Distribution", "Status"), name));
                        } else {
                            this.message(MessageFormat.format(Locale.localizedString("Disable {0} Distribution", "Status"), name));
                        }
                        ch.cyberduck.core.cdn.Distribution d = this.distributionStatus.get(method).get(origin);
                        if (null == d) {
                            log.debug((Object)("No existing distribution found for method:" + method));
                            this.createDistribution(enabled, method, origin, cnames, loggingStatus, defaultRootObject);
                            break block19;
                        }
                        boolean modified = false;
                        if (d.isEnabled() != enabled) {
                            modified = true;
                        }
                        if (!Arrays.equals(d.getCNAMEs(), cnames)) {
                            modified = true;
                        }
                        if (d.isLogging() != logging) {
                            modified = true;
                        }
                        if (null != d.getDefaultRootObject() || null != defaultRootObject) {
                            if (null != d.getDefaultRootObject() && null == defaultRootObject) {
                                modified = true;
                            } else if (null == d.getDefaultRootObject() && null != defaultRootObject) {
                                modified = true;
                            } else if (!d.getDefaultRootObject().equals(defaultRootObject)) {
                                modified = true;
                            }
                        }
                        if (modified) {
                            this.updateDistribution(enabled, method, origin, d.getId(), cnames, loggingStatus, defaultRootObject);
                            break block19;
                        }
                        log.info((Object)"Skip updating distribution not modified.");
                    }
                    catch (CloudFrontServiceException e) {
                        this.error("Cannot write CDN configuration", e);
                        Object var12_14 = null;
                        this.distributionStatus.get(method).clear();
                        break block20;
                    }
                    catch (IOException e) {
                        this.error("Cannot write CDN configuration", e);
                        Object var12_15 = null;
                        this.distributionStatus.get(method).clear();
                    }
                }
                Object var12_13 = null;
                this.distributionStatus.get(method).clear();
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                this.distributionStatus.get(method).clear();
                throw throwable;
            }
        }
    }

    @Override
    public boolean isDefaultRootSupported(Distribution.Method method) {
        return method.equals(ch.cyberduck.core.cdn.Distribution.DOWNLOAD) || method.equals(ch.cyberduck.core.cdn.Distribution.WEBSITE_CDN) || method.equals(ch.cyberduck.core.cdn.Distribution.CUSTOM);
    }

    @Override
    public boolean isInvalidationSupported(Distribution.Method method) {
        return method.equals(ch.cyberduck.core.cdn.Distribution.DOWNLOAD) || method.equals(ch.cyberduck.core.cdn.Distribution.WEBSITE_CDN) || method.equals(ch.cyberduck.core.cdn.Distribution.CUSTOM);
    }

    @Override
    public boolean isLoggingSupported(Distribution.Method method) {
        return method.equals(ch.cyberduck.core.cdn.Distribution.DOWNLOAD) || method.equals(ch.cyberduck.core.cdn.Distribution.STREAMING);
    }

    @Override
    public boolean isCnameSupported(Distribution.Method method) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void invalidate(String origin, Distribution.Method method, List<Path> files, boolean recursive) {
        block9: {
            block8: {
                try {
                    try {
                        this.check();
                        this.message(MessageFormat.format(Locale.localizedString("Writing CDN configuration of {0}", "Status"), origin));
                        long reference = System.currentTimeMillis();
                        ch.cyberduck.core.cdn.Distribution d = this.distributionStatus.get(method).get(origin);
                        if (null == d) {
                            log.error((Object)("No cached distribution for origin:" + origin));
                            Object var11_9 = null;
                            this.distributionStatus.get(method).clear();
                            return;
                        }
                        List<String> keys = this.getInvalidationKeys(files, recursive);
                        if (keys.isEmpty()) {
                            log.warn((Object)"No keys selected for invalidation");
                            break block8;
                        }
                        CloudFrontService cf = this.getClient();
                        cf.invalidateObjects(d.getId(), keys.toArray(new String[keys.size()]), new Date(reference).toString());
                        break block9;
                    }
                    catch (CloudFrontServiceException e) {
                        this.error("Cannot write CDN configuration", e);
                        Object var11_12 = null;
                        this.distributionStatus.get(method).clear();
                        return;
                    }
                    catch (IOException e) {
                        this.error("Cannot write CDN configuration", e);
                        Object var11_13 = null;
                        this.distributionStatus.get(method).clear();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var11_14 = null;
                    this.distributionStatus.get(method).clear();
                    throw throwable;
                }
            }
            Object var11_10 = null;
            this.distributionStatus.get(method).clear();
            return;
        }
        Object var11_11 = null;
        this.distributionStatus.get(method).clear();
    }

    protected List<String> getInvalidationKeys(List<Path> files, boolean recursive) {
        ArrayList<String> keys = new ArrayList<String>();
        for (Path file : files) {
            if (file.isContainer()) {
                keys.add(String.valueOf('/'));
            } else {
                keys.add(file.getKey());
            }
            if (!file.attributes().isDirectory() || !recursive) continue;
            keys.addAll(this.getInvalidationKeys(file.children(), recursive));
        }
        return keys;
    }

    private String readInvalidationStatus(ch.cyberduck.core.cdn.Distribution distribution) throws IOException {
        try {
            CloudFrontService cf = this.getClient();
            long reference = System.currentTimeMillis();
            boolean complete = false;
            int inprogress = 0;
            List summaries = cf.listInvalidations(distribution.getId());
            for (InvalidationSummary s : summaries) {
                if ("Completed".equals(s.getStatus())) {
                    complete = true;
                    continue;
                }
                ++inprogress;
            }
            if (inprogress > 0) {
                return MessageFormat.format(Locale.localizedString("{0} invalidations in progress", "S3"), inprogress);
            }
            if (complete) {
                return MessageFormat.format(Locale.localizedString("{0} invalidations completed", "S3"), summaries.size());
            }
            return Locale.localizedString("None");
        }
        catch (CloudFrontServiceException e) {
            this.error("Cannot read CDN configuration", e);
            return Locale.localizedString("Unknown");
        }
    }

    @Override
    public void clear() {
        for (Distribution.Method method : this.getMethods()) {
            this.distributionStatus.put(method, new HashMap(0));
        }
    }

    private Distribution createDistribution(boolean enabled, Distribution.Method method, String origin, String[] cnames, LoggingStatus logging, String defaultRootObject) throws ConnectionCanceledException, CloudFrontServiceException {
        long reference = System.currentTimeMillis();
        log.debug((Object)("createDistribution:" + method));
        CloudFrontService cf = this.getClient();
        if (method.equals(ch.cyberduck.core.cdn.Distribution.STREAMING)) {
            return cf.createStreamingDistribution((Origin)new S3Origin(origin), String.valueOf(reference), cnames, new Date(reference).toString(), enabled, logging);
        }
        if (method.equals(ch.cyberduck.core.cdn.Distribution.DOWNLOAD)) {
            return cf.createDistribution((Origin)new S3Origin(origin), String.valueOf(reference), cnames, new Date(reference).toString(), enabled, logging, false, null, null, defaultRootObject);
        }
        if (method.equals(ch.cyberduck.core.cdn.Distribution.CUSTOM) || method.equals(ch.cyberduck.core.cdn.Distribution.WEBSITE_CDN)) {
            return cf.createDistribution((Origin)this.getCustomOriginConfiguration(method, origin), String.valueOf(reference), cnames, new Date(reference).toString(), enabled, logging, false, null, null, defaultRootObject);
        }
        throw new RuntimeException("Invalid distribution method:" + method);
    }

    private void updateDistribution(boolean enabled, Distribution.Method method, String origin, String id, String[] cnames, LoggingStatus logging, String defaultRootObject) throws CloudFrontServiceException, IOException {
        log.debug((Object)("updateDistribution:" + origin));
        long reference = System.currentTimeMillis();
        CloudFrontService cf = this.getClient();
        if (method.equals(ch.cyberduck.core.cdn.Distribution.STREAMING)) {
            cf.updateStreamingDistributionConfig(id, (Origin)new S3Origin(origin), cnames, new Date(reference).toString(), enabled, logging);
        } else if (method.equals(ch.cyberduck.core.cdn.Distribution.DOWNLOAD)) {
            cf.updateDistributionConfig(id, (Origin)new S3Origin(origin), cnames, new Date(reference).toString(), enabled, logging, false, null, null, defaultRootObject);
        } else if (method.equals(ch.cyberduck.core.cdn.Distribution.CUSTOM) || method.equals(ch.cyberduck.core.cdn.Distribution.WEBSITE_CDN)) {
            cf.updateDistributionConfig(id, (Origin)this.getCustomOriginConfiguration(method, origin), cnames, new Date(reference).toString(), enabled, logging, false, null, null, defaultRootObject);
        } else {
            throw new RuntimeException("Invalid distribution method:" + method);
        }
    }

    protected CustomOrigin getCustomOriginConfiguration(Distribution.Method method, String origin) {
        return new CustomOrigin(origin, CustomOrigin.OriginProtocolPolicy.MATCH_VIEWER);
    }

    private List<ch.cyberduck.core.cdn.Distribution> listDistributions(String origin, Distribution.Method method) throws IOException, CloudFrontServiceException {
        log.debug((Object)("listDistributions:" + origin));
        CloudFrontService cf = this.getClient();
        ArrayList<ch.cyberduck.core.cdn.Distribution> list = new ArrayList<ch.cyberduck.core.cdn.Distribution>();
        if (method.equals(ch.cyberduck.core.cdn.Distribution.STREAMING)) {
            for (StreamingDistribution d : cf.listStreamingDistributions(origin)) {
                list.add(this.convert((Distribution)d, method));
            }
        } else if (method.equals(ch.cyberduck.core.cdn.Distribution.DOWNLOAD)) {
            for (Distribution d : cf.listDistributions(origin)) {
                if (!(d.getOrigin() instanceof S3Origin)) continue;
                list.add(this.convert(d, method));
            }
        } else if (method.equals(ch.cyberduck.core.cdn.Distribution.CUSTOM) || method.equals(ch.cyberduck.core.cdn.Distribution.WEBSITE_CDN)) {
            for (Distribution d : cf.listDistributions()) {
                if (!(d.getOrigin() instanceof CustomOrigin) || !d.getOrigin().getDnsName().equals(origin)) continue;
                list.add(this.convert(d, method));
            }
        } else {
            throw new RuntimeException("Invalid distribution method:" + method);
        }
        return list;
    }

    private ch.cyberduck.core.cdn.Distribution convert(Distribution d, Distribution.Method method) throws IOException, CloudFrontServiceException {
        DistributionConfig distributionConfig = this.getDistributionConfig(d);
        ch.cyberduck.core.cdn.Distribution distribution = new ch.cyberduck.core.cdn.Distribution(d.getId(), d.getOrigin().getDnsName(), method, d.isEnabled(), d.isDeployed(), method.getProtocol() + d.getDomainName() + method.getContext(), Locale.localizedString(d.getStatus(), "S3"), d.getCNAMEs(), distributionConfig.isLoggingEnabled(), distributionConfig.getDefaultRootObject());
        if (this.isInvalidationSupported(method)) {
            distribution.setInvalidationStatus(this.readInvalidationStatus(distribution));
        }
        return distribution;
    }

    private DistributionConfig getDistributionConfig(Distribution distribution) throws IOException, CloudFrontServiceException {
        CloudFrontService cf = this.getClient();
        if (distribution.isStreamingDistribution()) {
            return cf.getStreamingDistributionConfig(distribution.getId());
        }
        return cf.getDistributionConfig(distribution.getId());
    }

    private void deleteDistribution(ch.cyberduck.core.cdn.Distribution distribution) throws IOException, CloudFrontServiceException {
        CloudFrontService cf = this.getClient();
        if (distribution.getMethod().equals(ch.cyberduck.core.cdn.Distribution.STREAMING)) {
            cf.deleteStreamingDistribution(distribution.getId());
        } else if (distribution.getMethod().equals(ch.cyberduck.core.cdn.Distribution.DOWNLOAD)) {
            cf.deleteDistribution(distribution.getId());
        } else if (distribution.getMethod().equals(ch.cyberduck.core.cdn.Distribution.CUSTOM) || distribution.getMethod().equals(ch.cyberduck.core.cdn.Distribution.WEBSITE_CDN)) {
            cf.deleteDistribution(distribution.getId());
        } else {
            throw new RuntimeException("Invalid distribution method:" + distribution.getMethod());
        }
    }
}

