/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cloud;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.i18n.Locale;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CloudPath
extends Path {
    private static Logger log = Logger.getLogger(CloudPath.class);

    public <T> CloudPath(T dict) {
        super(dict);
    }

    protected CloudPath(String parent, String name, int type) {
        super(parent, name, type);
    }

    protected CloudPath(String path, int type) {
        super(path, type);
    }

    protected CloudPath(String parent, Local local) {
        super(parent, local);
    }

    @Override
    public Path getParent() {
        CloudPath parent = (CloudPath)super.getParent();
        if (parent.isRoot()) {
            parent.attributes().setType(10);
        }
        if (parent.isContainer()) {
            parent.attributes().setType(10);
        }
        return parent;
    }

    @Override
    public boolean isContainer() {
        return super.getParent().isRoot();
    }

    @Override
    public String getContainerName() {
        if (this.isRoot()) {
            return null;
        }
        return this.getContainer().getName();
    }

    @Override
    public Path getContainer() {
        if (this.isRoot()) {
            return null;
        }
        CloudPath bucketname = this;
        while (!bucketname.isContainer()) {
            bucketname = (CloudPath)bucketname.getParent();
        }
        return bucketname;
    }

    @Override
    public String getKey() {
        if (this.isContainer()) {
            return null;
        }
        if (this.getAbsolute().startsWith(String.valueOf('/') + this.getContainerName())) {
            return this.getAbsolute().substring(this.getContainerName().length() + 2);
        }
        return null;
    }

    public abstract void readMetadata();

    public abstract void writeMetadata(Map<String, String> var1);

    @Override
    public void writeTimestamp(long created, long modified, long accessed) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readTimestamp() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeUnixPermission(Permission perm, boolean recursive) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readUnixPermission() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<AbstractPath.DescriptiveUrl> getHttpURLs() {
        Set<AbstractPath.DescriptiveUrl> list = super.getHttpURLs();
        list.add(new AbstractPath.DescriptiveUrl(this.toURL(), MessageFormat.format(Locale.localizedString("{0} URL"), this.getHost().getProtocol().getScheme().toUpperCase())));
        return list;
    }
}

