/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cloud;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.cloud.CloudSession;
import ch.cyberduck.core.http.HTTP4Session;
import ch.cyberduck.core.ssl.AbstractX509TrustManager;

public abstract class CloudHTTP4Session
extends HTTP4Session
implements CloudSession {
    protected CloudHTTP4Session(Host h) {
        super(h);
    }

    public boolean isUnixPermissionsSupported() {
        return false;
    }

    public boolean isTimestampSupported() {
        return false;
    }

    public String getContainerForHostname(String hostname) {
        if (hostname.equals(this.host.getProtocol().getDefaultHostname())) {
            return null;
        }
        if (hostname.endsWith(this.host.getProtocol().getDefaultHostname())) {
            return hostname.substring(0, hostname.length() - this.host.getProtocol().getDefaultHostname().length() - 1);
        }
        return null;
    }

    public String getHostnameForContainer(String container) {
        return container + "." + this.getHost().getHostname(true);
    }

    public AbstractX509TrustManager getTrustManager() {
        return this.getTrustManager(this.getHostnameForContainer(this.getHost().getCredentials().getUsername()));
    }

    public boolean isMetadataSupported() {
        return true;
    }
}

