/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cloud;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.cloud.CloudSession;
import ch.cyberduck.core.http.HTTP3Session;
import ch.cyberduck.core.ssl.AbstractX509TrustManager;

public abstract class CloudHTTP3Session
extends HTTP3Session
implements CloudSession {
    protected CloudHTTP3Session(Host h) {
        super(h);
    }

    public boolean isUnixPermissionsSupported() {
        return false;
    }

    public boolean isTimestampSupported() {
        return false;
    }

    public String getContainerForHostname(String hostname) {
        if (hostname.equals(this.host.getProtocol().getDefaultHostname())) {
            return null;
        }
        if (hostname.endsWith(this.host.getProtocol().getDefaultHostname())) {
            return hostname.substring(0, hostname.length() - this.host.getProtocol().getDefaultHostname().length() - 1);
        }
        return null;
    }

    public AbstractX509TrustManager getTrustManager() {
        return this.getTrustManager(this.getHostnameForContainer(this.getHost().getCredentials().getUsername()));
    }

    public String getHostnameForContainer(String container) {
        return container + "." + this.getHost().getHostname(true);
    }

    public boolean isMetadataSupported() {
        return true;
    }
}

