/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cf;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.ConnectionCanceledException;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Status;
import ch.cyberduck.core.StreamListener;
import ch.cyberduck.core.cdn.Distribution;
import ch.cyberduck.core.cf.CFSession;
import ch.cyberduck.core.cloud.CloudPath;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.io.BandwidthThrottle;
import com.rackspacecloud.client.cloudfiles.FilesContainerInfo;
import com.rackspacecloud.client.cloudfiles.FilesNotFoundException;
import com.rackspacecloud.client.cloudfiles.FilesObject;
import com.rackspacecloud.client.cloudfiles.FilesObjectMetaData;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.message.BasicHeader;
import org.apache.log4j.Logger;
import org.jets3t.service.utils.ServiceUtils;
import org.w3c.util.DateParser;
import org.w3c.util.InvalidDateException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CFPath
extends CloudPath {
    private static Logger log = Logger.getLogger(CFPath.class);
    private final CFSession session;

    public static PathFactory factory() {
        return new Factory();
    }

    protected CFPath(CFSession s, String parent, String name, int type) {
        super(parent, name, type);
        this.session = s;
    }

    protected CFPath(CFSession s, String path, int type) {
        super(path, type);
        this.session = s;
    }

    protected CFPath(CFSession s, String parent, Local file) {
        super(parent, file);
        this.session = s;
    }

    protected <T> CFPath(CFSession s, T dict) {
        super(dict);
        this.session = s;
    }

    @Override
    public CFSession getSession() {
        return this.session;
    }

    @Override
    public boolean exists() {
        if (this.isRoot()) {
            return true;
        }
        if (this.isContainer()) {
            try {
                return this.getSession().getClient().containerExists(this.getName());
            }
            catch (HttpException e) {
                log.warn((Object)("Container does not exist:" + this.getName()));
                return false;
            }
            catch (ConnectionCanceledException e) {
                log.warn((Object)e.getMessage());
            }
            catch (IOException e) {
                log.warn((Object)e.getMessage());
            }
        }
        return super.exists();
    }

    @Override
    public void readSize() {
        try {
            this.getSession().check();
            this.getSession().message(MessageFormat.format(Locale.localizedString("Getting size of {0}", "Status"), this.getName()));
            if (this.isContainer()) {
                this.attributes().setSize(this.getSession().getClient().getContainerInfo(this.getContainerName()).getTotalSize());
            } else if (this.attributes().isFile()) {
                this.attributes().setSize(Long.valueOf(this.getSession().getClient().getObjectMetaData(this.getContainerName(), this.getKey()).getContentLength()));
            }
        }
        catch (HttpException e) {
            this.error("Cannot read file attributes", e);
        }
        catch (IOException e) {
            this.error("Cannot read file attributes", e);
        }
    }

    @Override
    public void readChecksum() {
        if (this.attributes().isFile()) {
            try {
                this.getSession().check();
                this.getSession().message(MessageFormat.format(Locale.localizedString("Compute MD5 hash of {0}", "Status"), this.getName()));
                this.attributes().setChecksum(this.getSession().getClient().getObjectMetaData(this.getContainerName(), this.getKey()).getETag());
            }
            catch (HttpException e) {
                this.error("Cannot read file attributes", e);
            }
            catch (IOException e) {
                this.error("Cannot read file attributes", e);
            }
        }
    }

    @Override
    public void readTimestamp() {
        if (this.attributes().isFile()) {
            try {
                this.getSession().check();
                this.getSession().message(MessageFormat.format(Locale.localizedString("Getting timestamp of {0}", "Status"), this.getName()));
                try {
                    this.attributes().setModificationDate(ServiceUtils.parseRfc822Date((String)this.getSession().getClient().getObjectMetaData(this.getContainerName(), this.getKey()).getLastModified()).getTime());
                }
                catch (ParseException e) {
                    log.error((Object)e);
                }
            }
            catch (HttpException e) {
                this.error("Cannot read file attributes", e);
            }
            catch (IOException e) {
                this.error("Cannot read file attributes", e);
            }
        }
    }

    @Override
    public AttributedList<Path> list(AttributedList<Path> children) {
        block15: {
            if (this.attributes().isDirectory()) {
                try {
                    this.getSession().check();
                    this.getSession().message(MessageFormat.format(Locale.localizedString("Listing directory {0}", "Status"), this.getName()));
                    if (this.isRoot()) {
                        for (FilesContainerInfo container : this.getSession().getClient().listContainersInfo()) {
                            Path p = PathFactory.createPath(this.getSession(), this.getAbsolute(), container.getName(), 10);
                            p.attributes().setSize(container.getTotalSize());
                            p.attributes().setOwner(this.getSession().getClient().getUserName());
                            children.add(p);
                        }
                        this.getSession().cdn().clear();
                    } else {
                        List list;
                        int limit = Preferences.instance().getInteger("cf.list.limit");
                        String marker = null;
                        do {
                            list = this.getSession().getClient().listObjectsStartingWith(this.getContainerName(), this.isContainer() ? "" : this.getKey() + '/', null, -1, marker, Character.valueOf('/'));
                            for (FilesObject object : list) {
                                Path file = PathFactory.createPath(this.getSession(), this.getContainerName(), object.getName(), "application/directory".equals(object.getMimeType()) ? 2 : 1);
                                file.setParent(this);
                                if (file.attributes().isFile()) {
                                    file.attributes().setSize(object.getSize());
                                    file.attributes().setChecksum(object.getMd5sum());
                                    try {
                                        Date modified = DateParser.parse(object.getLastModified());
                                        if (null != modified) {
                                            file.attributes().setModificationDate(modified.getTime());
                                        }
                                    }
                                    catch (InvalidDateException e) {
                                        log.warn((Object)("Not ISO 8601 format:" + e.getMessage()));
                                    }
                                }
                                if (file.attributes().isDirectory()) {
                                    file.attributes().setPlaceholder(true);
                                    if (children.contains(file.getReference())) continue;
                                }
                                file.attributes().setOwner(this.attributes().getOwner());
                                children.add(file);
                                marker = object.getName();
                            }
                        } while (list.size() == limit);
                    }
                    this.getSession().setWorkdir(this);
                }
                catch (HttpException e) {
                    log.warn((Object)("Listing directory failed:" + e.getMessage()));
                    children.attributes().setReadable(false);
                    if (this.cache().isEmpty()) {
                        this.error(e.getMessage(), e);
                    }
                }
                catch (IOException e) {
                    log.warn((Object)("Listing directory failed:" + e.getMessage()));
                    children.attributes().setReadable(false);
                    if (!this.cache().isEmpty()) break block15;
                    this.error(e.getMessage(), e);
                }
            }
        }
        return children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void download(BandwidthThrottle throttle, StreamListener listener, boolean check) {
        if (!this.attributes().isFile()) return;
        OutputStream out = null;
        InputStream in = null;
        try {
            try {
                if (check) {
                    this.getSession().check();
                }
                if (null == (in = this.getSession().getClient().getObjectAsStream(this.getContainerName(), this.getKey()))) {
                    throw new IOException("Unable opening data stream");
                }
                Status status = this.status();
                status.setResume(false);
                out = this.getLocal().getOutputStream(status.isResume());
                this.download(in, out, throttle, listener);
            }
            catch (HttpException e) {
                this.error("Download failed", e);
                Object var8_10 = null;
                IOUtils.closeQuietly((InputStream)in);
                IOUtils.closeQuietly(out);
                return;
            }
            catch (IOException e) {
                this.error("Download failed", e);
                Object var8_11 = null;
                IOUtils.closeQuietly((InputStream)in);
                IOUtils.closeQuietly(out);
                return;
            }
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void upload(final BandwidthThrottle throttle, final StreamListener listener, boolean check) {
        if (this.attributes().isFile()) {
            try {
                InputStream in;
                if (check) {
                    this.getSession().check();
                }
                final Status status = this.status();
                status.setResume(false);
                String md5sum = null;
                if (Preferences.instance().getBoolean("cf.upload.metadata.md5")) {
                    this.getSession().message(MessageFormat.format(Locale.localizedString("Compute MD5 hash of {0}", "Status"), this.getName()));
                    md5sum = this.getLocal().attributes().getChecksum();
                }
                MessageDigest digest = null;
                if (!Preferences.instance().getBoolean("cf.upload.metadata.md5")) {
                    try {
                        digest = MessageDigest.getInstance("MD5");
                    }
                    catch (NoSuchAlgorithmException e) {
                        log.error((Object)("MD5 calculation disabled:" + e.getMessage()));
                    }
                }
                if (null == digest) {
                    log.warn((Object)"MD5 calculation disabled");
                    in = this.getLocal().getInputStream();
                } else {
                    in = new DigestInputStream(this.getLocal().getInputStream(), digest);
                }
                String etag = null;
                try {
                    HashMap<String, String> metadata = new HashMap<String, String>();
                    for (String m : Preferences.instance().getList("cf.metadata.default")) {
                        if (StringUtils.isBlank((String)m)) {
                            log.warn((Object)("Invalid header " + m));
                            continue;
                        }
                        if (!m.contains("=")) {
                            log.warn((Object)("Invalid header " + m));
                            continue;
                        }
                        int split = m.indexOf(61);
                        String name = m.substring(0, split);
                        if (StringUtils.isBlank((String)name)) {
                            log.warn((Object)("Missing key in " + m));
                            continue;
                        }
                        String value = m.substring(split + 1);
                        if (StringUtils.isEmpty((String)value)) {
                            log.warn((Object)("Missing value in " + m));
                            continue;
                        }
                        metadata.put(name, value);
                    }
                    etag = this.getSession().getClient().storeObjectAs(this.getContainerName(), this.getKey(), (HttpEntity)new AbstractHttpEntity(){
                        private boolean consumed = false;

                        public boolean isRepeatable() {
                            return false;
                        }

                        public Header getContentType() {
                            return new BasicHeader("Content-Type", CFPath.this.getLocal().getMimeType());
                        }

                        public long getContentLength() {
                            return CFPath.this.getLocal().attributes().getSize() - status.getCurrent();
                        }

                        public InputStream getContent() throws IOException, IllegalStateException {
                            return CFPath.this.getLocal().getInputStream();
                        }

                        public void writeTo(OutputStream out) throws IOException {
                            CFPath.this.upload(out, in, throttle, listener);
                            this.consumed = true;
                        }

                        public boolean isStreaming() {
                            return !this.consumed;
                        }

                        public void consumeContent() throws IOException {
                            this.consumed = true;
                            CFPath.this.getLocal().getInputStream().close();
                        }
                    }, metadata, md5sum);
                    Object var16_18 = null;
                }
                catch (Throwable throwable) {
                    Object var16_19 = null;
                    IOUtils.closeQuietly((InputStream)in);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)in);
                if (null != digest) {
                    this.getSession().message(MessageFormat.format(Locale.localizedString("Compute MD5 hash of {0}", "Status"), this.getName()));
                    String expectedETag = ServiceUtils.toHex((byte[])digest.digest());
                    if (!expectedETag.equals(etag)) {
                        throw new IOException("Mismatch between MD5 hash of uploaded data (" + expectedETag + ") and ETag returned (" + etag + ") for object key: " + this.getKey());
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Object upload was automatically verified, the calculated MD5 hash value matched the ETag returned: " + this.getKey()));
                    }
                }
            }
            catch (HttpException e) {
                this.error("Upload failed", e);
            }
            catch (IOException e) {
                this.error("Upload failed", e);
            }
        }
    }

    @Override
    public void mkdir() {
        if (this.attributes().isDirectory()) {
            try {
                this.getSession().check();
                this.getSession().message(MessageFormat.format(Locale.localizedString("Making directory {0}", "Status"), this.getName()));
                if (this.isContainer()) {
                    this.getSession().getClient().createContainer(this.getName());
                } else {
                    this.getSession().getClient().createFullPath(this.getContainerName(), this.getKey());
                }
                this.cache().put(this.getReference(), AttributedList.emptyList());
                this.getParent().invalidate();
            }
            catch (HttpException e) {
                this.error("Cannot create folder {0}", e);
            }
            catch (IOException e) {
                this.error("Cannot create folder {0}", e);
            }
        }
    }

    @Override
    public void delete() {
        try {
            this.getSession().check();
            String container = this.getContainerName();
            if (this.attributes().isFile()) {
                this.getSession().message(MessageFormat.format(Locale.localizedString("Deleting {0}", "Status"), this.getName()));
                this.getSession().getClient().deleteObject(container, this.getKey());
            } else if (this.attributes().isDirectory()) {
                for (AbstractPath i : this.children()) {
                    if (!this.getSession().isConnected()) break;
                    i.delete();
                }
                this.getSession().message(MessageFormat.format(Locale.localizedString("Deleting {0}", "Status"), this.getName()));
                if (this.isContainer()) {
                    this.getSession().getClient().deleteContainer(container);
                } else {
                    try {
                        this.getSession().getClient().deleteObject(container, this.getKey());
                    }
                    catch (FilesNotFoundException e) {
                        log.warn((Object)e.getMessage());
                    }
                }
            }
            this.getParent().invalidate();
        }
        catch (HttpException e) {
            this.error("Cannot delete {0}", e);
        }
        catch (IOException e) {
            this.error("Cannot delete {0}", e);
        }
    }

    @Override
    public void readMetadata() {
        if (this.attributes().isFile()) {
            try {
                this.getSession().check();
                this.getSession().message(MessageFormat.format(Locale.localizedString("Reading metadata of {0}", "Status"), this.getName()));
                FilesObjectMetaData meta = this.getSession().getClient().getObjectMetaData(this.getContainerName(), this.getKey());
                this.attributes().setMetadata(meta.getMetaData());
            }
            catch (HttpException e) {
                this.error("Cannot read file attributes", e);
            }
            catch (IOException e) {
                this.error("Cannot read file attributes", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeMetadata(Map<String, String> meta) {
        block6: {
            if (this.attributes().isFile()) {
                try {
                    try {
                        this.getSession().check();
                        this.getSession().message(MessageFormat.format(Locale.localizedString("Writing metadata of {0}", "Status"), this.getName()));
                        this.getSession().getClient().updateObjectMetadata(this.getContainerName(), this.getKey(), meta);
                    }
                    catch (HttpException e) {
                        this.error("Cannot write file attributes", e);
                        Object var4_3 = null;
                        this.attributes().clear(false, false, false, true);
                        break block6;
                    }
                    catch (IOException e) {
                        this.error("Cannot write file attributes", e);
                        Object var4_4 = null;
                        this.attributes().clear(false, false, false, true);
                    }
                    Object var4_2 = null;
                    this.attributes().clear(false, false, false, true);
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    this.attributes().clear(false, false, false, true);
                    throw throwable;
                }
            }
        }
    }

    @Override
    public void rename(AbstractPath renamed) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toHttpURL() {
        CFSession session = this.getSession();
        for (Distribution.Method method : session.cdn().getMethods()) {
            if (!session.cdn().isConfigured(method)) continue;
            Distribution distribution = session.cdn().read(session.cdn().getOrigin(method, this.getContainerName()), method);
            return distribution.getURL(this);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Factory
    extends PathFactory<CFSession> {
        private Factory() {
        }

        @Override
        protected Path create(CFSession session, String path, int type) {
            return new CFPath(session, path, type);
        }

        @Override
        protected Path create(CFSession session, String parent, String name, int type) {
            return new CFPath(session, parent, name, type);
        }

        @Override
        protected Path create(CFSession session, String parent, Local file) {
            return new CFPath(session, parent, file);
        }

        @Override
        protected <T> Path create(CFSession session, T dict) {
            return new CFPath(session, dict);
        }
    }
}

