/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.aquaticprime;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.PathFilter;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.aquaticprime.AbstractLicense;
import ch.cyberduck.core.aquaticprime.License;
import ch.cyberduck.core.aquaticprime.LicenseFactory;
import ch.cyberduck.core.i18n.Locale;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.NetworkInterface;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.jce.PKCS7SignedData;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class Receipt
extends AbstractLicense {
    private static Logger log = Logger.getLogger(Receipt.class);
    private static final int APPSTORE_VALIDATION_FAILURE = 173;
    private String name;

    public static void register() {
        LicenseFactory.addFactory(Factory.NATIVE_PLATFORM, new Factory());
    }

    public Receipt(Local file) {
        super(file);
    }

    public boolean verify() {
        block15: {
            try {
                Security.addProvider((Provider)new BouncyCastleProvider());
                PKCS7SignedData signature = new PKCS7SignedData(IOUtils.toByteArray((InputStream)new FileInputStream(this.getFile().getAbsolute())));
                signature.verify();
                CMSSignedData s = new CMSSignedData((InputStream)new FileInputStream(this.getFile().getAbsolute()));
                CMSProcessable signedContent = s.getSignedContent();
                byte[] originalContent = (byte[])signedContent.getContent();
                ASN1Object asn = ASN1Object.fromByteArray((byte[])originalContent);
                byte[] opaque = null;
                String bundleIdentifier = null;
                String bundleVersion = null;
                byte[] hash = null;
                if (asn instanceof DERSet) {
                    DERSet set = (DERSet)asn;
                    Enumeration enumeration = set.getObjects();
                    while (enumeration.hasMoreElements()) {
                        DEREncodable value;
                        DERSequence sequence;
                        DEREncodable type;
                        Object next = enumeration.nextElement();
                        if (!(next instanceof DERSequence) || !((type = (sequence = (DERSequence)next).getObjectAt(0)) instanceof DERInteger)) continue;
                        if (((DERInteger)type).getValue().intValue() == 2) {
                            value = sequence.getObjectAt(2);
                            if (!(value instanceof DEROctetString)) continue;
                            bundleIdentifier = new String(((DEROctetString)value).getOctets(), "utf-8");
                            continue;
                        }
                        if (((DERInteger)type).getValue().intValue() == 3) {
                            value = sequence.getObjectAt(2);
                            if (!(value instanceof DEROctetString)) continue;
                            bundleVersion = new String(((DEROctetString)value).getOctets(), "utf-8");
                            continue;
                        }
                        if (((DERInteger)type).getValue().intValue() == 4) {
                            value = sequence.getObjectAt(2);
                            if (!(value instanceof DEROctetString)) continue;
                            opaque = ((DEROctetString)value).getOctets();
                            continue;
                        }
                        if (((DERInteger)type).getValue().intValue() != 5 || !((value = sequence.getObjectAt(2)) instanceof DEROctetString)) continue;
                        hash = ((DEROctetString)value).getOctets();
                    }
                } else {
                    log.error((Object)("Expected set of attributes for:" + asn));
                    return false;
                }
                if (!StringUtils.equals((String)"ch.sudo.cyberduck", (String)StringUtils.trim(bundleIdentifier))) {
                    log.error((Object)"Bundle identifier in ASN set does not match");
                    return false;
                }
                if (!StringUtils.equals((String)Preferences.instance().getDefault("CFBundleShortVersionString"), (String)StringUtils.trim(bundleVersion))) {
                    log.warn((Object)"Bundle version in ASN set does not match");
                    return false;
                }
                NetworkInterface en0 = NetworkInterface.getByName("en0");
                if (null == en0) {
                    log.warn((Object)"No network interface en0");
                    break block15;
                }
                byte[] mac = en0.getHardwareAddress();
                if (null == mac) {
                    log.error((Object)"Cannot determine MAC address");
                    return true;
                }
                String hex = Hex.encodeHexString((byte[])mac);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Interface en0:" + hex));
                }
                MessageDigest digest = MessageDigest.getInstance("SHA-1");
                digest.update(mac);
                digest.update(opaque);
                digest.update(bundleIdentifier.getBytes(Charset.forName("utf-8")));
                byte[] result = digest.digest();
                if (Arrays.equals(result, hash)) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Valid receipt for Computer GUID:" + hex));
                    }
                    this.name = hex;
                    break block15;
                }
                log.error((Object)("Failed verfification. Hash with GUID " + hex + " does not match hash in receipt"));
                return false;
            }
            catch (Throwable e) {
                log.error((Object)("Unknown receipt validation error:" + e.getMessage()));
                return false;
            }
        }
        return true;
    }

    public boolean isReceipt() {
        return true;
    }

    public String getValue(String property) {
        if (StringUtils.isEmpty((String)this.name)) {
            log.warn((Object)"Need to validate first before hash is available");
            return "";
        }
        return this.name;
    }

    public String getName() {
        return Locale.localizedString("Unknown");
    }

    private static class Factory
    extends LicenseFactory {
        private Factory() {
        }

        protected License open(Local file) {
            Receipt l = new Receipt(file);
            if (!l.verify()) {
                System.exit(173);
            } else {
                Local support = LocalFactory.createLocal(Preferences.instance().getProperty("application.support.path"));
                file.copy(LocalFactory.createLocal(support, ((AbstractLicense)l).getName() + ".cyberduckreceipt"));
            }
            return l;
        }

        protected License open() {
            Iterator i$;
            Local receipt = LocalFactory.createLocal(Preferences.instance().getProperty("application.receipt.path"));
            if (receipt.exists() && (i$ = receipt.children(new PathFilter<Local>(){

                @Override
                public boolean accept(Local file) {
                    return "receipt".equals(file.getName());
                }
            }).iterator()).hasNext()) {
                Local key = (Local)i$.next();
                return this.open(key);
            }
            log.info((Object)"No receipt found");
            System.exit(173);
            return LicenseFactory.EMPTY_LICENSE;
        }

        protected License create() {
            return this.open();
        }
    }
}

