/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.aquaticprime;

import ch.cyberduck.core.Factory;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.PathFilter;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.aquaticprime.License;
import ch.cyberduck.core.aquaticprime.Receipt;
import ch.cyberduck.core.i18n.Locale;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LicenseFactory
extends Factory<License> {
    private static Logger log = Logger.getLogger(LicenseFactory.class);
    protected static final Map<Factory.Platform, LicenseFactory> factories = new HashMap<Factory.Platform, LicenseFactory>();
    public static final License EMPTY_LICENSE = new License(){

        public boolean verify() {
            return false;
        }

        public String getValue(String property) {
            return null;
        }

        public String getName() {
            return Locale.localizedString("Not a valid donation key", "License");
        }

        public boolean isReceipt() {
            return false;
        }

        public boolean equals(Object obj) {
            return EMPTY_LICENSE == obj;
        }

        public String toString() {
            return Locale.localizedString("Not a valid donation key", "License");
        }
    };

    public static void addFactory(Factory.Platform platform, LicenseFactory f) {
        factories.put(platform, f);
    }

    protected abstract License open(Local var1);

    protected License open() {
        Local support = LocalFactory.createLocal(Preferences.instance().getProperty("application.support.path"));
        if (support.exists()) {
            Iterator i$ = support.children(new PathFilter<Local>(){

                @Override
                public boolean accept(Local file) {
                    return "cyberducklicense".equals(FilenameUtils.getExtension((String)file.getName()));
                }
            }).iterator();
            if (i$.hasNext()) {
                Local key = (Local)i$.next();
                return this.open(key);
            }
            i$ = support.children(new PathFilter<Local>(){

                @Override
                public boolean accept(Local file) {
                    return "cyberduckreceipt".equals(FilenameUtils.getExtension((String)file.getName()));
                }
            }).iterator();
            if (i$.hasNext()) {
                Local key = (Local)i$.next();
                return new Receipt(key);
            }
        }
        log.info((Object)"No donation key found");
        return EMPTY_LICENSE;
    }

    public static License create(Local file) {
        if (!factories.containsKey(NATIVE_PLATFORM)) {
            throw new RuntimeException("No implementation for " + NATIVE_PLATFORM);
        }
        return factories.get(NATIVE_PLATFORM).open(file);
    }

    public static License find() {
        if (!factories.containsKey(NATIVE_PLATFORM)) {
            throw new RuntimeException("No implementation for " + NATIVE_PLATFORM);
        }
        return factories.get(NATIVE_PLATFORM).open();
    }
}

