/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Collection;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Transfer;
import ch.cyberduck.core.serializer.TransferReaderFactory;
import ch.cyberduck.core.serializer.TransferWriterFactory;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransferCollection
extends Collection<Transfer> {
    private static Logger log = Logger.getLogger(TransferCollection.class);
    private static TransferCollection instance;
    private Local file;
    private static final Object lock;
    private boolean locked = true;

    private TransferCollection(Local file) {
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TransferCollection defaultCollection() {
        Object object = lock;
        synchronized (object) {
            if (null == instance) {
                instance = new TransferCollection(LocalFactory.createLocal(Preferences.instance().getProperty("application.support.path"), "Queue.plist"));
            }
            return instance;
        }
    }

    @Override
    public void collectionItemAdded(Transfer item) {
        if (this.locked) {
            log.debug((Object)"Do not notify changes of locked collection");
            return;
        }
        super.collectionItemAdded(item);
    }

    @Override
    public boolean add(Transfer o) {
        boolean r = super.add(o);
        this.save();
        return r;
    }

    @Override
    public void add(int row, Transfer o) {
        super.add(row, o);
        this.save();
    }

    @Override
    public Transfer remove(int row) {
        return (Transfer)super.remove(row);
    }

    public void save() {
        this.save(this.file);
    }

    private void save(Local f) {
        log.debug((Object)"save");
        if (Preferences.instance().getBoolean("queue.save")) {
            f.getParent().mkdir(true);
            TransferWriterFactory.instance().write((Transfer)((Object)this), f);
        }
    }

    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void load() {
        this.load(this.file);
        this.locked = false;
        this.collectionLoaded();
    }

    private void load(Local f) {
        log.debug((Object)"load");
        if (f.exists()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Found Queue file: " + f.toString()));
            }
            this.addAll(TransferReaderFactory.instance().readCollection(f));
        }
    }

    public int numberOfRunningTransfers() {
        int running = 0;
        for (Transfer t : this) {
            if (null == t || !t.isRunning()) continue;
            ++running;
        }
        log.debug((Object)("numberOfRunningTransfers:" + running));
        return running;
    }

    public int numberOfQueuedTransfers() {
        int queued = 0;
        for (Transfer t : this) {
            if (null == t || !t.isQueued()) continue;
            ++queued;
        }
        log.debug((Object)("numberOfQueuedTransfers:" + queued));
        return queued;
    }

    public double getDataTransferred() {
        double size = 0.0;
        for (Transfer t : this) {
            if (!t.isRunning() && !t.isQueued()) continue;
            size += t.getTransferred();
        }
        return size;
    }

    public double getDataSize() {
        double size = 0.0;
        for (Transfer t : this) {
            if (!t.isRunning() && !t.isQueued()) continue;
            size += t.getSize();
        }
        return size;
    }

    static {
        lock = new Object();
    }
}

