/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AbstractProxy;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Native;
import ch.cyberduck.core.Proxy;
import ch.cyberduck.core.ProxyFactory;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.net.util.SubnetUtils;
import org.apache.log4j.Logger;

public class SystemConfigurationProxy
extends AbstractProxy
implements Proxy {
    private static Logger log = Logger.getLogger(SystemConfigurationProxy.class);
    private static boolean JNI_LOADED = false;

    public static void register() {
        ProxyFactory.addFactory(Factory.NATIVE_PLATFORM, new Factory());
    }

    private SystemConfigurationProxy() {
    }

    private static boolean loadNative() {
        if (!JNI_LOADED) {
            JNI_LOADED = Native.load("Proxy");
        }
        return JNI_LOADED;
    }

    public native boolean usePassiveFTPNative();

    public boolean usePassiveFTP() {
        if (!SystemConfigurationProxy.loadNative()) {
            return false;
        }
        return this.usePassiveFTPNative();
    }

    private boolean isHostExcluded(String hostname) {
        if (!SystemConfigurationProxy.loadNative()) {
            return false;
        }
        if (!hostname.contains(".") && this.isSimpleHostnameExcludedNative()) {
            return true;
        }
        for (String exception : this.getProxyExceptionsNative()) {
            if (StringUtils.isBlank((String)exception)) continue;
            if (this.matches(exception, hostname)) {
                return true;
            }
            try {
                SubnetUtils subnet = new SubnetUtils(exception);
                try {
                    String ip = Inet4Address.getByName(hostname).getHostAddress();
                    if (!subnet.getInfo().isInRange(ip)) continue;
                    return true;
                }
                catch (UnknownHostException e) {
                    log.warn((Object)e.getMessage());
                }
            }
            catch (IllegalArgumentException e) {
                log.debug((Object)("Invalid CIDR notation:" + e.getMessage()));
            }
        }
        return false;
    }

    public native String[] getProxyExceptionsNative();

    public native boolean isSimpleHostnameExcludedNative();

    public boolean isSOCKSProxyEnabled(Host host) {
        if (!SystemConfigurationProxy.loadNative()) {
            return false;
        }
        if (this.isHostExcluded(host.getHostname())) {
            return false;
        }
        return this.isSOCKSProxyEnabledNative();
    }

    public String getSOCKSProxyHost(Host host) {
        if (!SystemConfigurationProxy.loadNative()) {
            return null;
        }
        return this.getSOCKSProxyHostNative();
    }

    public int getSOCKSProxyPort(Host host) {
        if (!SystemConfigurationProxy.loadNative()) {
            return -1;
        }
        return this.getSOCKSProxyPortNative();
    }

    public boolean isHTTPProxyEnabled(Host host) {
        if (!SystemConfigurationProxy.loadNative()) {
            return false;
        }
        if (this.isHostExcluded(host.getHostname())) {
            return false;
        }
        return this.isHTTPProxyEnabledNative();
    }

    public String getHTTPProxyHost(Host host) {
        if (!SystemConfigurationProxy.loadNative()) {
            return null;
        }
        return this.getHTTPProxyHostNative();
    }

    public int getHTTPProxyPort(Host host) {
        if (!SystemConfigurationProxy.loadNative()) {
            return -1;
        }
        return this.getHTTPProxyPortNative();
    }

    public boolean isHTTPSProxyEnabled(Host host) {
        if (!SystemConfigurationProxy.loadNative()) {
            return false;
        }
        if (this.isHostExcluded(host.getHostname())) {
            return false;
        }
        return this.isHTTPSProxyEnabledNative();
    }

    public String getHTTPSProxyHost(Host host) {
        if (!SystemConfigurationProxy.loadNative()) {
            return null;
        }
        return this.getHTTPSProxyHostNative();
    }

    public int getHTTPSProxyPort(Host host) {
        if (!SystemConfigurationProxy.loadNative()) {
            return -1;
        }
        return this.getHTTPSProxyPortNative();
    }

    public native boolean isSOCKSProxyEnabledNative();

    public native String getSOCKSProxyHostNative();

    public native int getSOCKSProxyPortNative();

    public native boolean isHTTPProxyEnabledNative();

    public native String getHTTPProxyHostNative();

    public native int getHTTPProxyPortNative();

    public native boolean isHTTPSProxyEnabledNative();

    public native String getHTTPSProxyHostNative();

    public native int getHTTPSProxyPortNative();

    private static class Factory
    extends ProxyFactory {
        private Factory() {
        }

        protected Proxy create() {
            return new SystemConfigurationProxy();
        }
    }
}

