/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.i18n.Locale;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.NumberFormat;
import org.apache.log4j.Logger;

public class Status {
    private static Logger log = Logger.getLogger(Status.class);
    private boolean resume = false;
    private long current = 0L;
    private boolean canceled;
    private boolean complete = false;
    public static long KILO = -1L;
    public static long MEGA = -1L;
    public static long GIGA = -1L;
    private boolean selected = true;

    public static String getSizeAsString(double size) {
        return Status.getSizeAsString(size, false, true);
    }

    public static String getSizeAsString(double size, boolean number) {
        return Status.getSizeAsString(size, number, true);
    }

    public static String getSizeAsString(double size, boolean number, boolean bytes) {
        if (-1.0 == size) {
            return Locale.localizedString("Unknown size");
        }
        if (size < (double)KILO) {
            return (int)size + (bytes ? " B" : " bit");
        }
        StringBuilder formatted = new StringBuilder();
        if (size < (double)MEGA) {
            formatted.append(new BigDecimal(size).divide(new BigDecimal(KILO), 1, 4).toString()).append(bytes ? " KB" : " kbit");
        } else if (size < (double)GIGA) {
            formatted.append(new BigDecimal(size).divide(new BigDecimal(MEGA), 1, 4).toString()).append(bytes ? " MB" : " Mbit");
        } else {
            formatted.append(new BigDecimal(size).divide(new BigDecimal(GIGA), 1, 4).toString()).append(bytes ? " GB" : " Gbit");
        }
        if (number) {
            formatted.append(" (").append(NumberFormat.getInstance().format(size)).append(" bytes)");
        }
        return formatted.toString();
    }

    public static String getSpeedAsString(double size) {
        return Status.getSizeAsString(size, false, true);
    }

    public static String getRemainingAsString(double remaining) {
        StringBuilder b = new StringBuilder();
        if (remaining < 0.0) {
            return Locale.localizedString("Unknown");
        }
        if (remaining > 7200.0) {
            b.append(MessageFormat.format(Locale.localizedString("{0} hours remaining", "Status"), new BigDecimal(remaining).divide(new BigDecimal(3600), 1, 1).toString()));
        } else if (remaining > 120.0) {
            b.append(MessageFormat.format(Locale.localizedString("{0} minutes remaining", "Status"), String.valueOf((int)(remaining / 60.0))));
        } else {
            b.append(MessageFormat.format(Locale.localizedString("{0} seconds remaining", "Status"), String.valueOf((int)remaining)));
        }
        return b.toString();
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
        if (log.isInfoEnabled()) {
            log.info((Object)("Complete:" + complete + "," + this.getCurrent()));
        }
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setCanceled() {
        this.canceled = true;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public long getCurrent() {
        return this.current;
    }

    public void setCurrent(long current) {
        this.current = current;
    }

    public void addCurrent(long transferred) {
        this.current += transferred;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(Boolean selected) {
        this.selected = selected;
    }

    public Boolean getSelected() {
        return this.selected;
    }

    public void setResume(boolean resume) {
        if (!resume) {
            this.current = 0L;
        }
        this.resume = resume;
    }

    public boolean isResume() {
        return this.resume;
    }

    public void reset() {
        this.complete = false;
        this.canceled = false;
    }

    static {
        if (Preferences.instance().getBoolean("browser.filesize.decimal")) {
            KILO = 1000L;
            MEGA = 1000000L;
            GIGA = 1000000000L;
        } else {
            KILO = 1024L;
            MEGA = 0x100000L;
            GIGA = 0x40000000L;
        }
    }
}

