/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Session;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SessionFactory {
    private static Logger log = Logger.getLogger(SessionFactory.class);
    private static Map<Protocol, SessionFactory> factories = new HashMap<Protocol, SessionFactory>();
    private static Set<Protocol> protocols = new LinkedHashSet<Protocol>();

    protected abstract Session create(Host var1);

    public static void addFactory(Protocol protocol, SessionFactory f) {
        if (protocols.add(protocol)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Add factory for protocol " + protocol + ":" + f));
            }
            factories.put(protocol, f);
        }
    }

    public static Session createSession(Host h) {
        return factories.get(h.getProtocol()).create(h);
    }

    public static Set<Protocol> getRegisteredProtocols() {
        return protocols;
    }
}

