/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Transfer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.log4j.Logger;

public class Queue {
    protected static Logger log = Logger.getLogger(Transfer.class);
    private static Queue instance;
    private static final Object lock;
    private ArrayBlockingQueue<Transfer> overflow = new ArrayBlockingQueue(1, true);
    private List<Transfer> running = Collections.synchronizedList(new ArrayList());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Queue instance() {
        Object object = lock;
        synchronized (object) {
            if (null == instance) {
                instance = new Queue();
            }
            return instance;
        }
    }

    public void add(Transfer t) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("add:" + t));
        }
        if (this.running.size() >= Preferences.instance().getInteger("queue.maxtransfers")) {
            t.fireTransferQueued();
            if (log.isInfoEnabled()) {
                log.info((Object)("Queuing:" + t));
            }
            while (this.running.size() >= Preferences.instance().getInteger("queue.maxtransfers") && !t.isCanceled()) {
                try {
                    this.overflow.put(t);
                }
                catch (InterruptedException e) {
                    log.error((Object)e.getMessage());
                }
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Released from queue:" + t));
            }
            t.fireTransferResumed();
        }
        this.running.add(t);
    }

    public void remove(Transfer t) {
        if (this.running.remove(t)) {
            this.poll();
        } else {
            this.overflow.remove(t);
        }
    }

    public void resize() {
        log.debug((Object)"resize");
        for (int size = this.running.size(); size < Preferences.instance().getInteger("queue.maxtransfers"); ++size) {
            if (this.overflow.isEmpty()) {
                log.debug((Object)"No more waiting transfers in queue");
                break;
            }
            this.poll();
        }
    }

    private void poll() {
        log.debug((Object)"poll");
        this.overflow.poll();
    }

    static {
        lock = new Object();
    }
}

