/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.PathFilter;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Profile;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.SessionFactory;
import ch.cyberduck.core.serializer.ProtocolReaderFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocolFactory {
    private static Logger log = Logger.getLogger(ProtocolFactory.class);

    public static void register() {
        Protocol.FTP.register();
        Protocol.FTP_TLS.register();
        Protocol.SFTP.register();
        Protocol.WEBDAV.register();
        Protocol.WEBDAV_SSL.register();
        Protocol.IDISK.register();
        Protocol.S3_SSL.register();
        Protocol.S3.register();
        Protocol.GOOGLESTORAGE_SSL.register();
        Protocol.EUCALYPTUS.register();
        Protocol.CLOUDFILES.register();
        Protocol.SWIFT.register();
        Protocol.GDOCS_SSL.register();
        Protocol.AZURE_SSL.register();
        Protocol.DROPBOX_SSL.register();
        Local profiles = LocalFactory.createLocal(Preferences.instance().getProperty("application.support.path"), "Profiles");
        if (profiles.exists()) {
            for (Local profile : profiles.children(new PathFilter<Local>(){

                @Override
                public boolean accept(Local file) {
                    return "cyberduckprofile".equals(FilenameUtils.getExtension((String)file.getName()));
                }
            })) {
                Profile protocol = ProtocolReaderFactory.instance().read(profile);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Adding thirdparty protocol:" + protocol));
                }
                protocol.register();
            }
        }
    }

    public static List<Protocol> getKnownProtocols() {
        return ProtocolFactory.getKnownProtocols(true);
    }

    public static List<Protocol> getKnownProtocols(boolean filter) {
        ArrayList<Protocol> list = new ArrayList<Protocol>(SessionFactory.getRegisteredProtocols());
        if (filter) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Protocol protocol = (Protocol)iter.next();
                if (protocol.isEnabled()) continue;
                iter.remove();
            }
        }
        if (list.isEmpty()) {
            throw new RuntimeException("No protocols configured");
        }
        return list;
    }

    public static Protocol getDefaultProtocol(int port) {
        for (Protocol protocol : ProtocolFactory.getKnownProtocols(false)) {
            if (protocol.getDefaultPort() != port) continue;
            return protocol;
        }
        log.warn((Object)("Cannot find default protocol for port:" + port));
        return ProtocolFactory.forName(Preferences.instance().getProperty("connection.protocol.default"));
    }

    public static Protocol forName(String identifier) {
        return ProtocolFactory.forName(identifier, identifier);
    }

    public static Protocol forName(String identifier, String vendor) {
        for (Protocol protocol : ProtocolFactory.getKnownProtocols(false)) {
            if (!protocol.getIdentifier().equals(identifier) || !protocol.getVendor().equals(vendor)) continue;
            return protocol;
        }
        log.fatal((Object)("Unknown protocol:" + identifier));
        return ProtocolFactory.forName(Preferences.instance().getProperty("connection.protocol.default"));
    }

    public static Protocol forScheme(String scheme) {
        for (Protocol protocol : ProtocolFactory.getKnownProtocols(false)) {
            for (int k = 0; k < protocol.getSchemes().length; ++k) {
                if (!protocol.getSchemes()[k].equals(scheme)) continue;
                return protocol;
            }
        }
        log.fatal((Object)("Unknown scheme:" + scheme));
        return ProtocolFactory.forName(Preferences.instance().getProperty("connection.protocol.default"));
    }

    public static boolean isURL(String str) {
        if (StringUtils.isNotBlank((String)str)) {
            for (Protocol protocol : ProtocolFactory.getKnownProtocols(false)) {
                String[] schemes;
                for (String scheme : schemes = protocol.getSchemes()) {
                    if (!str.startsWith(scheme + "://")) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

