/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.Serializable;
import ch.cyberduck.core.SessionFactory;
import ch.cyberduck.core.serializer.Deserializer;
import ch.cyberduck.core.serializer.DeserializerFactory;
import ch.cyberduck.core.serializer.Serializer;
import ch.cyberduck.core.serializer.SerializerFactory;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Profile
extends Protocol
implements Serializable {
    private static Logger log = Logger.getLogger(Profile.class);
    private Deserializer dict;
    private Protocol parent;

    public <T> Profile(T dict) {
        this.init(dict);
    }

    private Profile() {
    }

    @Override
    public <T> void init(T serialized) {
        this.dict = DeserializerFactory.createDeserializer(serialized);
        this.parent = ProtocolFactory.forName(this.dict.stringForKey("Protocol"));
    }

    @Override
    public <T> T getAsDictionary() {
        Serializer dict = SerializerFactory.createSerializer();
        dict.setStringForKey("Protocol", this.parent.getIdentifier());
        dict.setStringForKey("Vendor", this.getVendor());
        dict.setStringForKey("Description", this.getDescription());
        dict.setStringForKey("Default Hostname", this.getDefaultHostname());
        dict.setStringForKey("Default Port", String.valueOf(this.getDefaultPort()));
        dict.setStringForKey("Username Placeholder", this.getUsernamePlaceholder());
        dict.setStringForKey("Password Placeholder", this.getPasswordPlaceholder());
        return dict.getSerialized();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof Profile) {
            return super.equals(other);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ("profile-" + this.getIdentifier()).hashCode();
    }

    public Protocol getProtocol() {
        return this.parent;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    private String getValue(String key) {
        String value = this.dict.stringForKey(key);
        if (StringUtils.isBlank((String)value)) {
            log.warn((Object)("No value for key:" + key));
        }
        return value;
    }

    @Override
    public String getIdentifier() {
        return this.parent.getIdentifier();
    }

    @Override
    public String getUsernamePlaceholder() {
        String v = this.getValue("Username Placeholder");
        if (StringUtils.isBlank((String)v)) {
            return this.parent.getUsernamePlaceholder();
        }
        return v;
    }

    @Override
    public String getPasswordPlaceholder() {
        String v = this.getValue("Password Placeholder");
        if (StringUtils.isBlank((String)v)) {
            return this.parent.getPasswordPlaceholder();
        }
        return v;
    }

    @Override
    public String getDefaultHostname() {
        String v = this.getValue("Default Hostname");
        if (StringUtils.isBlank((String)v)) {
            return this.parent.getDefaultHostname();
        }
        return v;
    }

    @Override
    public String getVendor() {
        String v = this.getValue("Vendor");
        if (StringUtils.isBlank((String)v)) {
            return this.parent.getVendor();
        }
        return v;
    }

    @Override
    public String getDescription() {
        String v = this.getValue("Description");
        if (StringUtils.isBlank((String)v)) {
            return this.parent.getDescription();
        }
        return v;
    }

    @Override
    public int getDefaultPort() {
        String v = this.getValue("Default Port");
        if (StringUtils.isBlank((String)v)) {
            return this.parent.getDefaultPort();
        }
        try {
            return Integer.valueOf(v);
        }
        catch (NumberFormatException e) {
            log.warn((Object)("Port is not a number:" + e.getMessage()));
            return this.parent.getDefaultPort();
        }
    }

    @Override
    public String getName() {
        return this.parent.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String icon() {
        String v = this.getValue("Icon");
        if (StringUtils.isBlank((String)v)) {
            return this.parent.favicon();
        }
        byte[] favicon = Base64.decodeBase64((String)v);
        Local file = LocalFactory.createLocal(Preferences.instance().getProperty("tmp.dir"), this.getIdentifier() + ".ico");
        try {
            OutputStream out = file.getOutputStream(false);
            try {
                IOUtils.write((byte[])favicon, (OutputStream)out);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)out);
            }
            return file.getAbsolute();
        }
        catch (IOException e) {
            log.error((Object)("Error writing temporary file:" + e.getMessage()));
            return this.parent.favicon();
        }
    }

    @Override
    public String favicon() {
        return this.icon();
    }

    @Override
    public String disk() {
        return this.parent.disk();
    }

    @Override
    public boolean isSecure() {
        return this.parent.isSecure();
    }

    @Override
    public boolean isHostnameConfigurable() {
        return false;
    }

    @Override
    public boolean isWebUrlConfigurable() {
        return this.parent.isHostnameConfigurable();
    }

    @Override
    public String getScheme() {
        return this.parent.getScheme();
    }

    @Override
    public String[] getSchemes() {
        return this.parent.getSchemes();
    }

    @Override
    public boolean isPortConfigurable() {
        return this.parent.isPortConfigurable();
    }

    @Override
    public boolean isEncodingConfigurable() {
        return this.parent.isEncodingConfigurable();
    }

    @Override
    public boolean isConnectModeConfigurable() {
        return this.parent.isConnectModeConfigurable();
    }

    @Override
    public boolean isAnonymousConfigurable() {
        return this.parent.isAnonymousConfigurable();
    }

    @Override
    public boolean isUTCTimezone() {
        return this.parent.isUTCTimezone();
    }

    @Override
    public boolean validate(Credentials credentials) {
        return this.parent.validate(credentials);
    }

    @Override
    public SessionFactory getSessionFactory() {
        return this.parent.getSessionFactory();
    }

    @Override
    public PathFactory getPathFactory() {
        return this.parent.getPathFactory();
    }
}

