/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Acl;
import ch.cyberduck.core.Attributes;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.Serializable;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.serializer.Deserializer;
import ch.cyberduck.core.serializer.DeserializerFactory;
import ch.cyberduck.core.serializer.Serializer;
import ch.cyberduck.core.serializer.SerializerFactory;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathAttributes
extends Attributes
implements Serializable {
    private static Logger log = Logger.getLogger(PathAttributes.class);
    private long size = -1L;
    private long modified = -1L;
    private long accessed = -1L;
    private long created = -1L;
    private String owner;
    private String group;
    private int type = 1;
    private Permission permission = Permission.EMPTY;
    private Acl acl = Acl.EMPTY;
    private String checksum;
    private String storageClass;
    private String versionId;
    private boolean duplicate;
    private long revision;
    private boolean placeholder;
    private Map<String, String> metadata = Collections.emptyMap();

    public PathAttributes() {
    }

    public <T> PathAttributes(T dict) {
        this.init(dict);
    }

    @Override
    public <T> void init(T serialized) {
        Object duplicateObj;
        Object versionObj;
        Object permissionObj;
        String modifiedObj;
        String sizeObj;
        Deserializer dict = DeserializerFactory.createDeserializer(serialized);
        String typeObj = dict.stringForKey("Type");
        if (typeObj != null) {
            this.type = Integer.parseInt(typeObj);
        }
        if ((sizeObj = dict.stringForKey("Size")) != null) {
            this.size = Long.parseLong(sizeObj);
        }
        if ((modifiedObj = dict.stringForKey("Modified")) != null) {
            this.modified = Long.parseLong(modifiedObj);
        }
        if ((permissionObj = dict.objectForKey("Permission")) != null) {
            this.permission = new Permission(permissionObj);
        }
        if ((versionObj = dict.objectForKey("Version")) != null) {
            this.versionId = versionObj.toString();
        }
        if ((duplicateObj = dict.objectForKey("Duplicate")) != null) {
            this.duplicate = Boolean.valueOf(duplicateObj.toString());
        }
    }

    @Override
    public <T> T getAsDictionary() {
        Serializer dict = SerializerFactory.createSerializer();
        dict.setStringForKey(String.valueOf(this.type), "Type");
        if (this.size != -1L) {
            dict.setStringForKey(String.valueOf(this.size), "Size");
        }
        if (this.modified != -1L) {
            dict.setStringForKey(String.valueOf(this.modified), "Modified");
        }
        if (StringUtils.isNotBlank((String)this.versionId)) {
            dict.setStringForKey(this.versionId, "Version");
        }
        dict.setStringForKey(String.valueOf(this.duplicate), "Duplicate");
        return dict.getSerialized();
    }

    public void setSize(long size) {
        this.size = size;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public long getModificationDate() {
        return this.modified;
    }

    public void setModificationDate(long millis) {
        this.modified = millis;
    }

    @Override
    public long getCreationDate() {
        return this.created;
    }

    public void setCreationDate(long millis) {
        this.created = millis;
    }

    @Override
    public long getAccessedDate() {
        return this.accessed;
    }

    public void setAccessedDate(long millis) {
        this.accessed = millis;
    }

    public void setPermission(Permission p) {
        this.permission = p;
    }

    @Override
    public Permission getPermission() {
        return this.permission;
    }

    public Acl getAcl() {
        return this.acl;
    }

    public void setAcl(Acl acl) {
        this.acl = acl;
    }

    public void setType(int type) {
        this.type = type;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public boolean isVolume() {
        return (this.type & 8) == 8;
    }

    @Override
    public boolean isDirectory() {
        return (this.type & 2) == 2 || this.isVolume();
    }

    @Override
    public boolean isFile() {
        return (this.type & 1) == 1;
    }

    @Override
    public boolean isSymbolicLink() {
        return (this.type & 4) == 4;
    }

    public void setOwner(String o) {
        this.owner = o;
    }

    @Override
    public String getOwner() {
        if (null == this.owner) {
            return Locale.localizedString("Unknown");
        }
        return this.owner;
    }

    public void setGroup(String g) {
        this.group = g;
    }

    @Override
    public String getGroup() {
        if (null == this.group) {
            return Locale.localizedString("Unknown");
        }
        return this.group;
    }

    @Override
    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public void setStorageClass(String redundancy) {
        this.storageClass = redundancy;
    }

    @Override
    public String getVersionId() {
        return this.versionId;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public void setRevision(long revision) {
        this.revision = revision;
    }

    @Override
    public String getRevision() {
        return String.valueOf(this.revision);
    }

    @Override
    public boolean isDuplicate() {
        return this.duplicate;
    }

    public void setDuplicate(boolean duplicate) {
        this.duplicate = duplicate;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public boolean isPlaceholder() {
        return this.placeholder;
    }

    public void setPlaceholder(boolean placeholder) {
        this.placeholder = placeholder;
    }

    public void clear() {
        this.clear(true, true, true, true);
    }

    public void clear(boolean timestamp, boolean size, boolean permissions, boolean metadata) {
        if (timestamp) {
            this.setModificationDate(-1L);
            this.setCreationDate(-1L);
            this.setAccessedDate(-1L);
        }
        if (size) {
            this.setSize(-1L);
        }
        if (permissions) {
            this.setPermission(Permission.EMPTY);
            this.setAcl(Acl.EMPTY);
        }
        if (metadata) {
            this.setMetadata(Collections.<String, String>emptyMap());
        }
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof PathAttributes) {
            PathAttributes attr = (PathAttributes)other;
            if (this.getType() != attr.getType()) {
                return false;
            }
            if (this.getSize() != attr.getSize()) {
                return false;
            }
            if (this.getModificationDate() != attr.getModificationDate()) {
                return false;
            }
            return this.getPermission().equals(attr.getPermission());
        }
        return super.equals(other);
    }
}

