/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import java.text.CollationKey;
import java.text.Collator;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.Locale;

public class NaturalOrderCollator
extends Collator {
    private Collator collator;

    public NaturalOrderCollator() {
        this(Locale.getDefault());
    }

    public NaturalOrderCollator(Locale locale) {
        this.collator = Collator.getInstance(locale);
        if (this.collator instanceof RuleBasedCollator) {
            String rules = ((RuleBasedCollator)this.collator).getRules();
            int pos = rules.indexOf(",'-'");
            int primaryRelationPos = rules.indexOf(60);
            if (primaryRelationPos == rules.indexOf("'<'")) {
                primaryRelationPos = rules.indexOf(60, primaryRelationPos + 2);
            }
            if (pos != -1 && pos < primaryRelationPos) {
                rules = rules.substring(0, pos) + rules.substring(pos + 4, primaryRelationPos) + "<'-'" + rules.substring(primaryRelationPos);
            }
            pos = rules.indexOf(";' '");
            primaryRelationPos = rules.indexOf(60);
            if (primaryRelationPos == rules.indexOf("'<'")) {
                primaryRelationPos = rules.indexOf(60, primaryRelationPos + 2);
            }
            if (pos != -1 && pos < primaryRelationPos) {
                rules = rules.substring(0, pos) + rules.substring(pos + 4, primaryRelationPos) + "<' '" + rules.substring(primaryRelationPos);
            }
            try {
                this.collator = new RuleBasedCollator(rules);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
    }

    public int compare(String source, String target) {
        return this.collator.compare(this.expandNumbers(source), this.expandNumbers(target));
    }

    public CollationKey getCollationKey(String source) {
        return this.collator.getCollationKey(this.expandNumbers(source));
    }

    public boolean equals(Object o) {
        if (o instanceof NaturalOrderCollator) {
            NaturalOrderCollator that = (NaturalOrderCollator)o;
            return this.collator.equals(that.collator);
        }
        return false;
    }

    public int hashCode() {
        return this.collator.hashCode();
    }

    private String expandNumbers(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder out = new StringBuilder();
        StringBuilder digits = new StringBuilder();
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char ch = s.charAt(i);
            if (ch >= '0' && ch <= '9') {
                digits.append(ch);
                continue;
            }
            if (digits.length() != 0) {
                if (digits.length() < 10) {
                    out.append("00");
                    out.append(digits.length());
                } else if (digits.length() < 100) {
                    out.append("0");
                    out.append(digits.length());
                } else if (digits.length() < 1000) {
                    out.append(digits.length());
                } else if (digits.length() > 999) {
                    out.append("999");
                }
                out.append(digits.toString());
                digits.delete(0, digits.length());
            }
            out.append(ch);
        }
        if (digits.length() != 0) {
            if (digits.length() < 10) {
                out.append("00");
                out.append(digits.length());
            } else if (digits.length() < 100) {
                out.append("0");
                out.append(digits.length());
            } else if (digits.length() < 1000) {
                out.append(digits.length());
            } else if (digits.length() > 999) {
                out.append("999");
            }
            out.append((CharSequence)digits);
        }
        return out.toString();
    }
}

