/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.ui.cocoa.foundation.NSBundle;
import org.apache.log4j.Logger;

public class Native {
    private static Logger log = Logger.getLogger(Native.class);
    private static final Object lock = new Object();

    private Native() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean load(String library) {
        Object object = lock;
        synchronized (object) {
            long l = System.currentTimeMillis();
            String path = Native.getPath(library);
            try {
                System.load(path);
                log.info((Object)("Loaded " + path + " in " + (System.currentTimeMillis() - l) + "ms"));
                return true;
            }
            catch (UnsatisfiedLinkError e) {
                log.error((Object)("Failed to load " + path + ":" + e.getMessage()), (Throwable)e);
                return false;
            }
        }
    }

    protected static String getPath(String name) {
        String lib = NSBundle.mainBundle().resourcePath() + "/Java/lib" + name + ".dylib";
        log.info((Object)("Locating library " + name + " at '" + lib + "'"));
        return lib;
    }
}

