/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Attributes;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.io.RepeatableFileInputStream;
import com.ibm.icu.text.Normalizer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jets3t.service.utils.ServiceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Local
extends AbstractPath {
    private static Logger log = Logger.getLogger(Local.class);
    private String path;
    private Cache<Local> cache;

    public Local(Local parent, String name) {
        this(parent.getAbsolute(), name);
    }

    public Local(String parent, String name) {
        this.setPath(parent, name);
    }

    public Local(String path) {
        this.setPath(path);
    }

    public Local(File path) {
        this.setPath(path.getAbsolutePath());
    }

    @Override
    public Attributes attributes() {
        return new LocalAttributes();
    }

    @Override
    public char getPathDelimiter() {
        return '/';
    }

    @Override
    public void touch() {
        try {
            if (new File(this.path).createNewFile()) {
                this.setIcon(0);
            }
        }
        catch (IOException e) {
            log.error((Object)e.getMessage());
        }
    }

    @Override
    public void symlink(String target) {
        log.warn((Object)("Touching file instead of creating symbolic link:" + this));
        this.touch();
    }

    @Override
    public void mkdir(boolean recursive) {
        if (recursive) {
            if (new File(this.path).mkdirs() && log.isInfoEnabled()) {
                log.info((Object)("Created directory " + this.getAbsolute()));
            }
        } else {
            this.mkdir();
        }
    }

    @Override
    public void mkdir() {
        if (new File(this.path).mkdir() && log.isInfoEnabled()) {
            log.info((Object)("Created directory " + this.getAbsolute()));
        }
    }

    public abstract void setIcon(int var1);

    @Override
    public void delete() {
        this.delete(true);
    }

    public void delete(boolean trash) {
        if (trash) {
            this.trash();
        } else if (!new File(this.path).delete()) {
            log.warn((Object)("Delete failed:" + this.getAbsolute()));
        }
    }

    public abstract void trash();

    public abstract boolean reveal();

    @Override
    public boolean isCached() {
        return false;
    }

    public Cache<Local> cache() {
        if (null == this.cache) {
            this.cache = new Cache();
        }
        return this.cache;
    }

    public AttributedList<Local> list() {
        AttributedList<Local> children = new AttributedList<Local>();
        File[] files = new File(this.path).listFiles();
        if (null == files) {
            log.error((Object)"new File(path).listFiles == null");
            return children;
        }
        for (File file : files) {
            children.add(LocalFactory.createLocal(file));
        }
        return children;
    }

    @Override
    public String kind() {
        if (this.attributes().isDirectory()) {
            return Locale.localizedString("Folder");
        }
        String extension = this.getExtension();
        if (StringUtils.isEmpty((String)extension)) {
            return Locale.localizedString("Unknown");
        }
        return Locale.localizedString("File");
    }

    @Override
    public String getAbsolute() {
        return new File(this.path).getAbsolutePath();
    }

    public String getAbbreviatedPath() {
        return this.getAbsolute();
    }

    @Override
    public AbstractPath getSymlinkTarget() {
        try {
            return LocalFactory.createLocal(this, new File(this.path).getCanonicalPath());
        }
        catch (IOException e) {
            log.error((Object)e.getMessage());
            return null;
        }
    }

    @Override
    public String getName() {
        return new File(this.path).getName();
    }

    @Override
    public AbstractPath getParent() {
        return LocalFactory.createLocal(new File(this.path).getParentFile());
    }

    @Override
    public boolean exists() {
        return new File(this.path).exists();
    }

    @Override
    protected void setPath(String name) {
        String normalized = name;
        if (Preferences.instance().getBoolean("local.normalize.unicode") && !Normalizer.isNormalized((String)normalized, (Normalizer.Mode)Normalizer.NFC, (int)32)) {
            normalized = Normalizer.normalize((String)normalized, (Normalizer.Mode)Normalizer.NFC, (int)32);
            if (log.isInfoEnabled()) {
                log.info((Object)("Normalized local path '" + name + "' to '" + normalized + "'"));
            }
        }
        this.path = normalized;
    }

    @Override
    public void writeTimestamp(long created, long modified, long accessed) {
        if (!new File(this.path).setLastModified(modified)) {
            log.warn((Object)("Write modification date failed:" + this.getAbsolute()));
        }
    }

    @Override
    public abstract void writeUnixPermission(Permission var1, boolean var2);

    @Override
    public void rename(AbstractPath renamed) {
        if (!new File(this.path).renameTo(new File(renamed.getAbsolute()))) {
            log.warn((Object)("Rename failed:" + renamed.getAbsolute()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void copy(AbstractPath copy) {
        if (copy.equals(this)) {
            log.warn((Object)(this.getName() + " and " + copy.getName() + " are identical. Not copied."));
            return;
        }
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            try {
                in = new FileInputStream(new File(this.path));
                out = new FileOutputStream(copy.getAbsolute());
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            catch (IOException e) {
                log.error((Object)e.getMessage());
                Object var6_5 = null;
                IOUtils.closeQuietly((InputStream)in);
                IOUtils.closeQuietly(out);
                return;
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)out);
    }

    public int hashCode() {
        return new File(this.path).getAbsolutePath().hashCode();
    }

    public boolean equals(Object o) {
        if (null == o) {
            return false;
        }
        if (o instanceof Local) {
            Local other = (Local)o;
            return this.getAbsolute().equalsIgnoreCase(other.getAbsolute());
        }
        return false;
    }

    public String toString() {
        return this.getAbsolute();
    }

    @Override
    public String toURL() {
        try {
            return new File(this.path).toURI().toURL().toString();
        }
        catch (MalformedURLException e) {
            log.error((Object)e.getMessage());
            return null;
        }
    }

    public abstract boolean open();

    public abstract void bounce();

    public String getDefaultApplication() {
        return null;
    }

    public List<String> getDefaultApplications() {
        return Collections.emptyList();
    }

    public abstract void setQuarantine(String var1, String var2);

    public abstract void setWhereFrom(String var1);

    public InputStream getInputStream() throws FileNotFoundException {
        return new RepeatableFileInputStream(new File(this.path));
    }

    public OutputStream getOutputStream(boolean resume) throws FileNotFoundException {
        return new FileOutputStream(new File(this.path), resume);
    }

    public class LocalAttributes
    extends Attributes {
        public long getModificationDate() {
            return new File(Local.this.path).lastModified();
        }

        public long getCreationDate() {
            return this.getModificationDate();
        }

        public long getAccessedDate() {
            return this.getModificationDate();
        }

        public int getType() {
            int t;
            int n = t = this.isFile() ? 1 : 2;
            if (this.isSymbolicLink()) {
                return t | 4;
            }
            return t;
        }

        public long getSize() {
            if (this.isDirectory()) {
                return -1L;
            }
            return new File(Local.this.path).length();
        }

        public Permission getPermission() {
            return new LocalPermission();
        }

        public boolean isVolume() {
            return null == new File(Local.this.path).getParent();
        }

        public boolean isDirectory() {
            return new File(Local.this.path).isDirectory();
        }

        public boolean isFile() {
            return new File(Local.this.path).isFile();
        }

        public boolean isSymbolicLink() {
            if (!Local.this.exists()) {
                return false;
            }
            try {
                return !new File(Local.this.path).getAbsolutePath().equals(new File(Local.this.path).getCanonicalPath());
            }
            catch (IOException e) {
                return false;
            }
        }

        public String getChecksum() {
            try {
                return ServiceUtils.toHex((byte[])ServiceUtils.computeMD5Hash((InputStream)Local.this.getInputStream()));
            }
            catch (NoSuchAlgorithmException e) {
                log.error((Object)("MD5 failed:" + e.getMessage()));
            }
            catch (IOException e) {
                log.error((Object)("MD5 failed:" + e.getMessage()));
            }
            return null;
        }
    }

    public class LocalPermission
    extends Permission {
        public boolean isReadable() {
            return new File(Local.this.path).canRead();
        }

        public boolean isWritable() {
            return new File(Local.this.path).canWrite();
        }

        public boolean isExecutable() {
            return true;
        }

        public String toString() {
            return Locale.localizedString("Unknown");
        }
    }
}

