/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AbstractKeychain;
import ch.cyberduck.core.KeychainFactory;
import ch.cyberduck.core.Native;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.log4j.Logger;

public class Keychain
extends AbstractKeychain {
    private static Logger log = Logger.getLogger(Keychain.class);
    private static boolean JNI_LOADED = false;

    public static void register() {
        KeychainFactory.addFactory(Factory.NATIVE_PLATFORM, new Factory());
    }

    private Keychain() {
    }

    private static boolean loadNative() {
        if (!JNI_LOADED) {
            JNI_LOADED = Native.load("Keychain");
        }
        return JNI_LOADED;
    }

    public synchronized native String getInternetPasswordFromKeychain(String var1, int var2, String var3, String var4);

    public synchronized native String getPasswordFromKeychain(String var1, String var2);

    public synchronized native void addPasswordToKeychain(String var1, String var2, String var3);

    public synchronized native void addInternetPasswordToKeychain(String var1, int var2, String var3, String var4, String var5);

    private Object[] getEncoded(X509Certificate[] certs) {
        Object[] encoded = new Object[certs.length];
        for (int i = 0; i < encoded.length; ++i) {
            try {
                encoded[i] = certs[i].getEncoded();
                continue;
            }
            catch (CertificateEncodingException c) {
                log.error((Object)("Error getting encoded certificate: " + c.getMessage()));
            }
        }
        return encoded;
    }

    public String getPassword(String protocol, int port, String serviceName, String user) {
        if (!Keychain.loadNative()) {
            return null;
        }
        return this.getInternetPasswordFromKeychain(protocol, port, serviceName, user);
    }

    public String getPassword(String serviceName, String user) {
        if (!Keychain.loadNative()) {
            return null;
        }
        return this.getPasswordFromKeychain(serviceName, user);
    }

    public void addPassword(String serviceName, String user, String password) {
        if (!Keychain.loadNative()) {
            return;
        }
        this.addPasswordToKeychain(serviceName, user, password);
    }

    public void addPassword(String protocol, int port, String serviceName, String user, String password) {
        if (!Keychain.loadNative()) {
            return;
        }
        this.addInternetPasswordToKeychain(protocol, port, serviceName, user, password);
    }

    public synchronized boolean isTrusted(String hostname, X509Certificate[] certs) {
        if (!Keychain.loadNative()) {
            return false;
        }
        return this.isTrustedNative(hostname, this.getEncoded(certs));
    }

    private native boolean isTrustedNative(String var1, Object[] var2);

    public synchronized boolean displayCertificates(X509Certificate[] certificates) {
        if (!Keychain.loadNative()) {
            return false;
        }
        return this.displayCertificatesNative(this.getEncoded(certificates));
    }

    private native boolean displayCertificatesNative(Object[] var1);

    public synchronized X509Certificate chooseCertificate(String[] issuers, String prompt) {
        if (!Keychain.loadNative()) {
            return null;
        }
        byte[] cert = this.chooseCertificateNative(issuers, prompt);
        if (null == cert) {
            log.info((Object)"No certificate selected");
            return null;
        }
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            X509Certificate selected = (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(cert));
            if (log.isDebugEnabled()) {
                log.info((Object)("Selected certificate:" + selected));
            }
            return selected;
        }
        catch (CertificateException e) {
            log.error((Object)e.getMessage());
            return null;
        }
    }

    private native byte[] chooseCertificateNative(String[] var1, String var2);

    private static class Factory
    extends KeychainFactory {
        private Factory() {
        }

        protected AbstractKeychain create() {
            return new Keychain();
        }
    }
}

