/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.ReachabilityFactory;
import ch.cyberduck.core.Serializable;
import ch.cyberduck.core.ftp.FTPConnectMode;
import ch.cyberduck.core.serializer.Deserializer;
import ch.cyberduck.core.serializer.DeserializerFactory;
import ch.cyberduck.core.serializer.Serializer;
import ch.cyberduck.core.serializer.SerializerFactory;
import com.ibm.icu.text.IDNA;
import com.ibm.icu.text.StringPrepParseException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Host
implements Serializable {
    private static Logger log = Logger.getLogger(Host.class);
    private Protocol protocol = ProtocolFactory.forName(Preferences.instance().getProperty("connection.protocol.default"));
    private int port = -1;
    private String hostname = Preferences.instance().getProperty("connection.hostname.default");
    private Credentials credentials = new Credentials(){

        public String getUsernamePlaceholder() {
            return Host.this.getProtocol().getUsernamePlaceholder();
        }

        public String getPasswordPlaceholder() {
            return Host.this.getProtocol().getPasswordPlaceholder();
        }
    };
    private Credentials cdnCredentials = new Credentials(null, null){

        public String getUsernamePlaceholder() {
            return Protocol.S3_SSL.getUsernamePlaceholder();
        }

        public String getPasswordPlaceholder() {
            return Protocol.S3_SSL.getPasswordPlaceholder();
        }
    };
    private String uuid;
    private String punycode;
    private String nickname;
    private String defaultpath;
    private String workdir;
    private String encoding;
    private FTPConnectMode connectMode;
    private Integer maxConnections;
    private String downloadFolder;
    private TimeZone timezone;
    private String comment;
    private String webURL;
    private Date timestamp;

    public Host(String hostname) {
        this(ProtocolFactory.forName(Preferences.instance().getProperty("connection.protocol.default")), hostname);
    }

    public Host(String hostname, int port) {
        this(ProtocolFactory.getDefaultProtocol(port), hostname, port);
    }

    public Host(Protocol protocol, String hostname) {
        this(protocol, hostname, protocol.getDefaultPort());
    }

    public Host(Protocol protocol, String hostname, Credentials credentials) {
        this(protocol, hostname, protocol.getDefaultPort());
        this.credentials = credentials;
    }

    public Host(Protocol protocol, String hostname, int port) {
        this(protocol, hostname, port, null);
    }

    public Host(Protocol protocol, String hostname, int port, String defaultpath) {
        this.setProtocol(protocol);
        this.setPort(port);
        this.setHostname(hostname);
        this.setDefaultPath(defaultpath);
    }

    public <T> Host(T dict) {
        this.init(dict);
    }

    @Override
    public <T> void init(T serialized) {
        String accessObj;
        String urlObj;
        String commentObj;
        String timezoneObj;
        String downloadObj;
        String connObj;
        String connectModeObj;
        String encodingObj;
        String nicknameObj;
        String workdirObj;
        String pathObj;
        String portObj;
        String keyObj;
        String cdnCredentialsObj;
        String passwordObj;
        String usernameObj;
        String hostnameObj;
        String protocolObj;
        Deserializer dict = DeserializerFactory.createDeserializer(serialized);
        String uuidObj = dict.stringForKey("UUID");
        if (uuidObj != null) {
            this.setUuid(uuidObj.toString());
        }
        if ((protocolObj = dict.stringForKey("Protocol")) != null) {
            this.setProtocol(ProtocolFactory.forName(protocolObj.toString()));
        }
        if ((hostnameObj = dict.stringForKey("Hostname")) != null) {
            this.setHostname(hostnameObj.toString());
        }
        if ((usernameObj = dict.stringForKey("Username")) != null) {
            this.credentials.setUsername(usernameObj.toString());
        }
        if ((passwordObj = dict.stringForKey("Password")) != null) {
            this.credentials.setPassword(passwordObj.toString());
        }
        if ((cdnCredentialsObj = dict.stringForKey("CDN Credentials")) != null) {
            this.cdnCredentials.setUsername(cdnCredentialsObj.toString());
        }
        if ((keyObj = dict.stringForKey("Private Key File")) != null) {
            this.getCredentials().setIdentity(LocalFactory.createLocal(keyObj.toString()));
        }
        if ((portObj = dict.stringForKey("Port")) != null) {
            this.setPort(Integer.parseInt(portObj.toString()));
        }
        if ((pathObj = dict.stringForKey("Path")) != null) {
            this.setDefaultPath(pathObj.toString());
        }
        if ((workdirObj = dict.stringForKey("Workdir")) != null) {
            this.setWorkdir(workdirObj.toString());
        }
        if ((nicknameObj = dict.stringForKey("Nickname")) != null) {
            this.setNickname(nicknameObj.toString());
        }
        if ((encodingObj = dict.stringForKey("Encoding")) != null) {
            this.setEncoding(encodingObj.toString());
        }
        if ((connectModeObj = dict.stringForKey("FTP Connect Mode")) != null) {
            if (connectModeObj.toString().equals(FTPConnectMode.PORT.toString())) {
                this.setFTPConnectMode(FTPConnectMode.PORT);
            }
            if (connectModeObj.toString().equals(FTPConnectMode.PASV.toString())) {
                this.setFTPConnectMode(FTPConnectMode.PASV);
            }
        }
        if ((connObj = dict.stringForKey("Maximum Connections")) != null) {
            this.setMaxConnections(Integer.valueOf(connObj.toString()));
        }
        if ((downloadObj = dict.stringForKey("Download Folder")) != null) {
            this.setDownloadFolder(downloadObj.toString());
        }
        if ((timezoneObj = dict.stringForKey("Timezone")) != null) {
            this.setTimezone(TimeZone.getTimeZone(timezoneObj.toString()));
        }
        if ((commentObj = dict.stringForKey("Comment")) != null) {
            this.setComment(commentObj.toString());
        }
        if ((urlObj = dict.stringForKey("Web URL")) != null) {
            this.setWebURL(urlObj.toString());
        }
        if ((accessObj = dict.stringForKey("Access Timestamp")) != null) {
            this.setTimestamp(new Date(Long.parseLong(accessObj.toString())));
        }
    }

    @Override
    public <T> T getAsDictionary() {
        Serializer dict = SerializerFactory.createSerializer();
        dict.setStringForKey(this.getProtocol().getIdentifier(), "Protocol");
        dict.setStringForKey(this.getNickname(), "Nickname");
        dict.setStringForKey(this.getUuid(), "UUID");
        dict.setStringForKey(this.getHostname(), "Hostname");
        dict.setStringForKey(String.valueOf(this.getPort()), "Port");
        if (StringUtils.isNotBlank((String)this.getCredentials().getUsername())) {
            dict.setStringForKey(this.getCredentials().getUsername(), "Username");
        }
        if (StringUtils.isNotBlank((String)this.getCdnCredentials().getUsername())) {
            dict.setStringForKey(this.getCdnCredentials().getUsername(), "CDN Credentials");
        }
        if (StringUtils.isNotBlank((String)this.getDefaultPath())) {
            dict.setStringForKey(this.getDefaultPath(), "Path");
        }
        if (StringUtils.isNotBlank((String)this.getWorkdir())) {
            dict.setStringForKey(this.getWorkdir(), "Workdir");
        }
        if (StringUtils.isNotBlank((String)this.getEncoding())) {
            dict.setStringForKey(this.getEncoding(), "Encoding");
        }
        if (null != this.getCredentials().getIdentity()) {
            dict.setStringForKey(this.getCredentials().getIdentity().getAbbreviatedPath(), "Private Key File");
        }
        if ((this.getProtocol().equals(Protocol.FTP) || this.getProtocol().equals(Protocol.FTP_TLS)) && null != this.getFTPConnectMode()) {
            if (this.getFTPConnectMode().equals(FTPConnectMode.PORT)) {
                dict.setStringForKey(FTPConnectMode.PORT.toString(), "FTP Connect Mode");
            } else if (this.getFTPConnectMode().equals(FTPConnectMode.PASV)) {
                dict.setStringForKey(FTPConnectMode.PASV.toString(), "FTP Connect Mode");
            }
        }
        if (null != this.getMaxConnections()) {
            dict.setStringForKey(String.valueOf(this.getMaxConnections()), "Maximum Connections");
        }
        if (!this.isDefaultDownloadFolder()) {
            dict.setStringForKey(this.getDownloadFolder().getAbbreviatedPath(), "Download Folder");
        }
        if (null != this.getTimezone()) {
            dict.setStringForKey(this.getTimezone().getID(), "Timezone");
        }
        if (StringUtils.isNotBlank((String)this.getComment())) {
            dict.setStringForKey(this.getComment(), "Comment");
        }
        if (!this.isDefaultWebURL()) {
            dict.setStringForKey(this.getWebURL(), "Web URL");
        }
        if (null != this.getTimestamp()) {
            dict.setStringForKey(String.valueOf(this.getTimestamp().getTime()), "Access Timestamp");
        }
        return dict.getSerialized();
    }

    public static Host parse(String input) {
        int cut;
        input = input.trim();
        int begin = 0;
        Protocol protocol = null;
        if (input.indexOf("://", begin) != -1 && null != (protocol = ProtocolFactory.forScheme(input.substring(begin, cut = input.indexOf("://", begin))))) {
            begin += cut - begin + 3;
        }
        if (null == protocol) {
            protocol = ProtocolFactory.forName(Preferences.instance().getProperty("connection.protocol.default"));
        }
        String username = null;
        String password = null;
        username = protocol.equals(Protocol.FTP) ? Preferences.instance().getProperty("connection.login.anon.name") : Preferences.instance().getProperty("connection.login.name");
        if (input.lastIndexOf(64) != -1) {
            if (input.indexOf(58, begin) != -1 && input.lastIndexOf(64) > input.indexOf(58, begin)) {
                cut = input.indexOf(58, begin);
                username = input.substring(begin, cut);
                cut = input.lastIndexOf(64);
                password = input.substring(begin += username.length() + 1, cut);
                begin += password.length() + 1;
            } else {
                cut = input.lastIndexOf(64);
                username = input.substring(begin, cut);
                begin += username.length() + 1;
            }
        }
        String hostname = Preferences.instance().getProperty("connection.hostname.default");
        if (StringUtils.isNotBlank((String)input)) {
            hostname = input.substring(begin, input.length());
        }
        String path = null;
        int port = protocol.getDefaultPort();
        if (input.indexOf(58, begin) != -1) {
            cut = input.indexOf(58, begin);
            hostname = input.substring(begin, cut);
            begin += hostname.length() + 1;
            try {
                String portString;
                if (input.indexOf(47, begin) != -1) {
                    portString = input.substring(begin, input.indexOf(47, begin));
                    begin += portString.length();
                    try {
                        path = URLDecoder.decode(input.substring(begin, input.length()), "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        log.error((Object)e.getMessage());
                    }
                } else {
                    portString = input.substring(begin, input.length());
                }
                port = Integer.parseInt(portString);
            }
            catch (NumberFormatException e) {
                log.warn((Object)"Invalid port number given");
            }
        } else if (input.indexOf(47, begin) != -1) {
            cut = input.indexOf(47, begin);
            hostname = input.substring(begin, cut);
            begin += hostname.length();
            try {
                path = URLDecoder.decode(input.substring(begin, input.length()), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)e.getMessage());
            }
        }
        Host h = new Host(protocol, hostname, port, path);
        h.setCredentials(username, password);
        return h;
    }

    public void setDefaultPath(String defaultpath) {
        this.defaultpath = StringUtils.isBlank((String)defaultpath) ? null : StringUtils.remove((String)StringUtils.remove((String)defaultpath, (char)'\n'), (char)'\r').trim();
    }

    public String getDefaultPath() {
        return this.defaultpath;
    }

    public String getWorkdir() {
        return this.workdir;
    }

    public void setWorkdir(String workdir) {
        this.workdir = workdir;
    }

    public void setCredentials(String username, String password) {
        this.credentials.setUsername(username);
        this.credentials.setPassword(password);
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public Credentials getCdnCredentials() {
        return this.cdnCredentials;
    }

    public void setCdnCredentials(Credentials cdnCredentials) {
        this.cdnCredentials = cdnCredentials;
    }

    public void setProtocol(Protocol protocol) {
        log.debug((Object)("setProtocol:" + protocol));
        this.protocol = protocol != null ? protocol : ProtocolFactory.forName(Preferences.instance().getProperty("connection.protocol.default"));
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public String getUuid() {
        if (null == this.uuid) {
            this.uuid = UUID.randomUUID().toString();
        }
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getNickname() {
        return this.getNickname(false);
    }

    public String getNickname(boolean escape) {
        if (StringUtils.isEmpty((String)this.nickname)) {
            return this.getDefaultNickname();
        }
        if (escape) {
            return StringUtils.replace((String)this.nickname, (String)"/", (String)":");
        }
        return this.nickname;
    }

    private String getDefaultNickname() {
        if (StringUtils.isNotEmpty((String)this.getHostname())) {
            return this.getHostname() + " \u2013 " + this.getProtocol().getName();
        }
        return "";
    }

    public void setNickname(String nickname) {
        if (this.getDefaultNickname().equals(nickname)) {
            return;
        }
        this.nickname = nickname;
    }

    public String getHostname() {
        return this.getHostname(false);
    }

    public String getHostname(boolean punycode) {
        if (punycode && Preferences.instance().getBoolean("connection.hostname.idn")) {
            if (null == this.punycode && StringUtils.isNotEmpty((String)this.hostname)) {
                try {
                    String idn = IDNA.convertIDNToASCII((String)this.hostname, (int)0).toString();
                    if (log.isInfoEnabled()) {
                        log.info((Object)("IDN hostname for " + this.hostname + ":" + idn));
                    }
                    this.punycode = idn;
                }
                catch (StringPrepParseException e) {
                    log.error((Object)("Cannot convert hostname to IDNA:" + e.getMessage()));
                }
            }
            if (StringUtils.isNotEmpty((String)this.punycode)) {
                return this.punycode;
            }
        }
        return this.hostname;
    }

    public void setHostname(String hostname) {
        log.debug((Object)("setHostname:" + hostname));
        this.hostname = hostname.trim();
        this.punycode = null;
    }

    public void setPort(int port) {
        this.port = port;
        if (-1 == port) {
            this.port = this.getProtocol().getDefaultPort();
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setEncoding(String encoding) {
        log.debug((Object)("setEncoding:" + encoding));
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setFTPConnectMode(FTPConnectMode connectMode) {
        log.debug((Object)("setFTPConnectMode:" + connectMode));
        this.connectMode = connectMode;
    }

    public FTPConnectMode getFTPConnectMode() {
        return this.connectMode;
    }

    public void setMaxConnections(Integer n) {
        log.debug((Object)("setMaxConnections:" + n));
        this.maxConnections = n;
    }

    public Integer getMaxConnections() {
        return this.maxConnections;
    }

    public void setDownloadFolder(String folder) {
        log.debug((Object)("setDownloadFolder:" + folder));
        this.downloadFolder = LocalFactory.createLocal(folder).getAbbreviatedPath();
    }

    public Local getDownloadFolder() {
        if (null == this.downloadFolder) {
            return LocalFactory.createLocal(Preferences.instance().getProperty("queue.download.folder"));
        }
        return LocalFactory.createLocal(this.downloadFolder);
    }

    public boolean isDefaultDownloadFolder() {
        return null == this.downloadFolder;
    }

    public void setTimezone(TimeZone timezone) {
        log.debug((Object)("setTimezone:" + timezone));
        this.timezone = timezone;
    }

    public TimeZone getTimezone() {
        return this.timezone;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    public String getWebURL() {
        if (null == this.webURL) {
            return this.getDefaultWebURL();
        }
        String protocol = "^http(s)?://.*$";
        if (!this.webURL.matches("^http(s)?://.*$")) {
            this.webURL = "http://" + this.webURL;
        }
        return this.webURL;
    }

    public boolean isDefaultWebURL() {
        return this.getWebURL().equals(this.getDefaultWebURL());
    }

    public String getDefaultWebURL() {
        return "http://" + this.getHostname();
    }

    public void setWebURL(String webURL) {
        if (this.getDefaultWebURL().equals(webURL)) {
            this.webURL = null;
            return;
        }
        this.webURL = webURL;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public String getIp() throws UnknownHostException {
        try {
            return InetAddress.getByName(this.hostname).toString();
        }
        catch (UnknownHostException e) {
            throw new UnknownHostException(this.hostname + " cannot be resolved");
        }
    }

    public String toString() {
        return this.toURL();
    }

    public String toURL() {
        StringBuilder url = new StringBuilder(this.getProtocol().getScheme());
        url.append("://");
        if (StringUtils.isNotEmpty((String)this.getCredentials().getUsername())) {
            url.append(this.getCredentials().getUsername()).append("@");
        }
        url.append(this.getHostname(true));
        if (this.getPort() != this.getProtocol().getDefaultPort()) {
            url.append(":").append(this.getPort());
        }
        return url.toString();
    }

    public boolean equals(Object other) {
        if (null == other) {
            return false;
        }
        if (other instanceof Host) {
            return this.getUuid().equals(((Host)other).getUuid());
        }
        return super.equals(other);
    }

    public int hashCode() {
        return this.toURL().hashCode();
    }

    public boolean isReachable() {
        return ReachabilityFactory.instance().isReachable(this);
    }

    public void diagnose() {
        ReachabilityFactory.instance().diagnose(this);
    }
}

