/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AbstractStreamListener;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Collection;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFilter;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.Transfer;
import ch.cyberduck.core.TransferAction;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.serializer.Serializer;
import ch.cyberduck.ui.DateFormatterFactory;
import ch.cyberduck.ui.growl.Growl;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadTransfer
extends Transfer {
    private static Logger log = Logger.getLogger(DownloadTransfer.class);
    private final PathFilter<Path> exclusionRegexFilter = new PathFilter<Path>(){

        @Override
        public boolean accept(Path child) {
            if (Preferences.instance().getBoolean("queue.download.skip.enable")) {
                try {
                    if (Pattern.compile(Preferences.instance().getProperty("queue.download.skip.regex")).matcher(child.getName()).matches()) {
                        return false;
                    }
                }
                catch (PatternSyntaxException e) {
                    log.warn((Object)e.getMessage());
                }
            }
            return true;
        }
    };
    private final Transfer.TransferFilter OVERWRITE_FILTER = new DownloadTransferFilter(){

        public boolean accept(Path file) {
            if (file.attributes().isDirectory() && file.getLocal().exists()) {
                return false;
            }
            return super.accept(file);
        }

        public void prepare(Path file) {
            if (file.attributes().isFile()) {
                file.status().setResume(false);
            }
            super.prepare(file);
        }
    };
    private final Transfer.TransferFilter RESUME_FILTER = new DownloadTransferFilter(){

        public boolean accept(Path file) {
            if (file.attributes().isDirectory() && file.getLocal().exists()) {
                return false;
            }
            if (file.status().isComplete() || file.getLocal().attributes().getSize() == file.attributes().getSize()) {
                file.status().setComplete(true);
                return false;
            }
            return super.accept(file);
        }

        public void prepare(Path file) {
            if (file.attributes().isFile()) {
                boolean resume = file.getLocal().exists() && file.getLocal().attributes().getSize() > 0L;
                file.status().setResume(resume);
                long skipped = file.getLocal().attributes().getSize();
                file.status().setCurrent(skipped);
            }
            super.prepare(file);
        }
    };
    private final Transfer.TransferFilter RENAME_FILTER = new DownloadTransferFilter(){

        public void prepare(Path file) {
            if (file.attributes().isFile()) {
                file.status().setResume(false);
            }
            if (file.getLocal().exists() && file.getLocal().attributes().getSize() > 0L) {
                String parent = file.getLocal().getParent().getAbsolute();
                String filename = file.getName();
                int no = 0;
                while (file.getLocal().exists()) {
                    String proposal = FilenameUtils.getBaseName((String)filename) + "-" + ++no;
                    if (StringUtils.isNotBlank((String)FilenameUtils.getExtension((String)filename))) {
                        proposal = proposal + "." + FilenameUtils.getExtension((String)filename);
                    }
                    file.setLocal(LocalFactory.createLocal(parent, proposal));
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("Changed local name to:" + file.getLocal().getName()));
                }
            }
            super.prepare(file);
        }
    };
    private final Transfer.TransferFilter RENAME_EXISTING_FILTER = new DownloadTransferFilter(){

        public void prepare(Path file) {
            Local renamed = file.getLocal();
            while (renamed.exists()) {
                String proposal = MessageFormat.format(Preferences.instance().getProperty("queue.upload.file.rename.format"), FilenameUtils.getBaseName((String)file.getName()), DateFormatterFactory.instance().getLongFormat(System.currentTimeMillis(), false).replace('/', ':'), StringUtils.isNotEmpty((String)file.getExtension()) ? "." + file.getExtension() : "");
                renamed = LocalFactory.createLocal(renamed.getParent().getAbsolute(), proposal);
            }
            if (!renamed.equals(file.getLocal())) {
                file.getLocal().rename(renamed);
            }
            if (file.attributes().isFile()) {
                file.status().setResume(false);
            }
            super.prepare(file);
        }
    };
    private final DownloadTransferFilter SKIP_FILTER = new DownloadTransferFilter(){

        public boolean accept(Path file) {
            if (file.getLocal().exists()) {
                file.status().setComplete(true);
                return false;
            }
            return super.accept(file);
        }
    };

    public DownloadTransfer(Path root) {
        super(root);
    }

    public DownloadTransfer(List<Path> roots) {
        super(roots);
    }

    public <T> DownloadTransfer(T dict, Session s) {
        super(dict, s);
    }

    @Override
    protected void normalize() {
        log.debug((Object)"normalize");
        Collection<Path> normalized = new Collection<Path>();
        for (Path download : this.getRoots()) {
            if (!this.check()) {
                return;
            }
            this.getSession().message(MessageFormat.format(Locale.localizedString("Prepare {0}", "Status"), download.getName()));
            boolean duplicate = false;
            Iterator iter = normalized.iterator();
            while (iter.hasNext()) {
                Path n = (Path)iter.next();
                if (download.isChild(n)) {
                    duplicate = true;
                    break;
                }
                if (n.isChild(download)) {
                    iter.remove();
                }
                if (!download.getLocal().equals(n.getLocal())) continue;
                String parent = download.getLocal().getParent().getAbsolute();
                String filename = download.getName();
                int no = 0;
                do {
                    String proposal = FilenameUtils.getBaseName((String)filename) + "-" + ++no;
                    if (StringUtils.isNotBlank((String)FilenameUtils.getExtension((String)filename))) {
                        proposal = proposal + "." + FilenameUtils.getExtension((String)filename);
                    }
                    download.setLocal(LocalFactory.createLocal(parent, proposal));
                } while (download.getLocal().exists());
                if (!log.isInfoEnabled()) continue;
                log.info((Object)("Changed local name to:" + download.getName()));
            }
            if (duplicate) continue;
            normalized.add(download);
        }
        this.setRoots(normalized);
    }

    @Override
    public <T> T getAsDictionary() {
        Serializer dict = super.getSerializer();
        dict.setStringForKey(String.valueOf(0), "Kind");
        return dict.getSerialized();
    }

    @Override
    protected void init() {
        log.debug((Object)"init");
        this.bandwidth = new BandwidthThrottle(Preferences.instance().getFloat("queue.download.bandwidth.bytes"));
    }

    @Override
    public AttributedList<Path> children(Path parent) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("children:" + parent));
        }
        if (parent.attributes().isSymbolicLink() && this.isSymlinkSupported(parent)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Do not list children for symbolic link:" + parent));
            }
            return AttributedList.emptyList();
        }
        AttributedList<Path> list = parent.children(this.exclusionRegexFilter);
        for (Path download : list) {
            download.setLocal(LocalFactory.createLocal(parent.getLocal(), download.getLocal().getName()));
        }
        return list;
    }

    @Override
    public Transfer.TransferFilter filter(TransferAction action) {
        log.debug((Object)("filter:" + action));
        if (action.equals(TransferAction.ACTION_OVERWRITE)) {
            return this.OVERWRITE_FILTER;
        }
        if (action.equals(TransferAction.ACTION_RESUME)) {
            return this.RESUME_FILTER;
        }
        if (action.equals(TransferAction.ACTION_RENAME)) {
            return this.RENAME_FILTER;
        }
        if (action.equals(TransferAction.ACTION_RENAME_EXISTING)) {
            return this.RENAME_EXISTING_FILTER;
        }
        if (action.equals(TransferAction.ACTION_SKIP)) {
            return this.SKIP_FILTER;
        }
        if (action.equals(TransferAction.ACTION_CALLBACK)) {
            for (Path download : this.getRoots()) {
                if (!this.check()) {
                    return null;
                }
                if (!download.getLocal().exists() || download.getLocal().attributes().isDirectory() && 0 == download.getLocal().children().size() || download.getLocal().attributes().isFile() && download.getLocal().attributes().getSize() == 0L) continue;
                TransferAction result = this.prompt.prompt();
                return this.filter(result);
            }
            return this.filter(TransferAction.ACTION_OVERWRITE);
        }
        return super.filter(action);
    }

    @Override
    public TransferAction action(boolean resumeRequested, boolean reloadRequested) {
        log.debug((Object)("action:" + resumeRequested + "," + reloadRequested));
        if (resumeRequested) {
            return TransferAction.ACTION_RESUME;
        }
        if (reloadRequested) {
            return TransferAction.forName(Preferences.instance().getProperty("queue.download.reload.fileExists"));
        }
        return TransferAction.forName(Preferences.instance().getProperty("queue.download.fileExists"));
    }

    private boolean isSymlinkSupported(Path file) {
        if (Preferences.instance().getBoolean("path.symboliclink.resolve")) {
            return false;
        }
        AbstractPath target = file.getSymlinkTarget();
        for (Path root : this.roots) {
            if (!target.isChild(root)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void transfer(Path file) {
        log.debug((Object)("transfer:" + file));
        Local local = file.getLocal();
        if (file.attributes().isSymbolicLink() && this.isSymlinkSupported(file)) {
            String target = StringUtils.substringAfter((String)file.getSymlinkTarget().getAbsolute(), (String)(file.getParent().getAbsolute() + '/'));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Symlink " + file.getLocal() + ":" + target));
            }
            file.getLocal().symlink(target);
            file.status().setComplete(true);
        } else if (file.attributes().isFile()) {
            file.download(this.bandwidth, new AbstractStreamListener(){

                public void bytesReceived(long bytes) {
                    DownloadTransfer.this.transferred += (double)bytes;
                }
            });
        } else if (file.attributes().isDirectory()) {
            local.mkdir(true);
        }
        if (Preferences.instance().getBoolean("queue.download.changePermissions")) {
            Permission permission = Permission.EMPTY;
            if (Preferences.instance().getBoolean("queue.download.permissions.useDefault")) {
                if (file.attributes().isFile()) {
                    permission = new Permission(Preferences.instance().getInteger("queue.download.permissions.file.default"));
                }
                if (file.attributes().isDirectory()) {
                    permission = new Permission(Preferences.instance().getInteger("queue.download.permissions.folder.default"));
                }
            } else {
                permission = file.attributes().getPermission();
            }
            if (!Permission.EMPTY.equals(permission)) {
                if (file.attributes().isDirectory()) {
                    permission.getOwnerPermissions()[0] = true;
                    permission.getOwnerPermissions()[1] = true;
                    permission.getOwnerPermissions()[2] = true;
                }
                if (file.attributes().isFile()) {
                    permission.getOwnerPermissions()[0] = true;
                    permission.getOwnerPermissions()[1] = true;
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("Updating permissions:" + local + "," + permission));
                }
                local.writeUnixPermission(permission, false);
            }
        }
        if (Preferences.instance().getBoolean("queue.download.preserveDate") && file.attributes().getModificationDate() != -1L) {
            long timestamp = file.attributes().getModificationDate();
            if (log.isInfoEnabled()) {
                log.info((Object)("Updating timestamp:" + local + "," + timestamp));
            }
            local.writeTimestamp(-1L, timestamp, -1L);
        }
    }

    @Override
    protected void fireTransferDidEnd() {
        if (this.isReset() && this.isComplete() && !this.isCanceled() && this.getTransferred() != 0.0) {
            Growl.instance().notify("Download complete", this.getName());
            if (this.shouldOpenWhenComplete()) {
                this.getRoot().getLocal().open();
            }
            this.getRoot().getLocal().bounce();
        }
        super.fireTransferDidEnd();
    }

    protected boolean shouldOpenWhenComplete() {
        return Preferences.instance().getBoolean("queue.postProcessItemWhenComplete");
    }

    @Override
    public boolean isResumable() {
        return this.getSession().isDownloadResumable();
    }

    private abstract class DownloadTransferFilter
    extends Transfer.TransferFilter {
        private DownloadTransferFilter() {
        }

        public boolean accept(Path file) {
            if (file.attributes().isSymbolicLink() && !DownloadTransfer.this.isSymlinkSupported(file)) {
                AbstractPath target = file.getSymlinkTarget();
                for (Path root : DownloadTransfer.this.roots) {
                    if (!target.isChild(root)) continue;
                    return false;
                }
            }
            return true;
        }

        public void prepare(Path file) {
            if (file.attributes().getSize() == -1L) {
                file.readSize();
            }
            if (file.getSession().isTimestampSupported() && file.attributes().getModificationDate() == -1L && Preferences.instance().getBoolean("queue.download.preserveDate")) {
                file.readTimestamp();
            }
            if (file.getSession().isUnixPermissionsSupported() && Preferences.instance().getBoolean("queue.download.changePermissions") && file.attributes().getPermission().equals(Permission.EMPTY)) {
                file.readUnixPermission();
            }
            if (file.attributes().isFile()) {
                if (file.attributes().isSymbolicLink()) {
                    if (!DownloadTransfer.this.isSymlinkSupported(file)) {
                        Path target = (Path)file.getSymlinkTarget();
                        if (target.attributes().getSize() == -1L) {
                            target.readSize();
                        }
                        DownloadTransfer.this.size += (double)target.attributes().getSize();
                    }
                } else {
                    DownloadTransfer.this.size += (double)file.attributes().getSize();
                }
                if (file.status().isResume()) {
                    DownloadTransfer.this.transferred += (double)file.getLocal().attributes().getSize();
                }
            }
            if (!file.getLocal().getParent().exists()) {
                file.getLocal().getParent().mkdir(true);
            }
        }

        public void complete(Path p) {
        }
    }
}

