/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.NullComparator;
import ch.cyberduck.core.NullPathFilter;
import ch.cyberduck.core.PathFilter;
import ch.cyberduck.core.PathReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributedList<E extends AbstractPath>
extends CopyOnWriteArrayList<E> {
    protected static Logger log = Logger.getLogger(Cache.class);
    private Attributes<E> attributes = new Attributes();
    private static final AttributedList<AbstractPath> EMPTY_LIST = new EmptyList();
    private Map<PathReference, E> references = new ConcurrentHashMap<PathReference, E>();

    public AttributedList() {
        this((Collection<E>)Collections.emptyList());
    }

    public AttributedList(Collection<E> collection) {
        this.addAll(collection);
    }

    public static <T extends AbstractPath> AttributedList<T> emptyList() {
        return EMPTY_LIST;
    }

    public Attributes<E> attributes() {
        return this.attributes;
    }

    @Override
    public boolean add(E path) {
        AbstractPath previous = (AbstractPath)this.references.put(((AbstractPath)path).getReference(), path);
        if (null != previous) {
            log.warn((Object)("Replacing " + previous + " with " + path + " in file listing."));
        }
        return super.add(path);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        for (AbstractPath path : c) {
            AbstractPath previous = this.references.put(path.getReference(), path);
            if (null == previous) continue;
            log.warn((Object)("Replacing " + previous + " with " + path + " in file listing."));
        }
        return super.addAll(c);
    }

    public E get(PathReference reference) {
        return (E)((AbstractPath)this.references.get(reference));
    }

    public boolean contains(PathReference reference) {
        return this.references.containsKey(reference);
    }

    public int indexOf(PathReference reference) {
        return super.indexOf(this.references.get(reference));
    }

    @Override
    public void sort(Comparator<E> comparator) {
        if (null == comparator) {
            return;
        }
        AbstractPath[] sorted = this.toArray(new AbstractPath[this.size()]);
        Arrays.sort(sorted, comparator);
        for (int i = 0; i < sorted.length; ++i) {
            this.set(i, sorted[i]);
        }
    }

    @Override
    public void clear() {
        this.references.clear();
        super.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Attributes<E> {
        private Comparator<E> comparator;
        private PathFilter filter;
        private List<E> hidden = new ArrayList();
        private boolean invalid = false;
        private boolean readable = true;

        public Attributes() {
            this(new NullComparator(), new NullPathFilter());
        }

        public Attributes(Comparator<E> comparator, PathFilter filter) {
            this.comparator = comparator;
            this.filter = filter;
        }

        public Comparator<E> getComparator() {
            return this.comparator;
        }

        public void setComparator(Comparator<E> comparator) {
            this.comparator = comparator;
        }

        public PathFilter getFilter() {
            return this.filter;
        }

        public void setFilter(PathFilter filter) {
            this.filter = filter;
        }

        public void addHidden(E child) {
            this.hidden.add(child);
        }

        public List<E> getHidden() {
            return this.hidden;
        }

        public void setReadable(boolean readable) {
            this.readable = readable;
        }

        public boolean isReadable() {
            return this.readable;
        }

        public void setInvalid(boolean dirty) {
            this.invalid = dirty;
            if (dirty) {
                this.readable = true;
            }
        }

        public boolean isInvalid() {
            return this.invalid;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptyList
    extends AttributedList<AbstractPath> {
        private EmptyList() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean contains(Object obj) {
            return false;
        }

        @Override
        public AbstractPath get(int index) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }

        private AttributedList<AbstractPath> readResolve() {
            return EMPTY_LIST;
        }
    }
}

