/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.i18n.Locale;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Acl
extends HashMap<User, Set<Role>> {
    public static final Acl EMPTY = new Acl();

    public Acl() {
    }

    public Acl(User user, Role ... permissions) {
        this.addAll(user, permissions);
    }

    public Acl(UserAndRole ... set) {
        this.addAll(set);
    }

    public void addAll(User user, Role ... permissions) {
        if (this.containsKey(user)) {
            ((Set)this.get(user)).addAll(Arrays.asList(permissions));
        } else {
            this.put(user, new HashSet<Role>(Arrays.asList(permissions)));
        }
    }

    public void addAll(UserAndRole ... set) {
        for (UserAndRole userAndRole : set) {
            this.addAll(userAndRole.getUser(), userAndRole.getRole());
        }
    }

    public List<UserAndRole> asList() {
        ArrayList<UserAndRole> grants = new ArrayList<UserAndRole>();
        for (User user : this.keySet()) {
            for (Role role : (Set)this.get(user)) {
                grants.add(new UserAndRole(user, role));
            }
        }
        Collections.sort(grants);
        return grants;
    }

    public boolean isModified() {
        for (UserAndRole ua : this.asList()) {
            if (ua.getUser().isModified()) {
                return true;
            }
            if (!ua.getRole().isModified()) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Role
    implements Comparable<Role> {
        private String name;
        private boolean editable;
        private boolean modified;

        public Role(String name) {
            this(name, true);
        }

        public Role(String name, boolean editable) {
            this.name = name;
            this.editable = editable;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return Locale.localizedString(this.getName(), "S3");
        }

        public void setName(String name) {
            this.name = name;
            this.modified = true;
        }

        public boolean isValid() {
            return StringUtils.isNotBlank((String)this.getName());
        }

        public boolean isEditable() {
            return this.editable;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Role) {
                return this.name.equals(((Role)obj).getName());
            }
            return false;
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        @Override
        public int compareTo(Role o) {
            return this.getName().compareTo(o.getName());
        }

        public boolean isModified() {
            return this.modified;
        }
    }

    public static class DomainUser
    extends User {
        public DomainUser(String identifier) {
            super(identifier, true);
        }

        public String getPlaceholder() {
            return Locale.localizedString("Domain Name", "S3");
        }
    }

    public static class EmailGroupUser
    extends User {
        public EmailGroupUser(String identifier) {
            this(identifier, false);
        }

        public EmailGroupUser(String identifier, boolean editable) {
            super(identifier, editable);
        }

        public String getPlaceholder() {
            return Locale.localizedString("Email Address", "S3");
        }
    }

    public static class GroupUser
    extends User {
        public GroupUser(String identifier) {
            this(identifier, false);
        }

        public GroupUser(String identifier, boolean editable) {
            super(identifier, editable);
        }

        public String getPlaceholder() {
            return Locale.localizedString(this.getIdentifier(), "S3");
        }
    }

    public static class EmailUser
    extends CanonicalUser {
        public EmailUser() {
            super("", true);
        }

        public EmailUser(String identifier) {
            super(identifier, true);
        }

        public EmailUser(String identifier, boolean editable) {
            super(identifier, editable);
        }

        public EmailUser(String identifier, String displayName, boolean editable) {
            super(identifier, displayName, editable);
        }

        public String getPlaceholder() {
            return Locale.localizedString("Email Address", "S3");
        }
    }

    public static class CanonicalUser
    extends User {
        private String displayName;

        public CanonicalUser() {
            this("", null);
        }

        public CanonicalUser(String identifier) {
            this(identifier, null);
        }

        public CanonicalUser(String identifier, boolean editable) {
            this(identifier, null, editable);
        }

        public CanonicalUser(String identifier, String displayName) {
            this(identifier, displayName, true);
        }

        public CanonicalUser(String identifier, String displayName, boolean editable) {
            super(identifier, editable);
            this.displayName = displayName;
        }

        public String getPlaceholder() {
            return Locale.localizedString("Canonical User ID", "S3");
        }

        public String getDisplayName() {
            if (StringUtils.isEmpty((String)this.displayName)) {
                return super.getDisplayName();
            }
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public String toString() {
            if (StringUtils.isNotBlank((String)this.displayName)) {
                return this.displayName + " (" + this.getIdentifier() + ")";
            }
            return super.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class User
    implements Comparable<User> {
        private String identifier;
        private boolean editable;
        private boolean modified;

        public User(String identifier) {
            this(identifier, true);
        }

        public User(String identifier, boolean editable) {
            this.identifier = identifier;
            this.editable = editable;
        }

        public abstract String getPlaceholder();

        public String toString() {
            return this.identifier;
        }

        public boolean isEditable() {
            return this.editable;
        }

        public String getDisplayName() {
            return Locale.localizedString(this.getIdentifier(), "S3");
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public void setIdentifier(String identifier) {
            this.identifier = identifier;
            this.modified = true;
        }

        public boolean isValid() {
            return StringUtils.isNotBlank((String)this.getIdentifier());
        }

        public boolean equals(Object obj) {
            if (obj instanceof User) {
                return this.identifier.equals(((User)obj).getIdentifier());
            }
            return false;
        }

        public int hashCode() {
            return this.getIdentifier().hashCode();
        }

        @Override
        public int compareTo(User o) {
            return this.getIdentifier().compareTo(o.getIdentifier());
        }

        public boolean isModified() {
            return this.modified;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UserAndRole
    implements Comparable<UserAndRole> {
        private User user;
        private Role role;

        public UserAndRole(User user, Role role) {
            this.user = user;
            this.role = role;
        }

        public User getUser() {
            return this.user;
        }

        public Role getRole() {
            return this.role;
        }

        public boolean equals(Object obj) {
            if (obj instanceof UserAndRole) {
                return this.getUser().equals(((UserAndRole)obj).getUser()) && this.getRole().equals(((UserAndRole)obj).getRole());
            }
            return false;
        }

        public boolean isValid() {
            return this.getUser().isValid() && this.getRole().isValid();
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            return this.getUser().toString() + ":" + this.getRole().toString();
        }

        @Override
        public int compareTo(UserAndRole o) {
            return this.toString().compareTo(o.toString());
        }
    }
}

