/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Attributes;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.PathFilter;
import ch.cyberduck.core.PathReference;
import ch.cyberduck.core.PathReferenceFactory;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.i18n.Locale;
import java.util.Comparator;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jets3t.service.utils.Mimetypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPath {
    private static Logger log = Logger.getLogger(AbstractPath.class);
    public static final String HOME = "~";
    public static final int FILE_TYPE = 1;
    public static final int DIRECTORY_TYPE = 2;
    public static final int SYMBOLIC_LINK_TYPE = 4;
    public static final int VOLUME_TYPE = 8;
    protected PathReference reference;

    public boolean isCached() {
        return this.cache().containsKey(this.getReference()) && !this.cache().get(this.getReference()).attributes().isInvalid();
    }

    public abstract <T extends AbstractPath> Cache<T> cache();

    public abstract Attributes attributes();

    public void invalidate() {
        if (this.attributes().isDirectory()) {
            this.cache().get(this.getReference()).attributes().setInvalid(true);
        }
    }

    public String unique() {
        StringBuilder reference = new StringBuilder(this.getAbsolute());
        if (this.attributes().isDuplicate()) {
            if (StringUtils.isNotBlank((String)this.attributes().getVersionId())) {
                reference.append("-").append(this.attributes().getVersionId());
            } else if (StringUtils.isNotBlank((String)this.attributes().getChecksum())) {
                reference.append("-").append(this.attributes().getChecksum());
            }
        }
        return reference.toString();
    }

    public <T> PathReference<T> getReference() {
        if (null == this.reference) {
            this.reference = PathReferenceFactory.createPathReference(this);
        }
        return this.reference;
    }

    public void setReference(PathReference reference) {
        this.reference = reference;
    }

    public abstract String toURL();

    public abstract <T extends AbstractPath> AttributedList<T> list();

    public <T extends AbstractPath> AttributedList<T> children() {
        return this.children(null);
    }

    public <T extends AbstractPath> AttributedList<T> children(PathFilter<T> filter) {
        return this.children(null, filter);
    }

    public <T extends AbstractPath> AttributedList<T> children(Comparator<T> comparator, PathFilter<T> filter) {
        if (!this.isCached()) {
            this.cache().put(this.getReference(), this.list());
        }
        return this.cache().get(this.getReference(), comparator, filter);
    }

    public abstract char getPathDelimiter();

    public boolean isRoot() {
        return this.getAbsolute().equals(String.valueOf(this.getPathDelimiter()));
    }

    protected String getParent(String absolute) {
        int cut;
        int index = absolute.length() - 1;
        if (absolute.charAt(index) == this.getPathDelimiter() && index > 0) {
            --index;
        }
        if ((cut = absolute.lastIndexOf(this.getPathDelimiter(), index)) > 0) {
            return absolute.substring(0, cut);
        }
        return String.valueOf(this.getPathDelimiter());
    }

    public abstract String getAbsolute();

    public abstract String getName();

    public String getDisplayName() {
        return this.getName();
    }

    public abstract AbstractPath getParent();

    public abstract boolean exists();

    public String getExtension() {
        String extension = FilenameUtils.getExtension((String)this.getName());
        if (StringUtils.isEmpty((String)extension)) {
            return null;
        }
        return extension;
    }

    public String getMimeType() {
        return AbstractPath.getMimeType(this.getName().toLowerCase());
    }

    public static String getMimeType(String extension) {
        return Mimetypes.getInstance().getMimetype(extension);
    }

    protected void setPath(String parent, String name) {
        if (null == parent) {
            parent = String.valueOf(this.getPathDelimiter());
        }
        if (parent.endsWith(String.valueOf(this.getPathDelimiter()))) {
            this.setPath(parent + name);
        } else {
            this.setPath(parent + this.getPathDelimiter() + name);
        }
    }

    protected abstract void setPath(String var1);

    public boolean isChild(AbstractPath directory) {
        if (directory.attributes().isFile()) {
            return false;
        }
        if (this.isRoot()) {
            return false;
        }
        if (directory.isRoot()) {
            return true;
        }
        if (this.getParent().equals(directory.getParent())) {
            return false;
        }
        AbstractPath parent = this.getParent();
        while (!parent.isRoot()) {
            if (parent.equals(directory)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public abstract String kind();

    public abstract AbstractPath getSymlinkTarget();

    public abstract void touch();

    public abstract void symlink(String var1);

    public void touch(boolean recursive) {
        if (!this.exists()) {
            if (recursive && !this.getParent().exists()) {
                this.getParent().mkdir(recursive);
            }
            this.touch();
        }
    }

    public abstract void mkdir();

    public void mkdir(boolean recursive) {
        AbstractPath parent;
        if (recursive && !(parent = this.getParent()).exists()) {
            parent.mkdir(recursive);
        }
        this.mkdir();
    }

    public abstract void writeUnixPermission(Permission var1, boolean var2);

    public abstract void writeTimestamp(long var1, long var3, long var5);

    public abstract void delete();

    public boolean isEmpty() {
        return this.children().size() == 0;
    }

    public abstract void rename(AbstractPath var1);

    public abstract void copy(AbstractPath var1);

    public static class DescriptiveUrl {
        private String url = "";
        private String help = "";

        public DescriptiveUrl(String url) {
            this(url, Locale.localizedString("Open in Web Browser"));
        }

        public DescriptiveUrl(String url, String help) {
            this.url = url;
            this.help = help;
        }

        public String getUrl() {
            return this.url;
        }

        public String getHelp() {
            return this.help;
        }

        public boolean equals(Object obj) {
            if (obj instanceof DescriptiveUrl) {
                return this.getUrl().equals(((DescriptiveUrl)obj).getUrl());
            }
            return false;
        }

        public int hashCode() {
            return this.getUrl().hashCode();
        }
    }
}

