/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AbstractHostCollection;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Collection;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.PathFilter;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.serializer.HostReaderFactory;
import ch.cyberduck.core.serializer.HostWriterFactory;
import ch.cyberduck.core.serializer.Reader;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFolderHostCollection
extends AbstractHostCollection {
    private static Logger log = Logger.getLogger(AbstractFolderHostCollection.class);
    protected Local folder;
    private boolean locked = true;

    public AbstractFolderHostCollection(Local f) {
        this.folder = f;
        this.folder.mkdir(true);
    }

    @Override
    public String getName() {
        return Locale.localizedString(this.folder.getName());
    }

    public void open() {
        this.folder.open();
    }

    public Local getFile(Host bookmark) {
        return LocalFactory.createLocal(this.folder, bookmark.getUuid() + ".duck");
    }

    @Override
    public void collectionItemAdded(Host bookmark) {
        if (this.locked) {
            log.debug((Object)"Do not notify changes of locked collection");
            return;
        }
        HostWriterFactory.instance().write(bookmark, this.getFile(bookmark));
        super.collectionItemAdded(bookmark);
    }

    @Override
    public void collectionItemRemoved(Host bookmark) {
        if (this.locked) {
            log.debug((Object)"Do not notify changes of locked collection");
            return;
        }
        this.getFile(bookmark).delete(false);
        super.collectionItemRemoved(bookmark);
    }

    @Override
    public void collectionItemChanged(Host bookmark) {
        if (this.locked) {
            log.debug((Object)"Do not notify changes of locked collection");
            return;
        }
        HostWriterFactory.instance().write(bookmark, this.getFile(bookmark));
        super.collectionItemChanged(bookmark);
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void load() {
        if (log.isInfoEnabled()) {
            log.info((Object)("Reloading:" + this.folder));
        }
        AttributedList<Local> bookmarks = this.folder.children(new PathFilter<Local>(){

            @Override
            public boolean accept(Local file) {
                return file.getName().endsWith(".duck");
            }
        });
        Reader<Host> reader = HostReaderFactory.instance();
        for (Local next : bookmarks) {
            Host bookmark = reader.read(next);
            if (!this.getFile(bookmark).equals(next)) {
                next.rename(this.getFile(bookmark));
            }
            this.add(bookmark);
        }
        this.locked = false;
        this.sort();
        this.collectionLoaded();
    }

    @Override
    public void load(Collection<Host> c) {
        super.load(c);
        this.locked = false;
    }

    @Override
    public void save() {
    }
}

