/*
 * Decompiled with CFR 0.152.
 */
package org.rococoa.internal;

import com.sun.jna.Memory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.rococoa.ID;
import org.rococoa.Rococoa;
import org.rococoa.RococoaException;
import org.rococoa.cocoa.foundation.NSInvocation;
import org.rococoa.cocoa.foundation.NSMethodSignature;
import org.rococoa.internal.NSInvocationMapper;
import org.rococoa.internal.NSInvocationMapperLookup;
import org.rococoa.internal.RococoaLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCInvocationCallbacks {
    private static Logger logging = LoggerFactory.getLogger((String)"org.rococoa.callback");
    private final Object javaObject;
    public final RococoaLibrary.MethodSignatureCallback methodSignatureCallback = new RococoaLibrary.MethodSignatureCallback(){

        public String callback(String selectorName) {
            if (logging.isTraceEnabled()) {
                logging.trace("callback wanting methodSignature for selector {}", (Object)selectorName);
            }
            return OCInvocationCallbacks.this.methodSignatureForSelector(selectorName);
        }
    };
    public final RococoaLibrary.SelectorInvokedCallback selectorInvokedCallback = new RococoaLibrary.SelectorInvokedCallback(){

        public void callback(String selectorName, ID nsInvocation) {
            if (logging.isTraceEnabled()) {
                logging.trace("callback invoking {} on {}", (Object)selectorName, OCInvocationCallbacks.this.javaObject);
            }
            OCInvocationCallbacks.this.callMethod(OCInvocationCallbacks.this.javaObject, selectorName, Rococoa.wrap(nsInvocation, NSInvocation.class));
        }
    };

    public OCInvocationCallbacks(Object javaObject) {
        this.javaObject = javaObject;
    }

    protected String methodSignatureForSelector(String selectorName) {
        Method method = this.methodForSelector(selectorName);
        return method == null ? null : this.ocMethodSignatureAsString(method);
    }

    protected Method methodForSelector(String selectorName) {
        if (null == selectorName) {
            logging.error("methodForSelector called with null selectorName");
            return null;
        }
        int parameterCount = this.countColons(selectorName);
        String methodName = this.methodNameForSelector(selectorName);
        try {
            Method[] methods;
            for (Method method : methods = this.javaObject.getClass().getMethods()) {
                if (!method.getName().equals(methodName) || method.getParameterTypes().length != parameterCount) continue;
                return method;
            }
            logging.debug("No method for selector:" + selectorName);
            return null;
        }
        catch (Exception e) {
            logging.error("Exception finding methodForSelector", (Throwable)e);
            return null;
        }
    }

    protected String ocMethodSignatureAsString(Method method) {
        StringBuilder result = new StringBuilder();
        result.append(this.stringForType(method.getReturnType()));
        result.append("@:");
        for (Class<?> parameterType : method.getParameterTypes()) {
            result.append(this.stringForType(parameterType));
        }
        return result.toString();
    }

    private void callMethod(Object o, String selectorName, NSInvocation invocation) {
        try {
            Method method = this.methodForSelector(selectorName);
            NSMethodSignature nsMethodSignature = invocation.methodSignature();
            String typeToReturnToObjC = nsMethodSignature.methodReturnType();
            if (nsMethodSignature.numberOfArguments() - method.getParameterTypes().length != 2) {
                throw new NoSuchMethodException(String.format("Number of arguments mismatch for invocation  of selector %s (%s arguments supplied), method %s expects %s", selectorName, nsMethodSignature.numberOfArguments(), method.getName(), method.getParameterTypes().length));
            }
            if (typeToReturnToObjC.equals("v") && method.getReturnType() != Void.TYPE) {
                throw new NoSuchMethodException(String.format("Selector %s expects void return, but method %s returns %s", selectorName, method.getName(), method.getReturnType()));
            }
            if (method.getReturnType() == Void.TYPE && !typeToReturnToObjC.equals("v")) {
                throw new NoSuchMethodException(String.format("Method %s returns void, but selector %s expects %s", method.getName(), selectorName, typeToReturnToObjC));
            }
            Object[] marshalledArgs = this.argsForFrom(method, invocation, nsMethodSignature);
            method.setAccessible(true);
            Object result = method.invoke(o, marshalledArgs);
            this.putResultIntoInvocation(invocation, typeToReturnToObjC, result);
        }
        catch (InvocationTargetException e) {
            logging.error("Exception calling method for selector " + selectorName, (Throwable)e);
            throw new RococoaException("Exception calling method for selector " + selectorName, e.getCause());
        }
        catch (Exception e) {
            logging.error("Exception calling method for selector " + selectorName, (Throwable)e);
            throw new RococoaException("Exception calling method for selector " + selectorName, e);
        }
    }

    private String methodNameForSelector(String selectorName) {
        String candidate = selectorName.replaceAll(":", "_");
        return candidate.endsWith("_") ? candidate.substring(0, candidate.length() - 1) : candidate;
    }

    private Object[] argsForFrom(Method method, NSInvocation invocation, NSMethodSignature nsMethodSignature) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        Object[] result = new Object[parameterTypes.length];
        for (int i = 0; i < result.length; ++i) {
            int indexAccountingForSelfAndCmd = 2 + i;
            result[i] = this.javaObjectForOCArgument(invocation, indexAccountingForSelfAndCmd, nsMethodSignature.getArgumentTypeAtIndex(indexAccountingForSelfAndCmd), parameterTypes[i]);
        }
        return result;
    }

    private Object javaObjectForOCArgument(NSInvocation invocation, int indexInInvocation, String objCArgumentTypeAsString, Class<?> javaParameterType) {
        NSInvocationMapper mapper = NSInvocationMapperLookup.mapperForType(javaParameterType);
        if (mapper == null) {
            throw new IllegalStateException(String.format("Don't (yet) know how to marshall argument Objective-C type %s as %s", objCArgumentTypeAsString, javaParameterType));
        }
        return mapper.readArgumentFrom(invocation, indexInInvocation, javaParameterType);
    }

    private void putResultIntoInvocation(NSInvocation invocation, String typeToReturnToObjC, Object result) {
        if (typeToReturnToObjC.equals("v")) {
            if (result != null) {
                throw new IllegalStateException("Java method returned a result, but expected void");
            }
            return;
        }
        if (null == result) {
            return;
        }
        Memory buffer = this.bufferForReturn(typeToReturnToObjC, result);
        if (buffer == null) {
            throw new IllegalStateException(String.format("Don't (yet) know how to marshall result %s as Objective-C type %s", result, typeToReturnToObjC));
        }
        invocation.setReturnValue(buffer);
    }

    private Memory bufferForReturn(String typeToReturnToObjC, Object methodCallResult) {
        NSInvocationMapper mapper = NSInvocationMapperLookup.mapperForType(methodCallResult.getClass());
        return mapper == null ? null : mapper.bufferForResult(methodCallResult);
    }

    private int countColons(String selectorName) {
        int result = 0;
        for (int i = 0; i < selectorName.length(); ++i) {
            if (selectorName.charAt(i) != ':') continue;
            ++result;
        }
        return result;
    }

    private String stringForType(Class<?> clas) {
        NSInvocationMapper result = NSInvocationMapperLookup.mapperForType(clas);
        if (result == null) {
            throw new RococoaException("Unable to give Objective-C type string for Java type " + clas);
        }
        return result.typeString();
    }
}

