/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.threading;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.core.threading.BackgroundException;
import ch.cyberduck.core.threading.RepeatableBackgroundAction;
import ch.cyberduck.ui.cocoa.AbstractTableDelegate;
import ch.cyberduck.ui.cocoa.AlertController;
import ch.cyberduck.ui.cocoa.ErrorController;
import ch.cyberduck.ui.cocoa.ListDataSource;
import ch.cyberduck.ui.cocoa.SheetController;
import ch.cyberduck.ui.cocoa.WindowController;
import ch.cyberduck.ui.cocoa.application.NSAlert;
import ch.cyberduck.ui.cocoa.application.NSButton;
import ch.cyberduck.ui.cocoa.application.NSCell;
import ch.cyberduck.ui.cocoa.application.NSTableColumn;
import ch.cyberduck.ui.cocoa.application.NSTableView;
import ch.cyberduck.ui.cocoa.application.NSTextView;
import ch.cyberduck.ui.cocoa.foundation.NSAttributedString;
import ch.cyberduck.ui.cocoa.foundation.NSNotification;
import ch.cyberduck.ui.cocoa.foundation.NSObject;
import ch.cyberduck.ui.cocoa.view.ControllerCell;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.ID;
import org.rococoa.Rococoa;
import org.rococoa.cocoa.CGFloat;
import org.rococoa.cocoa.foundation.NSInteger;

public abstract class AlertRepeatableBackgroundAction
extends RepeatableBackgroundAction {
    private static Logger log = Logger.getLogger(AlertRepeatableBackgroundAction.class);
    private WindowController controller;

    public AlertRepeatableBackgroundAction(WindowController controller) {
        this.controller = controller;
    }

    public void finish() {
        super.finish();
        if (this.hasFailed() && !this.isCanceled()) {
            this.alert();
        }
        this.reset();
    }

    private void callback(int returncode) {
        if (returncode == 1) {
            for (BackgroundException e : this.getExceptions()) {
                Path workdir = e.getPath();
                if (null == workdir) continue;
                workdir.invalidate();
            }
            this.reset();
            this.controller.background((BackgroundAction)this);
        }
    }

    protected void alert() {
        if (this.controller.isVisible()) {
            if (this.getExceptions().size() == 1) {
                final BackgroundException failure = (BackgroundException)this.getExceptions().get(0);
                String detail = failure.getDetailedCauseMessage();
                String title = failure.getReadableTitle() + ": " + failure.getMessage();
                NSAlert alert = NSAlert.alert(title, Locale.localizedString((String)detail), Locale.localizedString((String)"Try Again", (String)"Alert"), this.isNetworkFailure() ? Locale.localizedString((String)"Network Diagnostics") : null, Locale.localizedString((String)"Cancel"));
                alert.setShowsHelp(true);
                AlertController c = new AlertController(this.controller, alert){

                    public void callback(int returncode) {
                        if (returncode == 0) {
                            AlertRepeatableBackgroundAction.this.diagnose();
                        }
                        if (returncode == 1) {
                            AlertRepeatableBackgroundAction.this.callback(returncode);
                        }
                    }

                    protected void help() {
                        StringBuilder site = new StringBuilder(Preferences.instance().getProperty("website.help"));
                        if (null != failure.getPath()) {
                            site.append("/").append(failure.getPath().getSession().getHost().getProtocol().getIdentifier());
                        }
                        1.openUrl(site.toString());
                    }
                };
                if (this.hasTranscript()) {
                    // empty if block
                }
                c.beginSheet();
            } else {
                AlertSheetController c = new AlertSheetController();
                c.beginSheet();
            }
        }
    }

    private class AlertSheetController
    extends SheetController {
        private NSButton diagnosticsButton;
        private NSButton transcriptButton;
        private final TableColumnFactory tableColumnsFactory;
        private NSTableView errorView;
        private ListDataSource model;
        private AbstractTableDelegate<ErrorController> delegate;
        private List<ErrorController> errors;
        private final NSCell prototype;
        private NSTextView transcriptView;

        public AlertSheetController() {
            super(AlertRepeatableBackgroundAction.this.controller);
            this.tableColumnsFactory = new TableColumnFactory();
            this.prototype = ControllerCell.controllerCell();
        }

        protected String getBundleName() {
            return "Alert";
        }

        public void awakeFromNib() {
            boolean log = AlertRepeatableBackgroundAction.this.hasTranscript();
            this.setState(this.transcriptButton, log && Preferences.instance().getBoolean("alert.toggle.transcript"));
            this.transcriptButton.setEnabled(log);
            super.awakeFromNib();
        }

        protected void invalidate() {
            this.errorView.setDataSource(null);
            this.errorView.setDelegate(null);
            super.invalidate();
        }

        public void setDiagnosticsButton(NSButton diagnosticsButton) {
            this.diagnosticsButton = diagnosticsButton;
            this.diagnosticsButton.setTarget(this.id());
            this.diagnosticsButton.setAction(Foundation.selector("diagnosticsButtonClicked:"));
            this.diagnosticsButton.setHidden(!AlertRepeatableBackgroundAction.this.isNetworkFailure());
        }

        public void diagnosticsButtonClicked(NSButton sender) {
            AlertRepeatableBackgroundAction.this.diagnose();
        }

        public void setTranscriptButton(NSButton transcriptButton) {
            this.transcriptButton = transcriptButton;
        }

        public void setErrorView(NSTableView errorView) {
            this.errorView = errorView;
            this.errorView.setRowHeight(new CGFloat(77.0));
            this.errors = new ArrayList<ErrorController>();
            for (BackgroundException e : AlertRepeatableBackgroundAction.this.getExceptions()) {
                this.errors.add(new ErrorController(e));
            }
            this.model = new ListDataSource(){

                public NSInteger numberOfRowsInTableView(NSTableView view) {
                    return new NSInteger(AlertSheetController.this.errors.size());
                }

                public NSObject tableView_objectValueForTableColumn_row(NSTableView view, NSTableColumn tableColumn, NSInteger row) {
                    return null;
                }
            };
            this.errorView.setDataSource(this.model.id());
            this.delegate = new AbstractTableDelegate<ErrorController>(){

                @Override
                public void tableColumnClicked(NSTableView view, NSTableColumn tableColumn) {
                }

                @Override
                public void tableRowDoubleClicked(ID sender) {
                }

                @Override
                public boolean selectionShouldChange() {
                    return false;
                }

                @Override
                public void selectionDidChange(NSNotification notification) {
                }

                @Override
                protected boolean isTypeSelectSupported() {
                    return false;
                }

                @Override
                public void enterKeyPressed(ID sender) {
                }

                @Override
                public void deleteKeyPressed(ID sender) {
                }

                @Override
                public String tooltip(ErrorController e) {
                    return e.getTooltip();
                }

                public void tableView_willDisplayCell_forTableColumn_row(NSTableView view, NSCell cell, NSTableColumn tableColumn, NSInteger row) {
                    Rococoa.cast(cell, ControllerCell.class).setView(((ErrorController)((Object)AlertSheetController.this.errors.get(row.intValue()))).view());
                }
            };
            this.errorView.setDelegate(this.delegate.id());
            NSTableColumn c = this.tableColumnsFactory.create("Error");
            c.setMinWidth(50.0);
            c.setWidth(400.0);
            c.setMaxWidth(1000.0);
            c.setDataCell(this.prototype);
            this.errorView.addTableColumn(c);
        }

        public void setTranscriptView(NSTextView transcriptView) {
            this.transcriptView = transcriptView;
            this.transcriptView.textStorage().setAttributedString(NSAttributedString.attributedStringWithAttributes(AlertRepeatableBackgroundAction.this.getTranscript(), FIXED_WITH_FONT_ATTRIBUTES));
        }

        public void callback(int returncode) {
            Preferences.instance().setProperty("alert.toggle.transcript", this.transcriptButton.state());
            AlertRepeatableBackgroundAction.this.callback(returncode);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TableColumnFactory
    extends HashMap<String, NSTableColumn> {
        private TableColumnFactory() {
        }

        private NSTableColumn create(String identifier) {
            if (!this.containsKey(identifier)) {
                this.put(identifier, NSTableColumn.tableColumnWithIdentifier(identifier));
            }
            return (NSTableColumn)this.get(identifier);
        }
    }
}

