/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.serializer;

import ch.cyberduck.core.Factory;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Profile;
import ch.cyberduck.core.Serializable;
import ch.cyberduck.core.Transfer;
import ch.cyberduck.core.serializer.HostWriterFactory;
import ch.cyberduck.core.serializer.ProtocolWriterFactory;
import ch.cyberduck.core.serializer.TransferWriterFactory;
import ch.cyberduck.core.serializer.Writer;
import ch.cyberduck.ui.cocoa.foundation.NSDictionary;
import ch.cyberduck.ui.cocoa.foundation.NSMutableArray;
import ch.cyberduck.ui.cocoa.foundation.NSObject;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlistWriter<S extends Serializable>
implements Writer<S> {
    public static void register() {
        HostWriterFactory.addFactory((Factory.Platform)Factory.NATIVE_PLATFORM, (HostWriterFactory)new HostFactory());
        TransferWriterFactory.addFactory((Factory.Platform)Factory.NATIVE_PLATFORM, (TransferWriterFactory)new TransferFactory());
    }

    public void write(Collection<S> collection, Local file) {
        NSMutableArray list = NSMutableArray.array();
        for (Serializable bookmark : collection) {
            list.addObject((NSObject)bookmark.getAsDictionary());
        }
        list.writeToFile(file.getAbsolute());
    }

    public void write(S bookmark, Local file) {
        ((NSDictionary)bookmark.getAsDictionary()).writeToFile(file.getAbsolute());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProtocolFactory
    extends ProtocolWriterFactory {
        private ProtocolFactory() {
        }

        public Writer<Profile> create() {
            return new PlistWriter<Profile>();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TransferFactory
    extends TransferWriterFactory {
        private TransferFactory() {
        }

        public Writer<Transfer> create() {
            return new PlistWriter<Transfer>();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HostFactory
    extends HostWriterFactory {
        private HostFactory() {
        }

        public Writer<Host> create() {
            return new PlistWriter<Host>();
        }
    }
}

