/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.quicklook;

import ch.cyberduck.core.Collection;
import ch.cyberduck.core.Local;
import ch.cyberduck.ui.cocoa.foundation.NSURL;
import ch.cyberduck.ui.cocoa.quicklook.AbstractQuickLook;
import ch.cyberduck.ui.cocoa.quicklook.QLPreviewItem;
import ch.cyberduck.ui.cocoa.quicklook.QLPreviewPanel;
import ch.cyberduck.ui.cocoa.quicklook.QLPreviewPanelDataSource;
import ch.cyberduck.ui.cocoa.quicklook.QuickLookFactory;
import ch.cyberduck.ui.cocoa.quicklook.QuickLookInterface;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.rococoa.ID;
import org.rococoa.cocoa.foundation.NSInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuartzQuickLook
extends AbstractQuickLook {
    private static Logger log = Logger.getLogger(QuartzQuickLook.class);
    private List<QLPreviewItem> previews = new ArrayList<QLPreviewItem>();
    private QLPreviewPanelDataSource model = new QLPreviewPanelDataSource(){

        public NSInteger numberOfPreviewItemsInPreviewPanel(QLPreviewPanel panel) {
            return new NSInteger(QuartzQuickLook.this.previews.size());
        }

        public ID previewPanel_previewItemAtIndex(QLPreviewPanel panel, int index) {
            return ((QLPreviewItem)((Object)QuartzQuickLook.this.previews.get(index))).id();
        }
    };
    final QLPreviewPanel panel = QLPreviewPanel.sharedPreviewPanel();

    public static void register() {
        if (!Factory.VERSION_PLATFORM.matches("10\\.5.*")) {
            QuickLookFactory.addFactory(Factory.VERSION_PLATFORM, new Factory());
        }
    }

    @Override
    public void select(Collection<Local> files) {
        this.previews.clear();
        for (final Local selected : files) {
            this.previews.add(new QLPreviewItem(){

                public NSURL previewItemURL() {
                    return NSURL.fileURLWithPath(selected.getAbsolute());
                }

                public String previewItemTitle() {
                    return selected.getDisplayName();
                }
            });
        }
        super.select(files);
    }

    private QuartzQuickLook() {
    }

    @Override
    public boolean isAvailable() {
        return null != this.panel;
    }

    @Override
    public boolean isOpen() {
        return QLPreviewPanel.sharedPreviewPanelExists() && this.panel.isVisible();
    }

    @Override
    public void willBeginQuickLook() {
        this.panel.setDataSource(this.model.id());
        super.willBeginQuickLook();
    }

    @Override
    public void open() {
        this.panel.makeKeyAndOrderFront(null);
        if (null == this.panel.dataSource()) {
            return;
        }
        this.panel.reloadData();
    }

    @Override
    public void close() {
        this.panel.orderOut(null);
    }

    @Override
    public void didEndQuickLook() {
        this.panel.setDataSource(null);
        super.didEndQuickLook();
    }

    private static class Factory
    extends QuickLookFactory {
        private Factory() {
        }

        protected QuickLookInterface create() {
            return new QuartzQuickLook();
        }
    }
}

