/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.quicklook;

import ch.cyberduck.core.Collection;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Native;
import ch.cyberduck.ui.cocoa.quicklook.AbstractQuickLook;
import ch.cyberduck.ui.cocoa.quicklook.QuickLookFactory;
import ch.cyberduck.ui.cocoa.quicklook.QuickLookInterface;
import java.util.ArrayList;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeprecatedQuickLook
extends AbstractQuickLook {
    private static Logger log = Logger.getLogger(DeprecatedQuickLook.class);

    public static void register() {
        if (Factory.VERSION_PLATFORM.matches("10\\.5.*")) {
            QuickLookFactory.addFactory(Factory.VERSION_PLATFORM, new Factory());
        }
    }

    private DeprecatedQuickLook() {
        Native.load((String)"QuickLook");
    }

    private native void selectNative(String[] var1);

    @Override
    public void select(Collection<Local> files) {
        ArrayList<String> paths = new ArrayList<String>();
        for (Local file : files) {
            paths.add(file.getAbsolute());
        }
        this.selectNative(paths.toArray(new String[paths.size()]));
    }

    @Override
    public boolean isAvailable() {
        return this.isAvailableNative();
    }

    public native boolean isAvailableNative();

    @Override
    public boolean isOpen() {
        return this.isOpenNative();
    }

    public native boolean isOpenNative();

    @Override
    public void open() {
        this.willBeginQuickLook();
        this.openNative();
    }

    public native void openNative();

    @Override
    public void close() {
        this.closeNative();
        this.didEndQuickLook();
    }

    public native void closeNative();

    private static class Factory
    extends QuickLookFactory {
        private Factory() {
        }

        protected QuickLookInterface create() {
            return new DeprecatedQuickLook();
        }
    }
}

