/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.odb;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.ui.cocoa.BrowserController;
import ch.cyberduck.ui.cocoa.application.NSWorkspace;
import ch.cyberduck.ui.cocoa.foundation.NSBundle;
import ch.cyberduck.ui.cocoa.foundation.NSDictionary;
import ch.cyberduck.ui.cocoa.foundation.NSObject;
import ch.cyberduck.ui.cocoa.odb.Editor;
import ch.cyberduck.ui.cocoa.odb.ODBEditor;
import ch.cyberduck.ui.cocoa.odb.WatchEditor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.map.AbstractLinkedMap;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorFactory {
    private static Logger log = Logger.getLogger(EditorFactory.class);
    private static Map<String, String> applicationNameCache = Collections.synchronizedMap(new LRUMap(20){

        protected boolean removeLRU(AbstractLinkedMap.LinkEntry entry) {
            log.debug((Object)("Removing from cache:" + entry));
            return true;
        }
    });

    public static Editor createEditor(BrowserController c, Path path) {
        return EditorFactory.createEditor(c, EditorFactory.defaultEditor(path.getLocal()), path);
    }

    public static Editor createEditor(BrowserController c, String bundleIdentifier, Path path) {
        if (Preferences.instance().getBoolean("editor.odb.enable") && ODBEditor.getInstalledEditors().containsValue(bundleIdentifier)) {
            return new ODBEditor(c, bundleIdentifier, path);
        }
        if (Preferences.instance().getBoolean("editor.kqueue.enable")) {
            return new WatchEditor(c, bundleIdentifier, path);
        }
        log.error((Object)"No editor support enabled");
        return null;
    }

    public static String defaultEditor() {
        if (log.isTraceEnabled()) {
            log.trace((Object)"defaultEditor");
        }
        if (StringUtils.isEmpty((String)EditorFactory.getApplicationName(Preferences.instance().getProperty("editor.bundleIdentifier")))) {
            return null;
        }
        return Preferences.instance().getProperty("editor.bundleIdentifier");
    }

    public static String defaultEditor(Local file) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("defaultEditor:" + file));
        }
        if (null == file) {
            return EditorFactory.defaultEditor();
        }
        if (Preferences.instance().getBoolean("editor.alwaysUseDefault")) {
            return EditorFactory.defaultEditor();
        }
        String defaultApplication = file.getDefaultApplication();
        if (null == defaultApplication) {
            return EditorFactory.defaultEditor();
        }
        if (Preferences.instance().getBoolean("editor.odb.enable")) {
            for (String bundleIdentifier : ODBEditor.getInstalledEditors().values()) {
                if (!bundleIdentifier.equals(defaultApplication)) continue;
                return bundleIdentifier;
            }
        }
        if (Preferences.instance().getBoolean("editor.kqueue.enable")) {
            return defaultApplication;
        }
        log.warn((Object)("No editor for file type " + file.getExtension()));
        return EditorFactory.defaultEditor();
    }

    public static Map<String, String> getSupportedEditors() {
        String defaultEditor;
        if (log.isTraceEnabled()) {
            log.trace((Object)"getSupportedEditors");
        }
        HashMap<String, String> supported = new HashMap<String, String>();
        if (Preferences.instance().getBoolean("editor.odb.enable")) {
            supported.putAll(ODBEditor.getSupportedEditors());
        }
        if (Preferences.instance().getBoolean("editor.kqueue.enable")) {
            supported.putAll(WatchEditor.getSupportedEditors());
        }
        if (null == (defaultEditor = EditorFactory.defaultEditor())) {
            return supported;
        }
        if (!supported.values().contains(defaultEditor)) {
            supported.put(EditorFactory.getApplicationName(defaultEditor), defaultEditor);
        }
        return supported;
    }

    public static Map<String, String> getInstalledEditors() {
        if (log.isTraceEnabled()) {
            log.trace((Object)"getInstalledEditors");
        }
        HashMap<String, String> installed = new HashMap<String, String>();
        if (Preferences.instance().getBoolean("editor.odb.enable")) {
            installed.putAll(ODBEditor.getInstalledEditors());
        }
        if (Preferences.instance().getBoolean("editor.kqueue.enable")) {
            installed.putAll(WatchEditor.getInstalledEditors());
        }
        return installed;
    }

    public static Map<String, String> getInstalledEditors(Local file) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("getInstalledEditors:" + file));
        }
        if (null == file) {
            return EditorFactory.getInstalledEditors();
        }
        if (!Preferences.instance().getBoolean("editor.kqueue.enable")) {
            return EditorFactory.getInstalledEditors();
        }
        HashMap<String, String> editors = new HashMap<String, String>();
        for (String bundleIdentifier : file.getDefaultApplications()) {
            String name = EditorFactory.getApplicationName(bundleIdentifier);
            if (null == name) continue;
            editors.put(name, bundleIdentifier);
        }
        String defaultEditor = EditorFactory.defaultEditor();
        if (null != defaultEditor && !editors.values().contains(defaultEditor)) {
            editors.put(EditorFactory.getApplicationName(defaultEditor), defaultEditor);
        }
        return editors;
    }

    public static String getApplicationName(String bundleIdentifier) {
        if (!applicationNameCache.containsKey(bundleIdentifier)) {
            log.debug((Object)("getApplicationName:" + bundleIdentifier));
            String path = NSWorkspace.sharedWorkspace().absolutePathForAppBundleWithIdentifier(bundleIdentifier);
            if (StringUtils.isBlank((String)path)) {
                log.warn((Object)("Cannot determine installation path for " + bundleIdentifier));
                applicationNameCache.put(bundleIdentifier, null);
                return null;
            }
            NSBundle app = NSBundle.bundleWithPath(path);
            if (null == app) {
                log.error((Object)("Loading bundle failed:" + path));
                applicationNameCache.put(bundleIdentifier, null);
                return null;
            }
            NSDictionary dict = app.infoDictionary();
            if (null == dict) {
                log.error((Object)("Loading application dictionary failed:" + path));
                applicationNameCache.put(bundleIdentifier, null);
                return null;
            }
            NSObject name = dict.objectForKey("CFBundleName");
            if (null == name) {
                log.warn((Object)("No CFBundleName for " + bundleIdentifier));
                applicationNameCache.put(bundleIdentifier, FilenameUtils.removeExtension((String)LocalFactory.createLocal((String)path).getDisplayName()));
            } else {
                applicationNameCache.put(bundleIdentifier, name.toString());
            }
        }
        return applicationNameCache.get(bundleIdentifier);
    }
}

