/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.model;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Factory;
import ch.cyberduck.core.PathReference;
import ch.cyberduck.core.PathReferenceFactory;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.ui.cocoa.foundation.NSObject;
import ch.cyberduck.ui.cocoa.foundation.NSString;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.collections.map.LRUMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutlinePathReference
extends PathReference<NSObject> {
    private NSObject reference;
    private int hashcode;
    private static Map<String, NSString> cache = Collections.synchronizedMap(new LRUMap(Preferences.instance().getInteger("browser.model.cache.size")));

    private OutlinePathReference(AbstractPath path) {
        String unique = path.unique();
        if (!cache.containsKey(unique)) {
            cache.put(unique, NSString.stringWithString(unique));
        }
        this.reference = cache.get(unique);
        this.hashcode = unique.hashCode();
    }

    public OutlinePathReference(NSObject reference) {
        this.reference = reference;
        this.hashcode = reference.toString().hashCode();
    }

    public NSObject unique() {
        return this.reference;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public static void register() {
        PathReferenceFactory.addFactory((Factory.Platform)Factory.NATIVE_PLATFORM, (PathReferenceFactory)new Factory());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Factory
    extends PathReferenceFactory {
        private Factory() {
        }

        protected PathReference create() {
            throw new UnsupportedOperationException("Please provide a parameter");
        }

        protected <T> PathReference<T> create(AbstractPath param) {
            return new OutlinePathReference(param);
        }
    }
}

