/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.model;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Factory;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Native;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.threading.DefaultMainAction;
import ch.cyberduck.core.threading.MainAction;
import ch.cyberduck.ui.cocoa.IconCache;
import ch.cyberduck.ui.cocoa.ProxyController;
import ch.cyberduck.ui.cocoa.application.NSWorkspace;
import ch.cyberduck.ui.cocoa.foundation.NSArray;
import ch.cyberduck.ui.cocoa.foundation.NSBundle;
import ch.cyberduck.ui.cocoa.foundation.NSDate;
import ch.cyberduck.ui.cocoa.foundation.NSDictionary;
import ch.cyberduck.ui.cocoa.foundation.NSDistributedNotificationCenter;
import ch.cyberduck.ui.cocoa.foundation.NSFileManager;
import ch.cyberduck.ui.cocoa.foundation.NSNotification;
import ch.cyberduck.ui.cocoa.foundation.NSNumber;
import ch.cyberduck.ui.cocoa.foundation.NSObject;
import ch.cyberduck.ui.cocoa.foundation.NSString;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.AbstractLinkedMap;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.rococoa.Rococoa;
import org.rococoa.cocoa.foundation.NSUInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FinderLocal
extends Local {
    private static Logger log = Logger.getLogger(FinderLocal.class);
    private static boolean JNI_LOADED = false;
    private FinderLocalAttributes attributes;
    private static Map<String, String> defaultApplicationCache = Collections.synchronizedMap(new LRUMap(20){

        protected boolean removeLRU(AbstractLinkedMap.LinkEntry entry) {
            log.debug((Object)("Removing from cache:" + entry));
            return true;
        }
    });
    private static Map<String, List<String>> defaultApplicationListCache = Collections.synchronizedMap(new LRUMap(20){

        protected boolean removeLRU(AbstractLinkedMap.LinkEntry entry) {
            log.debug((Object)("Removing from cache:" + entry));
            return true;
        }
    });

    public FinderLocal(Local parent, String name) {
        super(parent, name);
    }

    public FinderLocal(String parent, String name) {
        super(parent, name);
    }

    public FinderLocal(String path) {
        super(path);
    }

    public FinderLocal(File path) {
        super(path);
    }

    public static void register() {
        LocalFactory.addFactory((Factory.Platform)Factory.NATIVE_PLATFORM, (LocalFactory)new Factory());
    }

    protected void setPath(String name) {
        if (FinderLocal.loadNative()) {
            super.setPath(this.resolveAlias(FinderLocal.stringByExpandingTildeInPath(name)));
        } else {
            super.setPath(FinderLocal.stringByExpandingTildeInPath(name));
        }
    }

    public void setPath(String parent, String name) {
        super.setPath(FinderLocal.stringByExpandingTildeInPath(parent), name);
    }

    public String getDisplayName() {
        return NSFileManager.defaultManager().displayNameAtPath(super.getName());
    }

    public String getAbbreviatedPath() {
        return FinderLocal.stringByAbbreviatingWithTildeInPath(this.getAbsolute());
    }

    public boolean exists() {
        return NSFileManager.defaultManager().fileExistsAtPath(this.getAbsolute());
    }

    public void symlink(String target) {
        if (!FinderLocal.loadNative()) {
            return;
        }
        boolean success = NSFileManager.defaultManager().createSymbolicLinkAtPath_pathContent(this.getAbsolute(), target);
        if (!success) {
            log.error((Object)("File attribute changed failed:" + this.getAbsolute()));
        }
    }

    private static boolean loadNative() {
        if (!JNI_LOADED) {
            JNI_LOADED = Native.load((String)"Local");
        }
        return JNI_LOADED;
    }

    private native String resolveAlias(String var1);

    public FinderLocalAttributes attributes() {
        if (null == this.attributes) {
            this.attributes = new FinderLocalAttributes();
        }
        return this.attributes;
    }

    public String kind() {
        String suffix = this.getExtension();
        if (StringUtils.isEmpty((String)suffix)) {
            return super.kind();
        }
        String kind = FinderLocal.kind(suffix);
        if (StringUtils.isEmpty((String)kind)) {
            return super.kind();
        }
        return kind;
    }

    public AbstractPath getSymlinkTarget() {
        if (!FinderLocal.loadNative()) {
            return super.getSymlinkTarget();
        }
        return LocalFactory.createLocal((Local)((Local)this.getParent()), (String)NSFileManager.defaultManager().destinationOfSymbolicLinkAtPath_error(this.getAbsolute(), null));
    }

    public static native String kind(String var0);

    public void writeUnixPermission(final Permission perm, final boolean recursive) {
        new ProxyController().invoke((MainAction)new DefaultMainAction(){

            public void run() {
                boolean success = NSFileManager.defaultManager().setAttributes_ofItemAtPath_error(NSDictionary.dictionaryWithObjectsForKeys(NSArray.arrayWithObject(NSNumber.numberWithInt(Integer.valueOf(perm.getOctalString(), 8))), NSArray.arrayWithObject("NSFilePosixPermissions")), FinderLocal.this.getAbsolute(), null);
                if (!success) {
                    log.error((Object)("File attribute changed failed:" + FinderLocal.this.getAbsolute()));
                }
                if (FinderLocal.this.attributes().isDirectory() && recursive) {
                    for (AbstractPath child : FinderLocal.this.children()) {
                        child.writeUnixPermission(perm, recursive);
                    }
                }
            }
        });
    }

    public void writeTimestamp(long created, final long modified, long accessed) {
        new ProxyController().invoke((MainAction)new DefaultMainAction(){

            public void run() {
                boolean success = NSFileManager.defaultManager().setAttributes_ofItemAtPath_error(NSDictionary.dictionaryWithObjectsForKeys(NSArray.arrayWithObject(NSDate.dateWithTimeIntervalSince1970(modified / 1000L)), NSArray.arrayWithObject("NSFileModificationDate")), FinderLocal.this.getAbsolute(), null);
                if (!success) {
                    log.error((Object)("File attribute changed failed:" + FinderLocal.this.getAbsolute()));
                }
            }
        });
    }

    public void trash() {
        if (this.exists()) {
            final FinderLocal file = this;
            new ProxyController().invoke((MainAction)new DefaultMainAction(){

                public void run() {
                    log.debug((Object)("Move " + file + " to Trash"));
                    if (!NSWorkspace.sharedWorkspace().performFileOperation("recycle", file.getParent().getAbsolute(), "", NSArray.arrayWithObject(file.getName()))) {
                        log.warn((Object)("Failed to move " + file.getAbsolute() + " to Trash"));
                    }
                }
            });
        }
    }

    public boolean reveal() {
        return NSWorkspace.sharedWorkspace().selectFile(this.getAbsolute(), this.getParent().getAbsolute());
    }

    public boolean equals(Object o) {
        if (o instanceof FinderLocal) {
            if (!this.exists()) {
                return super.equals(o);
            }
            FinderLocal other = (FinderLocal)((Object)o);
            if (!other.exists()) {
                return super.equals(o);
            }
            return this.attributes().getInode() == other.attributes().getInode();
        }
        return super.equals(o);
    }

    public void setQuarantine(final String originUrl, final String dataUrl) {
        if (!FinderLocal.loadNative()) {
            return;
        }
        if (StringUtils.isEmpty((String)originUrl)) {
            log.warn((Object)"No origin url given for quarantine");
            return;
        }
        if (StringUtils.isEmpty((String)dataUrl)) {
            log.warn((Object)"No data url given for quarantine");
            return;
        }
        new ProxyController().invoke((MainAction)new DefaultMainAction(){

            public void run() {
                FinderLocal.this.setQuarantine(FinderLocal.this.getAbsolute(), originUrl, dataUrl);
            }
        });
    }

    private native void setQuarantine(String var1, String var2, String var3);

    public void setWhereFrom(final String dataUrl) {
        if (!FinderLocal.loadNative()) {
            return;
        }
        if (StringUtils.isEmpty((String)dataUrl)) {
            log.warn((Object)"No data url given for quarantine");
            return;
        }
        new ProxyController().invoke((MainAction)new DefaultMainAction(){

            public void run() {
                FinderLocal.this.setWhereFrom(FinderLocal.this.getAbsolute(), dataUrl);
            }
        });
    }

    private native void setWhereFrom(String var1, String var2);

    public void setIcon(final int progress) {
        if (progress > 9 || progress < -1) {
            log.warn((Object)("Local#setIcon:" + progress));
            return;
        }
        if (Preferences.instance().getBoolean("queue.download.updateIcon")) {
            if (!FinderLocal.loadNative()) {
                return;
            }
            String path = this.getAbsolute();
            new ProxyController().invoke((MainAction)new DefaultMainAction(){

                public void run() {
                    if (-1 == progress) {
                        NSWorkspace.sharedWorkspace().setIcon_forFile_options(null, FinderLocal.this.getAbsolute(), new NSUInteger(0L));
                    } else {
                        NSWorkspace.sharedWorkspace().setIcon_forFile_options(IconCache.iconNamed("download" + progress + ".icns"), FinderLocal.this.getAbsolute(), new NSUInteger(0L));
                    }
                }
            });
        }
    }

    private static String stringByAbbreviatingWithTildeInPath(String string) {
        return NSString.stringByAbbreviatingWithTildeInPath(string);
    }

    private static String stringByExpandingTildeInPath(String string) {
        return NSString.stringByExpandingTildeInPath(string);
    }

    public String getDefaultApplication() {
        String extension = this.getExtension();
        if (!defaultApplicationCache.containsKey(extension)) {
            if (StringUtils.isEmpty((String)extension)) {
                return null;
            }
            String path = this.applicationForExtension(extension);
            if (StringUtils.isEmpty((String)path)) {
                defaultApplicationCache.put(extension, null);
            } else {
                NSBundle bundle = NSBundle.bundleWithPath(path);
                if (null == bundle) {
                    log.error((Object)("Loading bundle failed:" + path));
                    defaultApplicationCache.put(extension, null);
                } else {
                    defaultApplicationCache.put(extension, bundle.bundleIdentifier());
                }
            }
        }
        return defaultApplicationCache.get(extension);
    }

    protected native String applicationForExtension(String var1);

    public List<String> getDefaultApplications() {
        String extension = this.getExtension();
        if (StringUtils.isEmpty((String)extension)) {
            return Collections.emptyList();
        }
        if (!defaultApplicationListCache.containsKey(extension)) {
            ArrayList<String> applications = new ArrayList<String>(Arrays.asList(this.applicationListForExtension(extension)));
            String defaultApplication = this.getDefaultApplication();
            if (null != defaultApplication && !applications.contains(defaultApplication)) {
                applications.add(defaultApplication);
            }
            defaultApplicationListCache.put(extension, applications);
        }
        return defaultApplicationListCache.get(extension);
    }

    protected native String[] applicationListForExtension(String var1);

    public boolean open() {
        return NSWorkspace.sharedWorkspace().openFile(this.getAbsolute());
    }

    public void bounce() {
        NSDistributedNotificationCenter.defaultCenter().postNotification(NSNotification.notificationWithName("com.apple.DownloadFileFinished", this.getAbsolute()));
    }

    public String toString() {
        return FinderLocal.stringByAbbreviatingWithTildeInPath(this.getAbsolute());
    }

    private class FinderLocalAttributes
    extends Local.LocalAttributes {
        private FinderLocalAttributes() {
            super((Local)FinderLocal.this);
        }

        private NSDictionary getNativeAttributes() {
            if (!FinderLocal.this.exists()) {
                return null;
            }
            return NSFileManager.defaultManager().attributesOfItemAtPath_error(FinderLocal.this.getAbsolute(), null);
        }

        private NSObject getNativeAttribute(String name) {
            NSDictionary dict = this.getNativeAttributes();
            if (null == dict) {
                log.error((Object)("No such file:" + FinderLocal.this.getAbsolute()));
                return null;
            }
            return dict.objectForKey(name);
        }

        public long getSize() {
            if (!FinderLocal.loadNative()) {
                return super.getSize();
            }
            if (this.isDirectory()) {
                return -1L;
            }
            NSObject size = this.getNativeAttribute("NSFileSize");
            if (null == size) {
                return -1L;
            }
            return (long)Rococoa.cast(size, NSNumber.class).doubleValue();
        }

        public Permission getPermission() {
            if (!FinderLocal.loadNative()) {
                return Permission.EMPTY;
            }
            try {
                NSObject object = this.getNativeAttribute("NSFilePosixPermissions");
                if (null == object) {
                    return Permission.EMPTY;
                }
                String posixString = Integer.toOctalString(Rococoa.cast(object, NSNumber.class).intValue());
                return new FinderLocalPermission(Integer.parseInt(posixString.substring(posixString.length() - 3)));
            }
            catch (NumberFormatException e) {
                log.error((Object)e.getMessage());
                return Permission.EMPTY;
            }
        }

        public long getCreationDate() {
            if (!FinderLocal.loadNative()) {
                return super.getCreationDate();
            }
            NSObject object = this.getNativeAttribute("NSFileCreationDate");
            if (null == object) {
                return -1L;
            }
            return (long)(Rococoa.cast(object, NSDate.class).timeIntervalSince1970() * 1000.0);
        }

        public long getAccessedDate() {
            return -1L;
        }

        public String getOwner() {
            if (!FinderLocal.loadNative()) {
                return super.getOwner();
            }
            NSObject object = this.getNativeAttribute("NSFileOwnerAccountName");
            if (null == object) {
                return super.getOwner();
            }
            return object.toString();
        }

        public String getGroup() {
            if (!FinderLocal.loadNative()) {
                return super.getGroup();
            }
            NSObject object = this.getNativeAttribute("NSFileGroupOwnerAccountName");
            if (null == object) {
                return super.getGroup();
            }
            return object.toString();
        }

        public long getInode() {
            NSObject object = this.getNativeAttribute("NSFileSystemFileNumber");
            if (null == object) {
                return 0L;
            }
            NSNumber number = Rococoa.cast(object, NSNumber.class);
            return number.longValue();
        }

        public boolean isBundle() {
            return NSWorkspace.sharedWorkspace().isFilePackageAtPath(FinderLocal.this.getAbsolute());
        }

        public boolean isSymbolicLink() {
            if (!FinderLocal.loadNative()) {
                return super.isSymbolicLink();
            }
            return NSFileManager.defaultManager().destinationOfSymbolicLinkAtPath_error(FinderLocal.this.getAbsolute(), null) != null;
        }
    }

    private class FinderLocalPermission
    extends Permission {
        public FinderLocalPermission(int octal) {
            super(octal);
        }

        public boolean isExecutable() {
            return NSFileManager.defaultManager().isExecutableFileAtPath(FinderLocal.this.getAbsolute());
        }

        public boolean isReadable() {
            return NSFileManager.defaultManager().isReadableFileAtPath(FinderLocal.this.getAbsolute());
        }

        public boolean isWritable() {
            return NSFileManager.defaultManager().isWritableFileAtPath(FinderLocal.this.getAbsolute());
        }
    }

    private static class Factory
    extends LocalFactory {
        private Factory() {
        }

        protected Local create() {
            return new FinderLocal(System.getProperty("user.home"));
        }

        protected Local create(Local parent, String name) {
            return new FinderLocal(parent, name);
        }

        protected Local create(String parent, String name) {
            return new FinderLocal(parent, name);
        }

        protected Local create(String path) {
            return new FinderLocal(path);
        }

        protected Local create(File path) {
            return new FinderLocal(path);
        }
    }
}

