/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.i18n;

import ch.cyberduck.core.Factory;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.i18n.LocaleFactory;
import ch.cyberduck.ui.cocoa.foundation.NSBundle;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.collections.map.AbstractLinkedMap;
import org.apache.commons.collections.map.LRUMap;
import org.apache.log4j.Logger;

public class BundleLocale
extends Locale {
    private static Logger log = Logger.getLogger(BundleLocale.class);
    private static Map<String, String> cache = Collections.synchronizedMap(new LRUMap(){

        protected boolean removeLRU(AbstractLinkedMap.LinkEntry entry) {
            log.debug((Object)("Removing from cache:" + entry));
            return true;
        }
    });

    public static void register() {
        LocaleFactory.addFactory((Factory.Platform)Factory.NATIVE_PLATFORM, (LocaleFactory)new Factory());
    }

    public String get(String key, String table) {
        String identifier = table + "." + key;
        if (!cache.containsKey(identifier)) {
            cache.put(identifier, NSBundle.localizedString(key, table));
        }
        return cache.get(identifier);
    }

    private static class Factory
    extends LocaleFactory {
        private Factory() {
        }

        protected Locale create() {
            return new BundleLocale();
        }
    }
}

