/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.delegate;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.ui.cocoa.IconCache;
import ch.cyberduck.ui.cocoa.application.NSMenu;
import ch.cyberduck.ui.cocoa.application.NSMenuItem;
import ch.cyberduck.ui.cocoa.delegate.AbstractMenuDelegate;
import java.util.List;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.Selector;
import org.rococoa.cocoa.foundation.NSInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransferMenuDelegate
extends AbstractMenuDelegate {
    private static Logger log = Logger.getLogger(TransferMenuDelegate.class);
    private List<Path> roots;

    public TransferMenuDelegate(List<Path> roots) {
        this.roots = roots;
    }

    @Override
    public NSInteger numberOfItemsInMenu(NSMenu menu) {
        if (this.isPopulated()) {
            return new NSInteger(-1L);
        }
        return new NSInteger(this.roots.size());
    }

    @Override
    public boolean menuUpdateItemAtIndex(NSMenu menu, NSMenuItem item, NSInteger index, boolean cancel) {
        Path path = this.roots.get(index.intValue());
        item.setTitle(path.getName());
        if (path.getLocal().exists()) {
            item.setEnabled(true);
            item.setTarget(this.id());
            item.setAction(this.getDefaultAction());
        } else {
            item.setEnabled(false);
            item.setTarget(null);
        }
        item.setRepresentedObject(path.getLocal().getAbsolute());
        item.setImage(IconCache.instance().iconForPath(path, 16, false));
        return super.menuUpdateItemAtIndex(menu, item, index, cancel);
    }

    public void reveal(NSMenuItem sender) {
        Local l = LocalFactory.createLocal((String)sender.representedObject());
        l.reveal();
    }

    @Override
    protected Selector getDefaultAction() {
        return Foundation.selector("reveal:");
    }
}

