/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.delegate;

import ch.cyberduck.core.AbstractHostCollection;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.RendezvousCollection;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.ui.cocoa.BrowserController;
import ch.cyberduck.ui.cocoa.IconCache;
import ch.cyberduck.ui.cocoa.MainController;
import ch.cyberduck.ui.cocoa.application.NSMenu;
import ch.cyberduck.ui.cocoa.application.NSMenuItem;
import ch.cyberduck.ui.cocoa.delegate.CollectionMenuDelegate;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.Selector;
import org.rococoa.cocoa.foundation.NSInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RendezvousMenuDelegate
extends CollectionMenuDelegate<Host> {
    private static Logger log = Logger.getLogger(RendezvousMenuDelegate.class);

    public RendezvousMenuDelegate() {
        super(RendezvousCollection.defaultCollection());
    }

    @Override
    public boolean menuUpdateItemAtIndex(NSMenu menu, NSMenuItem item, NSInteger index, boolean cancel) {
        if (this.collection().size() == 0) {
            item.setTitle(Locale.localizedString((String)"No Bonjour services available"));
            item.setTarget(null);
            item.setAction(null);
            item.setImage(null);
            item.setEnabled(false);
        } else {
            Host h = (Host)this.collection().get(index.intValue());
            item.setTitle(h.getNickname());
            item.setTarget(this.id());
            item.setEnabled(true);
            item.setImage(IconCache.iconNamed(h.getProtocol().icon(), 16));
            item.setAction(this.getDefaultAction());
            item.setRepresentedObject(h.getUuid());
        }
        return super.menuUpdateItemAtIndex(menu, item, index, cancel);
    }

    public void rendezvousMenuClicked(NSMenuItem sender) {
        log.debug((Object)("rendezvousMenuClicked:" + sender));
        BrowserController controller = MainController.newDocument();
        controller.mount(((AbstractHostCollection)this.collection()).lookup(sender.representedObject()));
    }

    @Override
    protected Selector getDefaultAction() {
        return Foundation.selector("rendezvousMenuClicked:");
    }
}

