/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.delegate;

import ch.cyberduck.core.Collection;
import ch.cyberduck.core.CollectionListener;
import ch.cyberduck.ui.cocoa.application.NSMenu;
import ch.cyberduck.ui.cocoa.delegate.AbstractMenuDelegate;
import org.rococoa.cocoa.foundation.NSInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CollectionMenuDelegate<T>
extends AbstractMenuDelegate
implements CollectionListener<T> {
    private Collection<T> collection;

    public CollectionMenuDelegate(Collection<T> c) {
        this.collection = c;
        this.collection.addListener((CollectionListener)this);
    }

    protected Collection<T> collection() {
        return this.collection;
    }

    @Override
    public NSInteger numberOfItemsInMenu(NSMenu menu) {
        if (this.isPopulated()) {
            return new NSInteger(-1L);
        }
        if (this.collection().size() > 0) {
            return new NSInteger(this.collection().size());
        }
        return new NSInteger(1L);
    }

    public void collectionItemAdded(T item) {
        this.setNeedsUpdate(true);
    }

    public void collectionItemRemoved(T item) {
        this.setNeedsUpdate(true);
    }

    public void collectionItemChanged(T item) {
        this.setNeedsUpdate(true);
    }

    public void collectionLoaded() {
        this.setNeedsUpdate(true);
    }

    @Override
    protected void invalidate() {
        this.collection.removeListener((CollectionListener)this);
        super.invalidate();
    }
}

