/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.delegate;

import ch.cyberduck.core.AbstractHostCollection;
import ch.cyberduck.core.BookmarkCollection;
import ch.cyberduck.core.Host;
import ch.cyberduck.ui.cocoa.BrowserController;
import ch.cyberduck.ui.cocoa.IconCache;
import ch.cyberduck.ui.cocoa.MainController;
import ch.cyberduck.ui.cocoa.application.NSMenu;
import ch.cyberduck.ui.cocoa.application.NSMenuItem;
import ch.cyberduck.ui.cocoa.delegate.CollectionMenuDelegate;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.Selector;
import org.rococoa.cocoa.foundation.NSInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BookmarkMenuDelegate
extends CollectionMenuDelegate<Host> {
    private static Logger log = Logger.getLogger(BookmarkMenuDelegate.class);
    private static final int BOOKMARKS_INDEX = 7;

    public BookmarkMenuDelegate() {
        super(BookmarkCollection.defaultCollection());
    }

    @Override
    public NSInteger numberOfItemsInMenu(NSMenu menu) {
        if (this.isPopulated()) {
            return new NSInteger(-1L);
        }
        return new NSInteger(this.collection().size() + 7 + 3);
    }

    @Override
    public boolean menuUpdateItemAtIndex(NSMenu menu, NSMenuItem item, NSInteger index, boolean cancel) {
        if (index.intValue() == 7) {
            item.setEnabled(true);
            item.setImage(IconCache.iconNamed("history.tiff", 16));
        }
        if (index.intValue() == 8) {
            item.setEnabled(true);
            item.setImage(IconCache.iconNamed("rendezvous.tiff", 16));
        }
        if (index.intValue() > 9) {
            Host h = (Host)this.collection().get(index.intValue() - 10);
            item.setTitle(h.getNickname());
            item.setTarget(this.id());
            item.setImage(IconCache.iconNamed(h.getProtocol().icon(), 16));
            item.setAction(this.getDefaultAction());
            item.setRepresentedObject(h.getUuid());
        }
        return super.menuUpdateItemAtIndex(menu, item, index, cancel);
    }

    public void bookmarkMenuItemClicked(NSMenuItem sender) {
        log.debug((Object)("bookmarkMenuItemClicked:" + sender));
        BrowserController controller = MainController.newDocument();
        controller.mount(((AbstractHostCollection)this.collection()).lookup(sender.representedObject()));
    }

    @Override
    protected Selector getDefaultAction() {
        return Foundation.selector("bookmarkMenuItemClicked:");
    }
}

