/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.ui.cocoa.AlertController;
import ch.cyberduck.ui.cocoa.BundleController;
import ch.cyberduck.ui.cocoa.SheetCallback;
import ch.cyberduck.ui.cocoa.SheetController;
import ch.cyberduck.ui.cocoa.WindowListener;
import ch.cyberduck.ui.cocoa.application.NSAlert;
import ch.cyberduck.ui.cocoa.application.NSApplication;
import ch.cyberduck.ui.cocoa.application.NSButton;
import ch.cyberduck.ui.cocoa.application.NSPrintInfo;
import ch.cyberduck.ui.cocoa.application.NSPrintOperation;
import ch.cyberduck.ui.cocoa.application.NSPrintPanel;
import ch.cyberduck.ui.cocoa.application.NSTextField;
import ch.cyberduck.ui.cocoa.application.NSTextView;
import ch.cyberduck.ui.cocoa.application.NSView;
import ch.cyberduck.ui.cocoa.application.NSWindow;
import ch.cyberduck.ui.cocoa.foundation.NSArray;
import ch.cyberduck.ui.cocoa.foundation.NSAttributedString;
import ch.cyberduck.ui.cocoa.foundation.NSDictionary;
import ch.cyberduck.ui.cocoa.foundation.NSNotification;
import ch.cyberduck.ui.cocoa.foundation.NSNotificationCenter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.ID;
import org.rococoa.Rococoa;
import org.rococoa.cocoa.foundation.NSPoint;
import org.rococoa.cocoa.foundation.NSSize;
import org.rococoa.cocoa.foundation.NSUInteger;

public abstract class WindowController
extends BundleController
implements NSWindow.Delegate {
    private static Logger log = Logger.getLogger(WindowController.class);
    protected static final String DEFAULT = Locale.localizedString((String)"Default");
    protected NSWindow window;
    private Set<WindowListener> listeners = Collections.synchronizedSet(new HashSet());

    protected void invalidate() {
        this.listeners.clear();
        if (this.window != null) {
            this.window.setDelegate(null);
        }
        super.invalidate();
    }

    public void addListener(WindowListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(WindowListener listener) {
        this.listeners.remove(listener);
    }

    public void setWindow(NSWindow window) {
        this.window = window;
        this.window.setReleasedWhenClosed(!this.isSingleton());
        this.window.setMaxSize(new NSSize(this.getMaxWindowWidth(), this.getMaxWindowHeight()));
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("windowWillClose:"), "NSWindowWillCloseNotification", this.window);
    }

    public NSWindow window() {
        return this.window;
    }

    protected double getMaxWindowHeight() {
        return this.window().maxSize().height.doubleValue();
    }

    protected double getMaxWindowWidth() {
        return this.window().maxSize().width.doubleValue();
    }

    public boolean isSingleton() {
        return false;
    }

    public boolean isVisible() {
        NSWindow window = this.window();
        if (null == window) {
            return false;
        }
        return window.isVisible();
    }

    public void windowDidBecomeKey(NSNotification notification) {
    }

    public void windowDidResignKey(NSNotification notification) {
    }

    public void windowDidBecomeMain(NSNotification notification) {
    }

    public void windowDidResignMain(NSNotification notification) {
    }

    public boolean windowShouldClose(NSWindow sender) {
        return true;
    }

    public void windowWillClose(NSNotification notification) {
        log.debug((Object)("windowWillClose:" + notification));
        for (WindowListener listener : this.listeners.toArray(new WindowListener[this.listeners.size()])) {
            listener.windowWillClose();
        }
        if (!this.isSingleton()) {
            this.invalidate();
        }
    }

    protected void cascade() {
        NSArray windows = NSApplication.sharedApplication().windows();
        int count = windows.count().intValue();
        if (count != 0) {
            NSWindow window = Rococoa.cast(windows.objectAtIndex(new NSUInteger(count - 1)), NSWindow.class);
            NSPoint origin = window.frame().origin;
            origin = new NSPoint(origin.x.doubleValue(), origin.y.doubleValue() + window.frame().size.height.doubleValue());
            this.window.setFrameTopLeftPoint(this.window.cascadeTopLeftFromPoint(origin));
        }
    }

    protected void setState(NSButton toggle, boolean open) {
        if (open) {
            toggle.performClick(null);
        }
        toggle.setState(open ? 1 : 0);
    }

    public boolean hasSheet() {
        if (null == this.window) {
            return false;
        }
        return this.window.attachedSheet() != null;
    }

    protected int alert(NSAlert alert) {
        return this.alert(alert, (String)null);
    }

    protected int alert(NSAlert alert, String help) {
        final int[] response = new int[1];
        this.alert(alert, new SheetCallback(){

            public void callback(int returncode) {
                response[0] = returncode;
            }
        }, help);
        return response[0];
    }

    protected void alert(NSAlert alert, SheetCallback callback) {
        this.alert(alert, callback, null);
    }

    protected void alert(NSAlert alert, final SheetCallback callback, final String help) {
        AlertController c = new AlertController(this, alert){

            public void callback(int returncode) {
                callback.callback(returncode);
            }

            protected void help() {
                if (StringUtils.isBlank((String)help)) {
                    super.help();
                } else {
                    2.openUrl(help);
                }
            }
        };
        c.beginSheet();
    }

    protected void alert(NSWindow sheet) {
        this.alert(sheet, new SheetCallback(){

            public void callback(int returncode) {
            }
        });
    }

    protected void alert(NSWindow sheet, final SheetCallback callback) {
        SheetController c = new SheetController(this, sheet){

            public void callback(int returncode) {
                callback.callback(returncode);
            }
        };
        c.beginSheet();
    }

    protected void updateField(NSTextView f, String value) {
        f.setString(StringUtils.isNotBlank((String)value) ? value : "");
    }

    protected void updateField(NSTextField f, String value) {
        f.setStringValue(StringUtils.isNotBlank((String)value) ? value : "");
    }

    protected void updateField(NSTextField f, String value, NSDictionary attributes) {
        f.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes(StringUtils.isNotBlank((String)value) ? value : "", attributes));
    }

    public void helpButtonClicked(NSButton sender) {
        WindowController.openUrl(Preferences.instance().getProperty("website.help"));
    }

    protected void print(NSView view) {
        NSPrintInfo print = NSPrintInfo.sharedPrintInfo();
        print.setOrientation(1);
        NSPrintOperation op = NSPrintOperation.printOperationWithView_printInfo(view, print);
        op.setShowsPrintPanel(true);
        NSPrintPanel panel = op.printPanel();
        panel.setOptions(panel.options() | 8 | 4 | 0x10);
        op.runOperationModalForWindow_delegate_didRunSelector_contextInfo(this.window(), this.id(), Foundation.selector("printOperationDidRun:success:contextInfo:"), null);
    }

    public void printOperationDidRun_success_contextInfo(NSPrintOperation op, boolean success, ID contextInfo) {
        if (!success) {
            log.warn((Object)("Printing failed:" + (Object)((Object)contextInfo)));
        }
    }
}

