/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.ui.cocoa.UserDefaultsPreferences;
import ch.cyberduck.ui.cocoa.foundation.NSBundle;
import ch.cyberduck.ui.cocoa.foundation.NSDictionary;
import ch.cyberduck.ui.cocoa.foundation.NSMutableDictionary;
import org.apache.log4j.Logger;

public class UserDefaultsPortablePreferences
extends UserDefaultsPreferences {
    private static Logger log = Logger.getLogger(UserDefaultsPortablePreferences.class);
    private NSMutableDictionary dict;

    public void setProperty(String property, String value) {
        log.info((Object)("setProperty:" + property + "," + value));
        this.dict.setObjectForKey(value, property);
    }

    public void deleteProperty(String property) {
        this.dict.removeObjectForKey(property);
        this.save();
    }

    protected void load() {
        Local f = LocalFactory.createLocal((String)NSBundle.mainBundle().objectForInfoDictionaryKey("application.preferences.path").toString());
        if (f.exists()) {
            log.info((Object)("Found preferences file: " + f.toString()));
            this.dict = NSMutableDictionary.dictionary();
            this.dict.setDictionary(NSDictionary.dictionaryWithContentsOfFile(f.getAbsolute()));
        } else {
            this.dict = NSMutableDictionary.dictionary();
        }
    }

    public void save() {
        Local f = LocalFactory.createLocal((String)NSBundle.mainBundle().objectForInfoDictionaryKey("application.preferences.path").toString());
        f.getParent().mkdir(true);
        this.dict.writeToFile(f.getAbsolute());
    }
}

