/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.Factory;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.ui.AbstractDateFormatter;
import ch.cyberduck.ui.DateFormatter;
import ch.cyberduck.ui.DateFormatterFactory;
import ch.cyberduck.ui.cocoa.foundation.NSDate;
import ch.cyberduck.ui.cocoa.foundation.NSDateFormatter;
import ch.cyberduck.ui.cocoa.foundation.NSLocale;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;

public class UserDefaultsDateFormatter
extends AbstractDateFormatter
implements DateFormatter {
    private static Logger log = Logger.getLogger(UserDefaultsDateFormatter.class);
    private static final NSLocale locale = NSLocale.currentLocale();
    private static final NSDateFormatter longDateFormatter = NSDateFormatter.dateFormatter();
    private static final NSDateFormatter shortDateFormatter;
    private static final NSDateFormatter mediumDateFormatter;
    private static final NSDateFormatter longDateNaturalFormatter;
    private static final NSDateFormatter shortDateNaturalFormatter;
    private static final NSDateFormatter mediumDateNaturalFormatter;

    public static void register() {
        DateFormatterFactory.addFactory((Factory.Platform)Factory.NATIVE_PLATFORM, (DateFormatterFactory)new Factory());
    }

    private static NSLocale locale() {
        return locale;
    }

    private static NSDate toDate(long milliseconds) {
        return NSDate.dateWithTimeIntervalSince1970(milliseconds / 1000L);
    }

    public synchronized String getShortFormat(long milliseconds, boolean natural) {
        if (-1L == milliseconds) {
            return Locale.localizedString((String)"Unknown");
        }
        if (natural) {
            return shortDateNaturalFormatter.stringFromDate(UserDefaultsDateFormatter.toDate(milliseconds));
        }
        return shortDateFormatter.stringFromDate(UserDefaultsDateFormatter.toDate(milliseconds));
    }

    public synchronized String getMediumFormat(long milliseconds, boolean natural) {
        if (-1L == milliseconds) {
            return Locale.localizedString((String)"Unknown");
        }
        if (natural) {
            return mediumDateNaturalFormatter.stringFromDate(UserDefaultsDateFormatter.toDate(milliseconds));
        }
        return mediumDateFormatter.stringFromDate(UserDefaultsDateFormatter.toDate(milliseconds));
    }

    public synchronized String getLongFormat(long milliseconds, boolean natural) {
        if (-1L == milliseconds) {
            return Locale.localizedString((String)"Unknown");
        }
        if (natural) {
            return longDateNaturalFormatter.stringFromDate(UserDefaultsDateFormatter.toDate(milliseconds));
        }
        return longDateFormatter.stringFromDate(UserDefaultsDateFormatter.toDate(milliseconds));
    }

    static {
        longDateFormatter.setDateStyle(NSDateFormatter.kCFDateFormatterLongStyle);
        longDateFormatter.setTimeStyle(NSDateFormatter.kCFDateFormatterLongStyle);
        longDateFormatter.setLocale(UserDefaultsDateFormatter.locale());
        shortDateFormatter = NSDateFormatter.dateFormatter();
        shortDateFormatter.setDateStyle(NSDateFormatter.kCFDateFormatterShortStyle);
        shortDateFormatter.setTimeStyle(NSDateFormatter.kCFDateFormatterShortStyle);
        shortDateFormatter.setLocale(UserDefaultsDateFormatter.locale());
        mediumDateFormatter = NSDateFormatter.dateFormatter();
        mediumDateFormatter.setDateStyle(NSDateFormatter.kCFDateFormatterMediumStyle);
        mediumDateFormatter.setTimeStyle(NSDateFormatter.kCFDateFormatterMediumStyle);
        mediumDateFormatter.setLocale(UserDefaultsDateFormatter.locale());
        longDateNaturalFormatter = NSDateFormatter.dateFormatter();
        longDateNaturalFormatter.setDateStyle(NSDateFormatter.kCFDateFormatterLongStyle);
        longDateNaturalFormatter.setTimeStyle(NSDateFormatter.kCFDateFormatterLongStyle);
        longDateNaturalFormatter.setLocale(UserDefaultsDateFormatter.locale());
        if (longDateNaturalFormatter.respondsToSelector(Foundation.selector("setDoesRelativeDateFormatting:"))) {
            longDateNaturalFormatter.setDoesRelativeDateFormatting(true);
        }
        shortDateNaturalFormatter = NSDateFormatter.dateFormatter();
        shortDateNaturalFormatter.setDateStyle(NSDateFormatter.kCFDateFormatterShortStyle);
        shortDateNaturalFormatter.setTimeStyle(NSDateFormatter.kCFDateFormatterShortStyle);
        shortDateNaturalFormatter.setLocale(UserDefaultsDateFormatter.locale());
        if (shortDateNaturalFormatter.respondsToSelector(Foundation.selector("setDoesRelativeDateFormatting:"))) {
            shortDateNaturalFormatter.setDoesRelativeDateFormatting(true);
        }
        mediumDateNaturalFormatter = NSDateFormatter.dateFormatter();
        mediumDateNaturalFormatter.setDateStyle(NSDateFormatter.kCFDateFormatterMediumStyle);
        mediumDateNaturalFormatter.setTimeStyle(NSDateFormatter.kCFDateFormatterMediumStyle);
        mediumDateNaturalFormatter.setLocale(UserDefaultsDateFormatter.locale());
        if (mediumDateNaturalFormatter.respondsToSelector(Foundation.selector("setDoesRelativeDateFormatting:"))) {
            mediumDateNaturalFormatter.setDoesRelativeDateFormatting(true);
        }
    }

    private static class Factory
    extends DateFormatterFactory {
        private Factory() {
        }

        protected AbstractDateFormatter create() {
            return new UserDefaultsDateFormatter();
        }
    }
}

