/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.AbstractCollectionListener;
import ch.cyberduck.core.Collection;
import ch.cyberduck.core.CollectionListener;
import ch.cyberduck.core.DownloadTransfer;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Queue;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.Status;
import ch.cyberduck.core.SyncTransfer;
import ch.cyberduck.core.Transfer;
import ch.cyberduck.core.TransferAdapter;
import ch.cyberduck.core.TransferCollection;
import ch.cyberduck.core.TransferListener;
import ch.cyberduck.core.TransferOptions;
import ch.cyberduck.core.TransferPrompt;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.threading.AbstractBackgroundAction;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.core.threading.ControllerMainAction;
import ch.cyberduck.core.threading.MainAction;
import ch.cyberduck.ui.PathPasteboard;
import ch.cyberduck.ui.cocoa.AbstractTableDelegate;
import ch.cyberduck.ui.cocoa.IconCache;
import ch.cyberduck.ui.cocoa.SheetCallback;
import ch.cyberduck.ui.cocoa.TranscriptController;
import ch.cyberduck.ui.cocoa.TransferPromptController;
import ch.cyberduck.ui.cocoa.TransferTableDataSource;
import ch.cyberduck.ui.cocoa.WindowController;
import ch.cyberduck.ui.cocoa.application.NSAlert;
import ch.cyberduck.ui.cocoa.application.NSApplication;
import ch.cyberduck.ui.cocoa.application.NSCell;
import ch.cyberduck.ui.cocoa.application.NSDrawer;
import ch.cyberduck.ui.cocoa.application.NSImageView;
import ch.cyberduck.ui.cocoa.application.NSMenu;
import ch.cyberduck.ui.cocoa.application.NSMenuItem;
import ch.cyberduck.ui.cocoa.application.NSPopUpButton;
import ch.cyberduck.ui.cocoa.application.NSProgressIndicator;
import ch.cyberduck.ui.cocoa.application.NSStepper;
import ch.cyberduck.ui.cocoa.application.NSTableColumn;
import ch.cyberduck.ui.cocoa.application.NSTableView;
import ch.cyberduck.ui.cocoa.application.NSTextField;
import ch.cyberduck.ui.cocoa.application.NSToolbar;
import ch.cyberduck.ui.cocoa.application.NSToolbarItem;
import ch.cyberduck.ui.cocoa.application.NSView;
import ch.cyberduck.ui.cocoa.application.NSWindow;
import ch.cyberduck.ui.cocoa.delegate.AbstractMenuDelegate;
import ch.cyberduck.ui.cocoa.foundation.NSArray;
import ch.cyberduck.ui.cocoa.foundation.NSAttributedString;
import ch.cyberduck.ui.cocoa.foundation.NSIndexSet;
import ch.cyberduck.ui.cocoa.foundation.NSMutableAttributedString;
import ch.cyberduck.ui.cocoa.foundation.NSNotification;
import ch.cyberduck.ui.cocoa.foundation.NSNotificationCenter;
import ch.cyberduck.ui.cocoa.foundation.NSRange;
import ch.cyberduck.ui.cocoa.threading.AlertRepeatableBackgroundAction;
import ch.cyberduck.ui.cocoa.threading.WindowMainAction;
import ch.cyberduck.ui.cocoa.util.HyperlinkAttributedStringFactory;
import ch.cyberduck.ui.cocoa.view.ControllerCell;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.ID;
import org.rococoa.Rococoa;
import org.rococoa.Selector;
import org.rococoa.cocoa.CGFloat;
import org.rococoa.cocoa.foundation.NSInteger;
import org.rococoa.cocoa.foundation.NSSize;
import org.rococoa.cocoa.foundation.NSUInteger;

public class TransferController
extends WindowController
implements NSToolbar.Delegate {
    private static Logger log = Logger.getLogger(TransferController.class);
    private static TransferController instance = null;
    private NSToolbar toolbar;
    private NSTextField urlField;
    private NSTextField localField;
    private NSTextField localLabel;
    private NSImageView iconView;
    private NSStepper queueSizeStepper;
    private NSTextField filterField;
    NSProgressIndicator transferSpinner;
    private TranscriptController transcript;
    private NSDrawer logDrawer;
    private NSPopUpButton bandwidthPopup;
    private AbstractMenuDelegate bandwidthPopupDelegate;
    private final TableColumnFactory tableColumnsFactory = new TableColumnFactory();
    private NSTableView transferTable;
    private TransferTableDataSource transferTableModel;
    private AbstractTableDelegate<Transfer> transferTableDelegate;
    private final NSCell prototype = ControllerCell.controllerCell();
    private static final String TOOLBAR_RESUME = "Resume";
    private static final String TOOLBAR_RELOAD = "Reload";
    private static final String TOOLBAR_STOP = "Stop";
    private static final String TOOLBAR_REMOVE = "Remove";
    private static final String TOOLBAR_CLEAN_UP = "Clean Up";
    private static final String TOOLBAR_OPEN = "Open";
    private static final String TOOLBAR_SHOW = "Show";
    private static final String TOOLBAR_TRASH = "Trash";
    private static final String TOOLBAR_FILTER = "Search";
    private Map<String, NSToolbarItem> toolbarItems = new HashMap<String, NSToolbarItem>();

    public void awakeFromNib() {
        this.toolbar = NSToolbar.toolbarWithIdentifier("Queue Toolbar");
        this.toolbar.setDelegate(this.id());
        this.toolbar.setAllowsUserCustomization(true);
        this.toolbar.setAutosavesConfiguration(true);
        this.window.setToolbar(this.toolbar);
        TransferCollection source = TransferCollection.defaultCollection();
        if (source.isLocked()) {
            this.transferSpinner.startAnimation(null);
        }
        source.addListener((CollectionListener)new AbstractCollectionListener<Transfer>(){

            public void collectionLoaded() {
                TransferController.this.invoke((MainAction)new WindowMainAction(TransferController.this){

                    public void run() {
                        TransferController.this.transferSpinner.stopAnimation(null);
                        TransferController.this.transferTable.setGridStyleMask(NSTableView.NSTableViewSolidHorizontalGridLineMask);
                    }
                });
            }
        });
        if (!source.isLocked()) {
            this.transferSpinner.stopAnimation(null);
            this.transferTable.setGridStyleMask(NSTableView.NSTableViewSolidHorizontalGridLineMask);
        }
        super.awakeFromNib();
    }

    public void setWindow(NSWindow window) {
        window.setMovableByWindowBackground(true);
        window.setTitle(Locale.localizedString((String)"Transfers"));
        window.setDelegate(this.id());
        super.setWindow(window);
    }

    public boolean isSingleton() {
        return true;
    }

    public void windowDidBecomeKey(NSNotification notification) {
        this.updateHighlight();
    }

    public void windowDidResignKey(NSNotification notification) {
        this.updateHighlight();
    }

    public void windowDidBecomeMain(NSNotification notification) {
        this.updateHighlight();
    }

    public void windowDidResignMain(NSNotification notification) {
        this.updateHighlight();
    }

    public void setUrlField(NSTextField urlField) {
        this.urlField = urlField;
        this.urlField.setAllowsEditingTextAttributes(true);
        this.urlField.setSelectable(true);
    }

    public void setLocalField(NSTextField localField) {
        this.localField = localField;
        this.localField.setAllowsEditingTextAttributes(true);
        this.localField.setSelectable(true);
    }

    public void setLocalLabel(NSTextField localLabel) {
        this.localLabel = localLabel;
        this.localLabel.setStringValue(Locale.localizedString((String)"Local File:", (String)"Transfer"));
    }

    public void setIconView(NSImageView iconView) {
        this.iconView = iconView;
    }

    public void setQueueSizeStepper(NSStepper queueSizeStepper) {
        this.queueSizeStepper = queueSizeStepper;
        this.queueSizeStepper.setTarget(this.id());
        this.queueSizeStepper.setAction(Foundation.selector("queueSizeStepperChanged:"));
    }

    public void queueSizeStepperChanged(ID sender) {
        Queue.instance().resize();
    }

    public void setFilterField(NSTextField filterField) {
        this.filterField = filterField;
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("filterFieldTextDidChange:"), "NSControlTextDidChangeNotification", this.filterField);
    }

    public void filterFieldTextDidChange(NSNotification notification) {
        this.transferTableModel.setFilter(this.filterField.stringValue());
        this.reload();
    }

    public void setTransferSpinner(NSProgressIndicator transferSpinner) {
        this.transferSpinner = transferSpinner;
    }

    public void searchButtonClicked(ID sender) {
        this.window().makeFirstResponder(this.filterField);
    }

    public void drawerWillOpen(NSNotification notification) {
        this.logDrawer.setContentSize(new NSSize(this.logDrawer.contentSize().width.doubleValue(), Preferences.instance().getDouble("queue.logDrawer.size.height")));
    }

    public void drawerDidOpen(NSNotification notification) {
        Preferences.instance().setProperty("queue.logDrawer.isOpen", true);
    }

    public void drawerWillClose(NSNotification notification) {
        Preferences.instance().setProperty("queue.logDrawer.size.height", this.logDrawer.contentSize().height.doubleValue());
    }

    public void drawerDidClose(NSNotification notification) {
        Preferences.instance().setProperty("queue.logDrawer.isOpen", false);
    }

    public void setLogDrawer(NSDrawer logDrawer) {
        this.logDrawer = logDrawer;
        this.transcript = new TranscriptController();
        this.logDrawer.setContentView(this.transcript.getLogView());
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("drawerWillOpen:"), "NSDrawerWillOpenNotification", this.logDrawer);
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("drawerDidOpen:"), "NSDrawerDidOpenNotification", this.logDrawer);
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("drawerWillClose:"), "NSDrawerWillCloseNotification", this.logDrawer);
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("drawerDidClose:"), "NSDrawerDidCloseNotification", this.logDrawer);
    }

    public void toggleLogDrawer(ID sender) {
        this.logDrawer.toggle(sender);
    }

    public void setBandwidthPopup(NSPopUpButton bandwidthPopup) {
        this.bandwidthPopup = bandwidthPopup;
        this.bandwidthPopup.setEnabled(false);
        this.bandwidthPopup.setAllowsMixedState(true);
        this.bandwidthPopup.setTarget(this.id());
        this.bandwidthPopup.setAction(Foundation.selector("bandwidthPopupChanged:"));
        this.bandwidthPopup.removeAllItems();
        this.bandwidthPopup.addItemWithTitle("");
        this.bandwidthPopup.lastItem().setImage(IconCache.iconNamed("bandwidth.tiff", 16));
        this.bandwidthPopup.addItemWithTitle(Locale.localizedString((String)"Unlimited Bandwidth", (String)"Transfer"));
        this.bandwidthPopup.lastItem().setRepresentedObject(String.valueOf(-1));
        this.bandwidthPopup.menu().addItem(NSMenuItem.separatorItem());
        StringTokenizer options = new StringTokenizer(Preferences.instance().getProperty("queue.bandwidth.options"), ",");
        while (options.hasMoreTokens()) {
            String bytes = options.nextToken();
            this.bandwidthPopup.addItemWithTitle(Status.getSizeAsString((double)Integer.parseInt(bytes)) + "/s");
            this.bandwidthPopup.lastItem().setRepresentedObject(bytes);
        }
        this.bandwidthPopupDelegate = new BandwidthMenuDelegate();
        this.bandwidthPopup.menu().setDelegate(this.bandwidthPopupDelegate.id());
    }

    public void bandwidthPopupChanged(NSPopUpButton sender) {
        NSIndexSet iterator = this.transferTable.selectedRowIndexes();
        int bandwidth = Integer.valueOf(sender.selectedItem().representedObject());
        NSUInteger index = iterator.firstIndex();
        while (!index.equals((Object)NSIndexSet.NSNotFound)) {
            Transfer transfer = (Transfer)TransferCollection.defaultCollection().get(index.intValue());
            transfer.setBandwidth((float)bandwidth);
            index = iterator.indexGreaterThanIndex(index);
        }
        this.updateBandwidthPopup();
    }

    private TransferController() {
        this.loadBundle();
        TransferCollection.defaultCollection().addListener((CollectionListener)new AbstractCollectionListener<Transfer>(){

            public void collectionLoaded() {
                TransferController.this.invoke((MainAction)new ControllerMainAction(TransferController.this){

                    public void run() {
                        TransferController.this.reload();
                    }
                });
            }

            public void collectionItemAdded(Transfer item) {
                TransferController.this.invoke((MainAction)new ControllerMainAction(TransferController.this){

                    public void run() {
                        TransferController.this.reload();
                    }
                });
            }

            public void collectionItemRemoved(Transfer item) {
                TransferController.this.invoke((MainAction)new ControllerMainAction(TransferController.this){

                    public void run() {
                        TransferController.this.reload();
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TransferController instance() {
        NSApplication nSApplication = NSApplication.sharedApplication();
        synchronized (nSApplication) {
            if (null == instance) {
                instance = new TransferController();
            }
            return instance;
        }
    }

    protected String getBundleName() {
        return "Transfer";
    }

    protected void invalidate() {
        this.toolbar.setDelegate(null);
        this.toolbarItems.clear();
        this.transferTableModel.invalidate();
        this.bandwidthPopup.menu().setDelegate(null);
        super.invalidate();
    }

    public static NSUInteger applicationShouldTerminate(final NSApplication app) {
        if (null != instance) {
            Preferences.instance().setProperty("queue.openByDefault", instance.window().isVisible());
            if (TransferCollection.defaultCollection().numberOfRunningTransfers() > 0) {
                NSAlert alert = NSAlert.alert(Locale.localizedString((String)"Transfer in progress"), Locale.localizedString((String)"There are files currently being transferred. Quit anyway?"), Locale.localizedString((String)"Quit"), Locale.localizedString((String)"Cancel"), null);
                instance.alert(alert, new SheetCallback(){

                    public void callback(int returncode) {
                        if (returncode == 1) {
                            for (Transfer transfer : TransferCollection.defaultCollection()) {
                                if (!transfer.isRunning()) continue;
                                transfer.interrupt();
                            }
                            app.replyToApplicationShouldTerminate(true);
                        }
                        if (returncode == -1) {
                            app.replyToApplicationShouldTerminate(false);
                        }
                    }
                });
                return NSApplication.NSTerminateLater;
            }
        }
        return NSApplication.NSTerminateNow;
    }

    public void setQueueTable(NSTableView view) {
        this.transferTable = view;
        this.transferTable.setRowHeight(new CGFloat(82.0));
        this.transferTableModel = new TransferTableDataSource();
        this.transferTable.setDataSource(this.transferTableModel.id());
        this.transferTableDelegate = new AbstractTableDelegate<Transfer>(){

            @Override
            public String tooltip(Transfer t) {
                return t.getName();
            }

            @Override
            public void enterKeyPressed(ID sender) {
                this.tableRowDoubleClicked(sender);
            }

            @Override
            public void deleteKeyPressed(ID sender) {
                TransferController.this.deleteButtonClicked(sender);
            }

            @Override
            public void tableColumnClicked(NSTableView view, NSTableColumn tableColumn) {
            }

            @Override
            public void tableRowDoubleClicked(ID sender) {
                TransferController.this.reloadButtonClicked(sender);
            }

            @Override
            public void selectionIsChanging(NSNotification notification) {
                TransferController.this.updateHighlight();
            }

            @Override
            public void selectionDidChange(NSNotification notification) {
                TransferController.this.updateHighlight();
                TransferController.this.updateSelection();
                TransferController.this.transferTable.noteHeightOfRowsWithIndexesChanged(NSIndexSet.indexSetWithIndexesInRange(NSRange.NSMakeRange(new NSUInteger(0L), new NSUInteger(TransferController.this.transferTable.numberOfRows()))));
            }

            public void tableView_willDisplayCell_forTableColumn_row(NSTableView view, NSCell cell, NSTableColumn tableColumn, NSInteger row) {
                Rococoa.cast(cell, ControllerCell.class).setView(TransferController.this.transferTableModel.getController(row.intValue()).view());
            }

            @Override
            public boolean isTypeSelectSupported() {
                return true;
            }

            public String tableView_typeSelectStringForTableColumn_row(NSTableView tableView, NSTableColumn tableColumn, NSInteger row) {
                return ((Transfer)TransferController.this.transferTableModel.getSource().get(row.intValue())).getName();
            }
        };
        this.transferTable.setDelegate(this.transferTableDelegate.id());
        this.transferTable.registerForDraggedTypes(NSArray.arrayWithObjects("NSStringPboardType", "Apple files promise pasteboard type"));
        NSTableColumn c = this.tableColumnsFactory.create("PROGRESS");
        c.setMinWidth(80.0);
        c.setWidth(300.0);
        c.setResizingMask(1);
        c.setDataCell(this.prototype);
        this.transferTable.addTableColumn(c);
        this.transferTable.setGridStyleMask(NSTableView.NSTableViewGridNone);
        this.transferTable.setAllowsMultipleSelection(true);
        this.transferTable.setAllowsEmptySelection(true);
        this.transferTable.setAllowsColumnReordering(false);
        this.transferTable.sizeToFit();
    }

    private void updateHighlight() {
        boolean main = this.window().isMainWindow();
        NSIndexSet selected = this.transferTable.selectedRowIndexes();
        for (int i = 0; i < this.transferTableModel.numberOfRowsInTableView(this.transferTable).intValue(); ++i) {
            boolean highlighted;
            boolean bl = highlighted = selected.containsIndex(new NSUInteger(i)) && main;
            if (this.transferTableModel.isHighlighted(i) == highlighted) continue;
            this.transferTableModel.setHighlighted(i, highlighted);
        }
    }

    private void updateSelection() {
        log.debug((Object)"updateSelection");
        this.updateLabels();
        this.updateIcon();
        this.updateBandwidthPopup();
        this.toolbar.validateVisibleItems();
    }

    private void updateLabels() {
        log.debug((Object)"updateLabels");
        int selected = this.transferTable.numberOfSelectedRows().intValue();
        if (1 == selected) {
            Transfer transfer = (Transfer)this.transferTableModel.getSource().get(this.transferTable.selectedRow().intValue());
            String url = transfer.getRoot().toURL();
            this.urlField.setAttributedStringValue(HyperlinkAttributedStringFactory.create(NSMutableAttributedString.create(url, TRUNCATE_MIDDLE_ATTRIBUTES), url));
            if (transfer.numberOfRoots() == 1) {
                this.localField.setAttributedStringValue(HyperlinkAttributedStringFactory.create(NSMutableAttributedString.create(transfer.getRoot().getLocal().getAbsolute(), TRUNCATE_MIDDLE_ATTRIBUTES), transfer.getRoot().getLocal().toURL()));
            } else {
                this.localField.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes(Locale.localizedString((String)"Multiple files"), TRUNCATE_MIDDLE_ATTRIBUTES));
            }
        } else {
            this.urlField.setStringValue("");
            this.localField.setStringValue("");
        }
    }

    private void updateIcon() {
        log.debug((Object)"updateIcon");
        int selected = this.transferTable.numberOfSelectedRows().intValue();
        if (1 != selected) {
            this.iconView.setImage(null);
            return;
        }
        Transfer transfer = (Transfer)this.transferTableModel.getSource().get(this.transferTable.selectedRow().intValue());
        if (transfer.numberOfRoots() == 1) {
            this.iconView.setImage(IconCache.instance().iconForPath(transfer.getRoot().getLocal(), (Integer)32));
        } else {
            this.iconView.setImage(IconCache.iconNamed("NSMultipleDocuments", 32));
        }
    }

    private void updateBandwidthPopup() {
        log.debug((Object)"updateBandwidthPopup");
        int selected = this.transferTable.numberOfSelectedRows().intValue();
        this.bandwidthPopup.setEnabled(selected > 0);
        NSIndexSet iterator = this.transferTable.selectedRowIndexes();
        NSUInteger index = iterator.firstIndex();
        while (!index.equals((Object)NSIndexSet.NSNotFound)) {
            Transfer transfer = (Transfer)this.transferTableModel.getSource().get(index.intValue());
            if (transfer instanceof SyncTransfer) {
                this.bandwidthPopup.setEnabled(false);
                break;
            }
            if (transfer.getBandwidth() != -1.0f) {
                this.bandwidthPopup.itemAtIndex(new NSInteger(0L)).setImage(IconCache.iconNamed("turtle.tiff"));
                return;
            }
            index = iterator.indexGreaterThanIndex(index);
        }
        this.bandwidthPopup.itemAtIndex(new NSInteger(0L)).setImage(IconCache.iconNamed("bandwidth.tiff", 16));
    }

    private void reload() {
        while (this.transferTable.subviews().count().intValue() > 0) {
            Rococoa.cast(this.transferTable.subviews().lastObject(), NSView.class).removeFromSuperviewWithoutNeedingDisplay();
        }
        this.transferTable.reloadData();
        this.updateHighlight();
        this.updateSelection();
    }

    public void removeTransfer(Transfer transfer) {
        TransferCollection.defaultCollection().remove((Object)transfer);
    }

    public void addTransfer(Transfer transfer) {
        TransferCollection.defaultCollection().add(transfer);
        int row = TransferCollection.defaultCollection().size() - 1;
        NSInteger index = new NSInteger(row);
        this.transferTable.selectRowIndexes(NSIndexSet.indexSetWithIndex(index), false);
        this.transferTable.scrollRowToVisible(index);
    }

    public void startTransfer(Transfer transfer) {
        this.startTransfer(transfer, false, false);
    }

    private void startTransfer(final Transfer transfer, final boolean resumeRequested, final boolean reloadRequested) {
        if (!TransferCollection.defaultCollection().contains((Object)transfer)) {
            this.addTransfer(transfer);
        }
        if (Preferences.instance().getBoolean("queue.orderFrontOnStart")) {
            this.window().makeKeyAndOrderFront(null);
        }
        this.background((BackgroundAction)new AlertRepeatableBackgroundAction(this){
            private boolean resume;
            private boolean reload;
            private TransferListener tl;
            private final Object lock;
            {
                super(x0);
                this.resume = resumeRequested;
                this.reload = reloadRequested;
                this.lock = new Object();
            }

            public boolean prepare() {
                this.tl = new TransferAdapter(){

                    public void transferQueued() {
                        TransferController.this.validateToolbar();
                    }

                    public void transferResumed() {
                        TransferController.this.validateToolbar();
                    }

                    public void transferWillStart() {
                        TransferController.this.validateToolbar();
                        this.badge();
                    }

                    public void transferDidEnd() {
                        TransferController.this.validateToolbar();
                        this.badge();
                    }

                    private void badge() {
                        if (Preferences.instance().getBoolean("queue.dock.badge")) {
                            int count = TransferCollection.defaultCollection().numberOfRunningTransfers();
                            if (0 == count) {
                                NSApplication.sharedApplication().dockTile().setBadgeLabel("");
                            } else {
                                NSApplication.sharedApplication().dockTile().setBadgeLabel(String.valueOf(count));
                            }
                        }
                    }
                };
                transfer.addListener(this.tl);
                super.prepare();
                return true;
            }

            public void run() {
                TransferOptions options = new TransferOptions();
                options.reloadRequested = this.reload;
                options.resumeRequested = this.resume;
                transfer.start((TransferPrompt)TransferPromptController.create(TransferController.this, transfer), options);
            }

            public void finish() {
                super.finish();
                transfer.removeListener(this.tl);
                this.reload = false;
                this.resume = true;
            }

            public void cleanup() {
                if (transfer.isComplete() && !transfer.isCanceled() && transfer.isReset()) {
                    if (Preferences.instance().getBoolean("queue.removeItemWhenComplete")) {
                        TransferController.this.removeTransfer(transfer);
                    }
                    if (Preferences.instance().getBoolean("queue.orderBackOnStop") && TransferCollection.defaultCollection().numberOfRunningTransfers() <= 0) {
                        TransferController.this.window().close();
                    }
                }
                TransferCollection.defaultCollection().save();
            }

            public Session getSession() {
                return transfer.getSession();
            }

            public void pause() {
                transfer.fireTransferQueued();
                this.resume = true;
                super.pause();
                transfer.fireTransferResumed();
            }

            public boolean isCanceled() {
                return transfer.isCanceled();
            }

            public void log(final boolean request, final String message) {
                if (TransferController.this.logDrawer.state() == 2) {
                    TransferController.this.invoke((MainAction)new WindowMainAction(TransferController.this){

                        public void run() {
                            TransferController.this.transcript.log(request, message);
                        }
                    });
                }
                super.log(request, message);
            }

            public Object lock() {
                return this.lock;
            }
        });
    }

    private void validateToolbar() {
        this.invoke((MainAction)new WindowMainAction(this){

            public void run() {
                TransferController.this.window().toolbar().validateVisibleItems();
                TransferController.this.updateIcon();
            }
        });
    }

    public NSToolbarItem toolbar_itemForItemIdentifier_willBeInsertedIntoToolbar(NSToolbar toolbar, String itemIdentifier, boolean flag) {
        if (!this.toolbarItems.containsKey(itemIdentifier)) {
            this.toolbarItems.put(itemIdentifier, NSToolbarItem.itemWithIdentifier(itemIdentifier));
        }
        NSToolbarItem item = this.toolbarItems.get(itemIdentifier);
        if (itemIdentifier.equals(TOOLBAR_STOP)) {
            item.setLabel(Locale.localizedString((String)TOOLBAR_STOP));
            item.setPaletteLabel(Locale.localizedString((String)TOOLBAR_STOP));
            item.setToolTip(Locale.localizedString((String)TOOLBAR_STOP));
            item.setImage(IconCache.iconNamed("stop.tiff", 32));
            item.setTarget(this.id());
            item.setAction(Foundation.selector("stopButtonClicked:"));
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_RESUME)) {
            item.setLabel(Locale.localizedString((String)TOOLBAR_RESUME));
            item.setPaletteLabel(Locale.localizedString((String)TOOLBAR_RESUME));
            item.setToolTip(Locale.localizedString((String)TOOLBAR_RESUME));
            item.setImage(IconCache.iconNamed("resume.tiff"));
            item.setTarget(this.id());
            item.setAction(Foundation.selector("resumeButtonClicked:"));
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_RELOAD)) {
            item.setLabel(Locale.localizedString((String)TOOLBAR_RELOAD));
            item.setPaletteLabel(Locale.localizedString((String)TOOLBAR_RELOAD));
            item.setToolTip(Locale.localizedString((String)TOOLBAR_RELOAD));
            item.setImage(IconCache.iconNamed("reload.tiff"));
            item.setTarget(this.id());
            item.setAction(Foundation.selector("reloadButtonClicked:"));
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_SHOW)) {
            item.setLabel(Locale.localizedString((String)TOOLBAR_SHOW));
            item.setPaletteLabel(Locale.localizedString((String)"Show in Finder"));
            item.setToolTip(Locale.localizedString((String)"Show in Finder"));
            item.setImage(IconCache.iconNamed("reveal.tiff"));
            item.setTarget(this.id());
            item.setAction(Foundation.selector("revealButtonClicked:"));
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_OPEN)) {
            item.setLabel(Locale.localizedString((String)TOOLBAR_OPEN));
            item.setPaletteLabel(Locale.localizedString((String)TOOLBAR_OPEN));
            item.setToolTip(Locale.localizedString((String)TOOLBAR_OPEN));
            item.setImage(IconCache.iconNamed("open.tiff"));
            item.setTarget(this.id());
            item.setAction(Foundation.selector("openButtonClicked:"));
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_REMOVE)) {
            item.setLabel(Locale.localizedString((String)TOOLBAR_REMOVE));
            item.setPaletteLabel(Locale.localizedString((String)TOOLBAR_REMOVE));
            item.setToolTip(Locale.localizedString((String)TOOLBAR_REMOVE));
            item.setImage(IconCache.iconNamed("clean.tiff"));
            item.setTarget(this.id());
            item.setAction(Foundation.selector("deleteButtonClicked:"));
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_CLEAN_UP)) {
            item.setLabel(Locale.localizedString((String)TOOLBAR_CLEAN_UP));
            item.setPaletteLabel(Locale.localizedString((String)TOOLBAR_CLEAN_UP));
            item.setToolTip(Locale.localizedString((String)TOOLBAR_CLEAN_UP));
            item.setImage(IconCache.iconNamed("cleanAll.tiff"));
            item.setTarget(this.id());
            item.setAction(Foundation.selector("clearButtonClicked:"));
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_TRASH)) {
            item.setLabel(Locale.localizedString((String)TOOLBAR_TRASH));
            item.setPaletteLabel(Locale.localizedString((String)TOOLBAR_TRASH));
            item.setToolTip(Locale.localizedString((String)"Move to Trash"));
            item.setImage(IconCache.iconNamed("trash.tiff"));
            item.setTarget(this.id());
            item.setAction(Foundation.selector("trashButtonClicked:"));
            return item;
        }
        if (itemIdentifier.equals(TOOLBAR_FILTER)) {
            item.setLabel(Locale.localizedString((String)TOOLBAR_FILTER));
            item.setPaletteLabel(Locale.localizedString((String)TOOLBAR_FILTER));
            item.setView(this.filterField);
            item.setMinSize(this.filterField.frame().size);
            item.setMaxSize(this.filterField.frame().size);
            return item;
        }
        return null;
    }

    public void paste(ID sender) {
        log.debug((Object)"paste");
        for (PathPasteboard pasteboard : PathPasteboard.allPasteboards()) {
            if (pasteboard.isEmpty()) continue;
            TransferCollection.defaultCollection().add((Transfer)new DownloadTransfer(pasteboard.copy()));
            pasteboard.clear();
        }
    }

    public void stopButtonClicked(ID sender) {
        NSIndexSet iterator = this.transferTable.selectedRowIndexes();
        NSUInteger index = iterator.firstIndex();
        while (!index.equals((Object)NSIndexSet.NSNotFound)) {
            final Transfer transfer = (Transfer)this.transferTableModel.getSource().get(index.intValue());
            if (transfer.isRunning()) {
                this.background((BackgroundAction)new AbstractBackgroundAction(){

                    public void run() {
                        transfer.cancel();
                    }
                });
            }
            index = iterator.indexGreaterThanIndex(index);
        }
    }

    public void stopAllButtonClicked(ID sender) {
        Collection<Transfer> transfers = this.transferTableModel.getSource();
        for (final Transfer transfer : transfers) {
            if (!transfer.isRunning()) continue;
            this.background((BackgroundAction)new AbstractBackgroundAction(){

                public void run() {
                    transfer.cancel();
                }
            });
        }
    }

    public void resumeButtonClicked(ID sender) {
        NSIndexSet iterator = this.transferTable.selectedRowIndexes();
        NSUInteger index = iterator.firstIndex();
        while (!index.equals((Object)NSIndexSet.NSNotFound)) {
            Collection<Transfer> transfers = this.transferTableModel.getSource();
            Transfer transfer = (Transfer)transfers.get(index.intValue());
            if (!transfer.isRunning()) {
                this.startTransfer(transfer, true, false);
            }
            index = iterator.indexGreaterThanIndex(index);
        }
    }

    public void reloadButtonClicked(ID sender) {
        NSIndexSet iterator = this.transferTable.selectedRowIndexes();
        NSUInteger index = iterator.firstIndex();
        while (!index.equals((Object)NSIndexSet.NSNotFound)) {
            Collection<Transfer> transfers = this.transferTableModel.getSource();
            Transfer transfer = (Transfer)transfers.get(index.intValue());
            if (!transfer.isRunning()) {
                this.startTransfer(transfer, false, true);
            }
            index = iterator.indexGreaterThanIndex(index);
        }
    }

    public void openButtonClicked(ID sender) {
        if (this.transferTable.numberOfSelectedRows().intValue() == 1) {
            Transfer transfer = (Transfer)this.transferTableModel.getSource().get(this.transferTable.selectedRow().intValue());
            for (Path i : transfer.getRoots()) {
                Local l = i.getLocal();
                if (l.open()) continue;
                log.warn((Object)("Error opening file:" + l.getAbsolute()));
            }
        }
    }

    public void revealButtonClicked(ID sender) {
        NSIndexSet iterator = this.transferTable.selectedRowIndexes();
        Collection<Transfer> transfers = this.transferTableModel.getSource();
        NSUInteger index = iterator.firstIndex();
        while (!index.equals((Object)NSIndexSet.NSNotFound)) {
            Path i;
            Local l;
            Transfer transfer = (Transfer)transfers.get(index.intValue());
            Iterator i$ = transfer.getRoots().iterator();
            while (i$.hasNext() && !(l = (i = (Path)i$.next()).getLocal()).reveal()) {
            }
            index = iterator.indexGreaterThanIndex(index);
        }
    }

    public void deleteButtonClicked(ID sender) {
        NSIndexSet iterator = this.transferTable.selectedRowIndexes();
        Collection<Transfer> transfers = this.transferTableModel.getSource();
        int i = 0;
        NSUInteger index = iterator.firstIndex();
        while (!index.equals((Object)NSIndexSet.NSNotFound)) {
            Transfer transfer = (Transfer)transfers.get(index.intValue() - i);
            if (!transfer.isRunning()) {
                TransferCollection.defaultCollection().remove((Object)transfer);
                ++i;
            }
            index = iterator.indexGreaterThanIndex(index);
        }
        TransferCollection.defaultCollection().save();
    }

    public void clearButtonClicked(ID sender) {
        Collection<Transfer> transfers = this.transferTableModel.getSource();
        for (Transfer transfer : transfers) {
            if (transfer.isRunning() || !transfer.isComplete()) continue;
            TransferCollection.defaultCollection().remove((Object)transfer);
        }
        TransferCollection.defaultCollection().save();
    }

    public void trashButtonClicked(ID sender) {
        NSIndexSet iterator = this.transferTable.selectedRowIndexes();
        Collection<Transfer> transfers = this.transferTableModel.getSource();
        NSUInteger index = iterator.firstIndex();
        while (!index.equals((Object)NSIndexSet.NSNotFound)) {
            Transfer transfer = (Transfer)transfers.get(index.intValue());
            if (!transfer.isRunning()) {
                for (Path i : transfer.getRoots()) {
                    i.getLocal().delete();
                }
            }
            index = iterator.indexGreaterThanIndex(index);
        }
        this.updateIcon();
    }

    public void printDocument(ID sender) {
        this.print(this.transferTable);
    }

    public NSArray toolbarDefaultItemIdentifiers(NSToolbar toolbar) {
        return NSArray.arrayWithObjects(TOOLBAR_RESUME, TOOLBAR_STOP, TOOLBAR_RELOAD, TOOLBAR_REMOVE, TOOLBAR_SHOW, "NSToolbarFlexibleSpaceItem", TOOLBAR_FILTER);
    }

    public NSArray toolbarAllowedItemIdentifiers(NSToolbar toolbar) {
        return NSArray.arrayWithObjects(TOOLBAR_RESUME, TOOLBAR_RELOAD, TOOLBAR_STOP, TOOLBAR_REMOVE, TOOLBAR_CLEAN_UP, TOOLBAR_SHOW, TOOLBAR_OPEN, TOOLBAR_TRASH, TOOLBAR_FILTER, "NSToolbarCustomizeToolbarItem", "NSToolbarSpaceItem", "NSToolbarSeparatorItem", "NSToolbarFlexibleSpaceItem");
    }

    public NSArray toolbarSelectableItemIdentifiers(NSToolbar toolbar) {
        return NSArray.array();
    }

    public boolean validateMenuItem(NSMenuItem item) {
        Selector action = item.action();
        if (action.equals((Object)Foundation.selector("paste:"))) {
            List pasteboards = PathPasteboard.allPasteboards();
            if (pasteboards.size() == 1) {
                for (PathPasteboard pasteboard : pasteboards) {
                    if (pasteboard.size() == 1) {
                        item.setTitle(MessageFormat.format(Locale.localizedString((String)"Paste {0}"), ((Path)pasteboard.get(0)).getName()));
                        continue;
                    }
                    item.setTitle(MessageFormat.format(Locale.localizedString((String)"Paste {0}"), MessageFormat.format(Locale.localizedString((String)"{0} Files"), String.valueOf(pasteboard.size())) + ")"));
                }
            } else {
                item.setTitle(Locale.localizedString((String)"Paste"));
            }
        }
        return this.validateItem(action);
    }

    public boolean validateToolbarItem(NSToolbarItem item) {
        return this.validateItem(item.action());
    }

    private boolean validateItem(Selector action) {
        if (action.equals((Object)Foundation.selector("paste:"))) {
            return !PathPasteboard.allPasteboards().isEmpty();
        }
        if (action.equals((Object)Foundation.selector("stopButtonClicked:"))) {
            return this.validate(new TransferToolbarValidator(){

                public boolean validate(Transfer transfer) {
                    return transfer.isRunning();
                }
            });
        }
        if (action.equals((Object)Foundation.selector("reloadButtonClicked:")) || action.equals((Object)Foundation.selector("deleteButtonClicked:"))) {
            return this.validate(new TransferToolbarValidator(){

                public boolean validate(Transfer transfer) {
                    return !transfer.isRunning();
                }
            });
        }
        if (action.equals((Object)Foundation.selector("resumeButtonClicked:"))) {
            return this.validate(new TransferToolbarValidator(){

                public boolean validate(Transfer transfer) {
                    if (transfer.isRunning()) {
                        return false;
                    }
                    return transfer.isResumable() && !transfer.isComplete();
                }
            });
        }
        if (action.equals((Object)Foundation.selector("openButtonClicked:")) || action.equals((Object)Foundation.selector("trashButtonClicked:"))) {
            return this.validate(new TransferToolbarValidator(){

                public boolean validate(Transfer transfer) {
                    if (!transfer.isComplete()) {
                        return false;
                    }
                    if (!transfer.isRunning()) {
                        for (Path i : transfer.getRoots()) {
                            if (!i.getLocal().exists()) continue;
                            return true;
                        }
                    }
                    return false;
                }
            });
        }
        if (action.equals((Object)Foundation.selector("revealButtonClicked:"))) {
            return this.validate(new TransferToolbarValidator(){

                public boolean validate(Transfer transfer) {
                    for (Path i : transfer.getRoots()) {
                        if (!i.getLocal().exists()) continue;
                        return true;
                    }
                    return false;
                }
            });
        }
        if (action.equals((Object)Foundation.selector("clearButtonClicked:"))) {
            return this.transferTable.numberOfRows().intValue() > 0;
        }
        return true;
    }

    private boolean validate(TransferToolbarValidator v) {
        NSIndexSet iterator = this.transferTable.selectedRowIndexes();
        Collection<Transfer> transfers = this.transferTableModel.getSource();
        NSUInteger index = iterator.firstIndex();
        while (!index.equals((Object)NSIndexSet.NSNotFound)) {
            Transfer transfer = (Transfer)transfers.get(index.intValue());
            if (v.validate(transfer)) {
                return true;
            }
            index = iterator.indexGreaterThanIndex(index);
        }
        return false;
    }

    private static interface TransferToolbarValidator {
        public boolean validate(Transfer var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TableColumnFactory
    extends HashMap<String, NSTableColumn> {
        private TableColumnFactory() {
        }

        private NSTableColumn create(String identifier) {
            if (!this.containsKey(identifier)) {
                this.put(identifier, NSTableColumn.tableColumnWithIdentifier(identifier));
            }
            return (NSTableColumn)this.get(identifier);
        }
    }

    private class BandwidthMenuDelegate
    extends AbstractMenuDelegate {
        private BandwidthMenuDelegate() {
        }

        public NSInteger numberOfItemsInMenu(NSMenu menu) {
            return new NSInteger(new StringTokenizer(Preferences.instance().getProperty("queue.bandwidth.options"), ",").countTokens() + 3);
        }

        public boolean menuUpdateItemAtIndex(NSMenu menu, NSMenuItem item, NSInteger i, boolean cancel) {
            log.debug((Object)("menuUpdateItemAtIndex:" + item));
            if (item.representedObject() != null) {
                int selected = TransferController.this.transferTable.numberOfSelectedRows().intValue();
                int bytes = Integer.valueOf(item.representedObject());
                NSIndexSet iterator = TransferController.this.transferTable.selectedRowIndexes();
                NSUInteger index = iterator.firstIndex();
                while (!index.equals((Object)NSIndexSet.NSNotFound)) {
                    Transfer transfer = (Transfer)TransferCollection.defaultCollection().get(index.intValue());
                    if (-1.0f == transfer.getBandwidth()) {
                        if (-1 == bytes) {
                            item.setState(selected > 1 ? -1 : 1);
                            break;
                        }
                        item.setState(0);
                    } else {
                        int bandwidth = (int)transfer.getBandwidth();
                        if (bytes == bandwidth) {
                            item.setState(selected > 1 ? -1 : 1);
                            break;
                        }
                        item.setState(0);
                    }
                    index = iterator.indexGreaterThanIndex(index);
                }
            }
            return super.menuUpdateItemAtIndex(menu, item, i, cancel);
        }

        protected Selector getDefaultAction() {
            return Foundation.selector("bandwidthPopupChanged:");
        }
    }
}

