/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.ui.cocoa.BundleController;
import ch.cyberduck.ui.cocoa.application.NSColor;
import ch.cyberduck.ui.cocoa.application.NSFont;
import ch.cyberduck.ui.cocoa.application.NSTextView;
import ch.cyberduck.ui.cocoa.application.NSView;
import ch.cyberduck.ui.cocoa.foundation.NSArray;
import ch.cyberduck.ui.cocoa.foundation.NSAttributedString;
import ch.cyberduck.ui.cocoa.foundation.NSDictionary;
import ch.cyberduck.ui.cocoa.foundation.NSRange;
import org.rococoa.cocoa.foundation.NSUInteger;

public class TranscriptController
extends BundleController
implements TranscriptListener {
    protected static final NSDictionary FIXED_WITH_FONT_REQUEST_ATTRIBUTES = NSDictionary.dictionaryWithObjectsForKeys(NSArray.arrayWithObjects(NSFont.userFixedPitchFontOfSize(9.0)), NSArray.arrayWithObjects("NSFont"));
    public static NSDictionary FIXED_WITH_FONT_RESPONSE_ATTRIBUTES = NSDictionary.dictionaryWithObjectsForKeys(NSArray.arrayWithObjects(NSFont.userFixedPitchFontOfSize(9.0), NSColor.darkGrayColor()), NSArray.arrayWithObjects("NSFont", "NSColor"));
    private NSView logView;
    private NSTextView logTextView;

    public void setLogView(NSView logView) {
        this.logView = logView;
    }

    public NSView getLogView() {
        return this.logView;
    }

    public void setLogTextView(NSTextView logTextView) {
        this.logTextView = logTextView;
    }

    protected String getBundleName() {
        return "Transcript";
    }

    public TranscriptController() {
        this.loadBundle();
    }

    public void log(boolean request, String transcript) {
        this.write(request ? FIXED_WITH_FONT_REQUEST_ATTRIBUTES : FIXED_WITH_FONT_RESPONSE_ATTRIBUTES, transcript);
    }

    public void write(NSDictionary font, String transcript) {
        this.logTextView.textStorage().appendAttributedString(NSAttributedString.attributedStringWithAttributes(transcript + "\n", font));
        this.logTextView.scrollRangeToVisible(NSRange.NSMakeRange(this.logTextView.textStorage().length(), new NSUInteger(0L)));
    }

    public void clear() {
        this.logTextView.setString("");
    }
}

