/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.Preferences;
import ch.cyberduck.ui.cocoa.IconCache;
import ch.cyberduck.ui.cocoa.WindowController;
import ch.cyberduck.ui.cocoa.application.NSTabView;
import ch.cyberduck.ui.cocoa.application.NSTabViewItem;
import ch.cyberduck.ui.cocoa.application.NSToolbar;
import ch.cyberduck.ui.cocoa.application.NSToolbarItem;
import ch.cyberduck.ui.cocoa.application.NSView;
import ch.cyberduck.ui.cocoa.application.NSWindow;
import ch.cyberduck.ui.cocoa.foundation.FoundationKitFunctionsLibrary;
import ch.cyberduck.ui.cocoa.foundation.NSArray;
import ch.cyberduck.ui.cocoa.foundation.NSEnumerator;
import ch.cyberduck.ui.cocoa.foundation.NSNotification;
import ch.cyberduck.ui.cocoa.foundation.NSObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.Rococoa;
import org.rococoa.cocoa.foundation.NSPoint;
import org.rococoa.cocoa.foundation.NSRect;
import org.rococoa.cocoa.foundation.NSSize;
import org.rococoa.cocoa.foundation.NSUInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ToolbarWindowController
extends WindowController
implements NSToolbar.Delegate,
NSTabView.Delegate {
    private static Logger log = Logger.getLogger(ToolbarWindowController.class);
    protected NSTabView tabView;
    private NSToolbar toolbar;
    private List<NSTabViewItem> tabs = new ArrayList<NSTabViewItem>();
    private String windowTitle;
    private Map<String, NSToolbarItem> cache = new HashMap<String, NSToolbarItem>();

    @Override
    public void windowDidBecomeKey(NSNotification notification) {
        this.resize();
        super.windowDidBecomeKey(notification);
    }

    protected abstract List<NSView> getPanels();

    protected abstract List<String> getPanelIdentifiers();

    @Override
    public void awakeFromNib() {
        Iterator<String> identifiers = this.getPanelIdentifiers().iterator();
        for (NSView panel : this.getPanels()) {
            int i = this.tabView.indexOfTabViewItemWithIdentifier(identifiers.next());
            this.tabView.tabViewItemAtIndex(i).setView(panel);
        }
        this.toolbar = NSToolbar.toolbarWithIdentifier(this.getToolbarName());
        this.toolbar.setAllowsUserCustomization(false);
        this.toolbar.setSizeMode(this.getToolbarSize());
        this.toolbar.setDisplayMode(this.getToolbarMode());
        this.toolbar.setDelegate(this.id());
        this.window().setToolbar(this.toolbar);
        this.setSelectedTab(Preferences.instance().getInteger(this.getToolbarName() + ".selected"));
        super.awakeFromNib();
    }

    protected void setSelectedTab(int tab) {
        if (-1 == tab) {
            tab = 0;
        }
        this.tabView.selectTabViewItemAtIndex(tab);
        NSTabViewItem page = this.tabView.selectedTabViewItem();
        if (page == null) {
            page = this.tabView.tabViewItemAtIndex(0);
        }
        this.toolbar.setSelectedItemIdentifier(page.identifier());
    }

    protected String getSelectedTab() {
        return this.toolbar.selectedItemIdentifier();
    }

    @Override
    protected void invalidate() {
        this.toolbar.setDelegate(null);
        this.tabView.setDelegate(null);
        super.invalidate();
    }

    @Override
    public void setWindow(NSWindow window) {
        this.windowTitle = window.title();
        window.setDelegate(this.id());
        window.setShowsToolbarButton(false);
        super.setWindow(window);
    }

    protected NSUInteger getToolbarSize() {
        return NSToolbar.NSToolbarSizeModeRegular;
    }

    protected NSUInteger getToolbarMode() {
        return NSToolbar.NSToolbarDisplayModeIconAndLabel;
    }

    public void setTabView(NSTabView tabView) {
        this.tabView = tabView;
        this.tabView.setAutoresizingMask(new NSUInteger(18L));
        this.tabView.setDelegate(this.id());
    }

    private String getToolbarName() {
        return this.getBundleName().toLowerCase() + ".toolbar";
    }

    @Override
    public NSToolbarItem toolbar_itemForItemIdentifier_willBeInsertedIntoToolbar(NSToolbar toolbar, String itemIdentifier, boolean flag) {
        if (!this.cache.containsKey(itemIdentifier)) {
            this.cache.put(itemIdentifier, NSToolbarItem.itemWithIdentifier(itemIdentifier));
        }
        NSToolbarItem toolbarItem = this.cache.get(itemIdentifier);
        NSTabViewItem tab = this.tabView.tabViewItemAtIndex(this.tabView.indexOfTabViewItemWithIdentifier(itemIdentifier));
        if (null == tab) {
            log.warn((Object)("No tab for toolbar item " + itemIdentifier));
            return null;
        }
        toolbarItem.setLabel(tab.label());
        toolbarItem.setPaletteLabel(tab.label());
        toolbarItem.setToolTip(tab.label());
        toolbarItem.setImage(IconCache.iconNamed(itemIdentifier, 32));
        toolbarItem.setTarget(this.id());
        toolbarItem.setAction(Foundation.selector("select:"));
        return toolbarItem;
    }

    @Override
    public NSArray toolbarAllowedItemIdentifiers(NSToolbar toolbar) {
        List<String> identifiers = this.getPanelIdentifiers();
        return NSArray.arrayWithObjects(identifiers.toArray(new String[identifiers.size()]));
    }

    @Override
    public NSArray toolbarDefaultItemIdentifiers(NSToolbar toolbar) {
        return this.toolbarAllowedItemIdentifiers(toolbar);
    }

    @Override
    public NSArray toolbarSelectableItemIdentifiers(NSToolbar toolbar) {
        return this.toolbarAllowedItemIdentifiers(toolbar);
    }

    @Override
    public boolean validateToolbarItem(NSToolbarItem item) {
        return this.validateTabWithIdentifier(item.itemIdentifier());
    }

    protected boolean validateTabWithIdentifier(String itemIdentifier) {
        return true;
    }

    protected String getTitle(NSTabViewItem item) {
        return item.label();
    }

    public void select(NSToolbarItem sender) {
        this.setSelectedTab(this.tabView.indexOfTabViewItemWithIdentifier(sender.itemIdentifier()));
    }

    private void resize() {
        NSRect windowFrame = NSWindow.contentRectForFrameRect_styleMask(this.window().frame(), this.window().styleMask());
        double height = this.getMinWindowHeight();
        NSRect frameRect = new NSRect(new NSPoint(windowFrame.origin.x.doubleValue(), windowFrame.origin.y.doubleValue() + windowFrame.size.height.doubleValue() - height), new NSSize(windowFrame.size.width.doubleValue(), height));
        this.window().setFrame_display_animate(NSWindow.frameRectForContentRect_styleMask(frameRect, this.window().styleMask()), true, this.window().isVisible());
    }

    public NSSize windowWillResize_toSize(NSWindow window, NSSize newSize) {
        return new NSSize(newSize.width.doubleValue(), window.frame().size.height.doubleValue());
    }

    private double toolbarHeightForWindow(NSWindow window) {
        NSRect windowFrame = NSWindow.contentRectForFrameRect_styleMask(this.window().frame(), this.window().styleMask());
        return windowFrame.size.height.doubleValue() - this.window().contentView().frame().size.height.doubleValue();
    }

    @Override
    public void tabView_didSelectTabViewItem(NSTabView tabView, NSTabViewItem tabViewItem) {
        this.window.setTitle(this.windowTitle + " \u2013 " + this.getTitle(tabViewItem));
        this.resize();
        Preferences.instance().setProperty(this.getToolbarName() + ".selected", tabView.indexOfTabViewItem(tabViewItem));
    }

    protected double getMinWindowHeight() {
        NSRect contentRect = this.getContentRect();
        double height = contentRect.size.height.doubleValue() + 40.0 + this.toolbarHeightForWindow(this.window());
        return height;
    }

    protected double getMinWindowWidth() {
        NSRect contentRect = this.getContentRect();
        double width = contentRect.size.width.doubleValue();
        return width;
    }

    private NSRect getContentRect() {
        NSObject next;
        NSRect contentRect = new NSRect(0.0, 0.0);
        NSView view = this.tabView.selectedTabViewItem().view();
        NSEnumerator enumerator = view.subviews().objectEnumerator();
        while (null != (next = enumerator.nextObject())) {
            NSView subview = Rococoa.cast(next, NSView.class);
            contentRect = FoundationKitFunctionsLibrary.NSUnionRect(contentRect, subview.frame());
        }
        return contentRect;
    }
}

