/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.core.threading.BackgroundActionListener;
import ch.cyberduck.core.threading.DefaultMainAction;
import ch.cyberduck.core.threading.MainAction;
import ch.cyberduck.ui.cocoa.BundleController;
import ch.cyberduck.ui.cocoa.application.NSButton;
import ch.cyberduck.ui.cocoa.application.NSProgressIndicator;
import ch.cyberduck.ui.cocoa.application.NSTextField;
import ch.cyberduck.ui.cocoa.application.NSView;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.ID;

public class TaskController
extends BundleController {
    private static Logger log = Logger.getLogger(TaskController.class);
    private NSTextField name;
    private NSTextField text;
    private NSProgressIndicator progress;
    private NSButton stopButton;
    private NSView view;
    private BackgroundAction task;

    public void setName(NSTextField name) {
        this.name = name;
        this.name.setStringValue(this.task.toString());
    }

    public void setText(NSTextField text) {
        this.text = text;
        this.text.setStringValue(this.task.getActivity());
    }

    public void setProgress(NSProgressIndicator progress) {
        this.progress = progress;
        this.progress.setDisplayedWhenStopped(false);
        this.progress.setIndeterminate(true);
    }

    public void setStopButton(NSButton stopButton) {
        this.stopButton = stopButton;
        this.stopButton.setTarget(this.id());
        this.stopButton.setAction(Foundation.selector("stopButtonClicked:"));
    }

    public void stopButtonClicked(ID sender) {
        this.task.cancel();
    }

    public void setView(NSView view) {
        this.view = view;
    }

    public NSView view() {
        return this.view;
    }

    public TaskController(BackgroundAction task) {
        this.task = task;
        this.loadBundle();
        if (this.task.isRunning()) {
            this.progress.startAnimation(null);
        }
        this.task.addListener(new BackgroundActionListener(){

            public void start(BackgroundAction action) {
                TaskController.this.invoke((MainAction)new DefaultMainAction(){

                    public void run() {
                        TaskController.this.progress.startAnimation(null);
                    }
                });
            }

            public void cancel(BackgroundAction action) {
                TaskController.this.invoke((MainAction)new DefaultMainAction(){

                    public void run() {
                        TaskController.this.progress.stopAnimation(null);
                    }
                });
            }

            public void stop(BackgroundAction action) {
                TaskController.this.invoke((MainAction)new DefaultMainAction(){

                    public void run() {
                        TaskController.this.progress.stopAnimation(null);
                    }
                });
                action.removeListener((BackgroundActionListener)this);
            }
        });
    }

    protected String getBundleName() {
        return "Task";
    }
}

