/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFilter;
import ch.cyberduck.core.Status;
import ch.cyberduck.core.SyncTransfer;
import ch.cyberduck.core.Transfer;
import ch.cyberduck.ui.cocoa.IconCache;
import ch.cyberduck.ui.cocoa.TableCellAttributes;
import ch.cyberduck.ui.cocoa.TransferPromptController;
import ch.cyberduck.ui.cocoa.TransferPromptModel;
import ch.cyberduck.ui.cocoa.foundation.NSAttributedString;
import ch.cyberduck.ui.cocoa.foundation.NSObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncPromptModel
extends TransferPromptModel {
    private PathFilter<Path> filter;
    protected static final String SYNC_COLUMN = "SYNC";
    protected static final String CREATE_COLUMN = "CREATE";

    public SyncPromptModel(TransferPromptController c, Transfer transfer) {
        super(c, transfer);
    }

    @Override
    public void add(Path p) {
        for (Path child : this.transfer.children(p)) {
            super.add(child);
        }
    }

    @Override
    protected PathFilter<Path> filter() {
        if (null == this.filter) {
            this.filter = new TransferPromptModel.PromptFilter(){

                public boolean accept(Path child) {
                    TransferPromptModel.log.debug((Object)("accept:" + child));
                    return super.accept(child);
                }
            };
        }
        return this.filter;
    }

    @Override
    protected NSObject objectValueForItem(Path item, String identifier) {
        NSObject cached = this.tableViewCache.get(item, identifier);
        if (null == cached) {
            if (identifier.equals("SIZE")) {
                SyncTransfer.Comparison compare = ((SyncTransfer)this.transfer).compare(item);
                return this.tableViewCache.put(item, identifier, NSAttributedString.attributedStringWithAttributes(Status.getSizeAsString((double)(compare.equals((Object)SyncTransfer.COMPARISON_REMOTE_NEWER) ? (double)item.attributes().getSize() : (double)item.getLocal().attributes().getSize())), TableCellAttributes.browserFontRightAlignment()));
            }
            if (identifier.equals(SYNC_COLUMN)) {
                SyncTransfer.Comparison compare = ((SyncTransfer)this.transfer).compare(item);
                if (item.attributes().isDirectory() && item.exists() && item.getLocal().exists()) {
                    return null;
                }
                if (compare.equals((Object)SyncTransfer.COMPARISON_REMOTE_NEWER)) {
                    return this.tableViewCache.put(item, identifier, IconCache.iconNamed("arrowDown.tiff", 16));
                }
                if (compare.equals((Object)SyncTransfer.COMPARISON_LOCAL_NEWER)) {
                    return this.tableViewCache.put(item, identifier, IconCache.iconNamed("arrowUp.tiff", 16));
                }
                return null;
            }
            if (identifier.equals("WARNING")) {
                if (item.attributes().isFile()) {
                    if (item.exists() && item.attributes().getSize() == 0L) {
                        return this.tableViewCache.put(item, identifier, IconCache.iconNamed("alert.tiff"));
                    }
                    if (item.getLocal().exists() && item.getLocal().attributes().getSize() == 0L) {
                        return this.tableViewCache.put(item, identifier, IconCache.iconNamed("alert.tiff"));
                    }
                }
                return null;
            }
            if (identifier.equals(CREATE_COLUMN)) {
                if (!item.exists() || !item.getLocal().exists()) {
                    return this.tableViewCache.put(item, identifier, IconCache.iconNamed("plus.tiff", 16));
                }
                return null;
            }
            return super.objectValueForItem(item, identifier);
        }
        return cached;
    }
}

