/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.threading.ControllerMainAction;
import ch.cyberduck.core.threading.MainAction;
import ch.cyberduck.ui.cocoa.SheetCallback;
import ch.cyberduck.ui.cocoa.WindowController;
import ch.cyberduck.ui.cocoa.application.AppKitFunctionsLibrary;
import ch.cyberduck.ui.cocoa.application.NSApplication;
import ch.cyberduck.ui.cocoa.application.NSButton;
import ch.cyberduck.ui.cocoa.application.NSWindow;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.ID;

public abstract class SheetController
extends WindowController
implements SheetCallback {
    private static Logger log = Logger.getLogger(SheetController.class);
    protected final WindowController parent;
    private int returncode;
    protected static final Set<SheetController> sheetRegistry = new HashSet<SheetController>();

    public SheetController(WindowController parent) {
        this.parent = parent;
    }

    public SheetController(WindowController parent, NSWindow sheet) {
        this.parent = parent;
        this.window = sheet;
    }

    protected String getBundleName() {
        return null;
    }

    protected WindowController getParentController() {
        return this.parent;
    }

    protected int getCallbackOption(NSButton selected) {
        if (selected.tag() == 1) {
            return 1;
        }
        if (selected.tag() == 0) {
            return -1;
        }
        throw new RuntimeException("Unexpected tag:" + selected.tag());
    }

    public void closeSheet(NSButton sender) {
        log.debug((Object)("closeSheet:" + sender));
        if (!(this.getCallbackOption(sender) != 1 && this.getCallbackOption(sender) != 0 || this.validateInput())) {
            AppKitFunctionsLibrary.beep();
            return;
        }
        NSApplication.sharedApplication().endSheet(this.window(), this.getCallbackOption(sender));
    }

    public int returnCode() {
        return this.returncode;
    }

    protected boolean validateInput() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void callback(int returncode, ID context) {
        this.returncode = returncode;
        this.callback(returncode);
        NSWindow nSWindow = this.parent.window();
        synchronized (nSWindow) {
            this.parent.window().notify();
        }
        if (!this.isSingleton()) {
            this.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginSheet() {
        WindowController windowController = this.parent;
        synchronized (windowController) {
            if (this.isMainThread()) {
                this.beginSheetImpl();
                return;
            }
            this.invoke((MainAction)new ControllerMainAction(this){

                public void run() {
                    SheetController.this.beginSheetImpl();
                }
            }, true);
            NSWindow nSWindow = this.parent.window();
            synchronized (nSWindow) {
                while (this.parent.hasSheet()) {
                    try {
                        log.debug((Object)"Sleeping:waitForSheetDismiss...");
                        this.parent.window().wait();
                        log.debug((Object)"Awakened:waitForSheetDismiss");
                    }
                    catch (InterruptedException e) {
                        log.error((Object)e.getMessage());
                    }
                }
            }
        }
    }

    protected void beginSheetImpl() {
        this.loadBundle();
        this.parent.window().makeKeyAndOrderFront(null);
        NSApplication.sharedApplication().beginSheet(this.window(), this.parent.window(), this.id(), Foundation.selector("sheetDidClose:returnCode:contextInfo:"), null);
        sheetRegistry.add(this);
    }

    public void sheetDidClose_returnCode_contextInfo(NSWindow sheet, int returncode, ID contextInfo) {
        sheet.orderOut(null);
        this.callback(returncode, contextInfo);
        sheetRegistry.remove(this);
    }

    public boolean isSingleton() {
        return false;
    }
}

