/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.threading.MainAction;
import ch.cyberduck.ui.AbstractController;
import ch.cyberduck.ui.ActionOperationBatcher;
import ch.cyberduck.ui.cocoa.foundation.NSNotificationCenter;
import ch.cyberduck.ui.cocoa.foundation.NSObject;
import ch.cyberduck.ui.cocoa.foundation.NSThread;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.ID;
import org.rococoa.Rococoa;
import org.rococoa.internal.AutoreleaseBatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyController
extends AbstractController {
    private static Logger log = Logger.getLogger(ProxyController.class);
    private NSObject proxy;
    private ID id;

    public NSObject proxy() {
        return this.proxy(NSObject.class);
    }

    protected NSObject proxy(Class<? extends NSObject> type) {
        if (null == this.proxy) {
            this.proxy = Rococoa.proxy((Object)this, type);
        }
        return this.proxy;
    }

    public ID id() {
        return this.id(NSObject.class);
    }

    protected ID id(Class<? extends NSObject> type) {
        if (null == this.id) {
            this.id = this.proxy(type).id();
        }
        return this.id;
    }

    protected void invalidate() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("invalidate:" + ((Object)((Object)this)).toString()));
        }
        if (this.id != null) {
            NSNotificationCenter.defaultCenter().removeObserver(this.id);
        }
    }

    protected void finalize() throws Throwable {
        if (log.isTraceEnabled()) {
            log.trace((Object)("finalize:" + ((Object)((Object)this)).toString()));
        }
        super.finalize();
    }

    protected ActionOperationBatcher getBatcher(int size) {
        final AutoreleaseBatcher impl = AutoreleaseBatcher.forThread(size);
        return new ActionOperationBatcher(){

            public void operate() {
                impl.operate();
            }
        };
    }

    public void invoke(MainAction runnable, boolean wait) {
        if (!runnable.isValid()) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("invoke:" + runnable));
        }
        if (this.isMainThread()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Already on main thread. Invoke " + runnable + " directly."));
            }
            runnable.run();
            return;
        }
        try {
            Foundation.runOnMainThread((Runnable)runnable, wait);
        }
        catch (Throwable e) {
            log.error((Object)("Exception running task on main thread:" + e.getMessage()), e);
        }
    }

    public boolean isMainThread() {
        return NSThread.isMainThread();
    }
}

