/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.AbstractLoginController;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Factory;
import ch.cyberduck.core.KeychainFactory;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.LoginCanceledException;
import ch.cyberduck.core.LoginController;
import ch.cyberduck.core.LoginControllerFactory;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.ui.Controller;
import ch.cyberduck.ui.cocoa.BrowserController;
import ch.cyberduck.ui.cocoa.IconCache;
import ch.cyberduck.ui.cocoa.MainController;
import ch.cyberduck.ui.cocoa.SheetController;
import ch.cyberduck.ui.cocoa.TransferController;
import ch.cyberduck.ui.cocoa.WindowController;
import ch.cyberduck.ui.cocoa.application.NSAlert;
import ch.cyberduck.ui.cocoa.application.NSButton;
import ch.cyberduck.ui.cocoa.application.NSColor;
import ch.cyberduck.ui.cocoa.application.NSImageView;
import ch.cyberduck.ui.cocoa.application.NSOpenPanel;
import ch.cyberduck.ui.cocoa.application.NSSecureTextField;
import ch.cyberduck.ui.cocoa.application.NSTextField;
import ch.cyberduck.ui.cocoa.foundation.NSArray;
import ch.cyberduck.ui.cocoa.foundation.NSEnumerator;
import ch.cyberduck.ui.cocoa.foundation.NSNotification;
import ch.cyberduck.ui.cocoa.foundation.NSNotificationCenter;
import ch.cyberduck.ui.cocoa.foundation.NSObject;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.ID;

public class PromptLoginController
extends AbstractLoginController {
    private static Logger log = Logger.getLogger(PromptLoginController.class);
    private WindowController parent;

    public static void register() {
        LoginControllerFactory.addFactory((Factory.Platform)Factory.NATIVE_PLATFORM, (LoginControllerFactory)new Factory());
    }

    private PromptLoginController(WindowController parent) {
        this.parent = parent;
    }

    public void warn(String title, String message, String continueButton, String disconnectButton, String preference) throws LoginCanceledException {
        NSAlert alert = NSAlert.alert(title, message, continueButton, null, disconnectButton);
        alert.setShowsHelp(true);
        alert.setShowsSuppressionButton(true);
        alert.suppressionButton().setTitle(Locale.localizedString((String)"Don't show again", (String)"Credentials"));
        alert.setAlertStyle(0);
        StringBuilder site = new StringBuilder(Preferences.instance().getProperty("website.help"));
        site.append("/").append(Protocol.FTP.getIdentifier());
        int option = this.parent.alert(alert, site.toString());
        if (alert.suppressionButton().state() == 1) {
            Preferences.instance().setProperty(preference, true);
        }
        switch (option) {
            case -1: {
                throw new LoginCanceledException();
            }
        }
    }

    public void prompt(final Protocol protocol, final Credentials credentials, final String title, final String reason, final boolean enableKeychain, final boolean enablePublicKey, final boolean enableAnonymous) throws LoginCanceledException {
        SheetController c = new SheetController(this.parent){
            protected NSImageView iconView;
            private NSTextField usernameLabel;
            private NSTextField passwordLabel;
            private NSTextField titleField;
            private NSTextField usernameField;
            private NSTextField textField;
            private NSSecureTextField passwordField;
            private NSButton keychainCheckbox;
            private NSButton anonymousCheckbox;
            private NSTextField pkLabel;
            private NSButton pkCheckbox;
            private NSOpenPanel publicKeyPanel;

            protected String getBundleName() {
                return "Login";
            }

            public void awakeFromNib() {
                this.update();
                super.awakeFromNib();
            }

            public void helpButtonClicked(NSButton sender) {
                StringBuilder site = new StringBuilder(Preferences.instance().getProperty("website.help"));
                site.append("/").append(protocol.getIdentifier());
                1.openUrl(site.toString());
            }

            public void setIconView(NSImageView iconView) {
                this.iconView = iconView;
                this.iconView.setImage(IconCache.iconNamed(protocol.disk()));
            }

            public void setUsernameLabel(NSTextField usernameLabel) {
                this.usernameLabel = usernameLabel;
            }

            public void setPasswordLabel(NSTextField passwordLabel) {
                this.passwordLabel = passwordLabel;
            }

            public void setTitleField(NSTextField titleField) {
                this.titleField = titleField;
                this.updateField(this.titleField, Locale.localizedString((String)title, (String)"Credentials"));
            }

            public void setUsernameField(NSTextField usernameField) {
                this.usernameField = usernameField;
                this.updateField(this.usernameField, credentials.getUsername());
                this.usernameField.cell().setPlaceholderString(credentials.getUsernamePlaceholder());
                NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("userFieldTextDidChange:"), "NSControlTextDidChangeNotification", this.usernameField);
            }

            public void userFieldTextDidChange(NSNotification notification) {
                String password;
                credentials.setUsername(this.usernameField.stringValue());
                if (StringUtils.isNotBlank((String)credentials.getUsername()) && StringUtils.isNotBlank((String)(password = KeychainFactory.instance().getPassword(protocol.getScheme(), protocol.getDefaultPort(), protocol.getDefaultHostname(), credentials.getUsername())))) {
                    this.passwordField.setStringValue(password);
                    this.passFieldTextDidChange(notification);
                }
                this.update();
            }

            public void setTextField(NSTextField textField) {
                this.textField = textField;
                this.updateField(this.textField, Locale.localizedString((String)reason, (String)"Credentials"));
            }

            public void setPasswordField(NSSecureTextField passwordField) {
                this.passwordField = passwordField;
                this.updateField(this.passwordField, credentials.getPassword());
                this.passwordField.cell().setPlaceholderString(credentials.getPasswordPlaceholder());
                NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("passFieldTextDidChange:"), "NSControlTextDidChangeNotification", this.passwordField);
            }

            public void passFieldTextDidChange(NSNotification notification) {
                credentials.setPassword(this.passwordField.stringValue());
            }

            public void setKeychainCheckbox(NSButton keychainCheckbox) {
                this.keychainCheckbox = keychainCheckbox;
                this.keychainCheckbox.setTarget(this.id());
                this.keychainCheckbox.setAction(Foundation.selector("keychainCheckboxClicked:"));
                this.keychainCheckbox.setState(Preferences.instance().getBoolean("connection.login.useKeychain") && Preferences.instance().getBoolean("connection.login.addKeychain") ? 1 : 0);
            }

            public void keychainCheckboxClicked(NSButton sender) {
                boolean enabled = sender.state() == 1;
                Preferences.instance().setProperty("connection.login.addKeychain", enabled);
            }

            public void setAnonymousCheckbox(NSButton anonymousCheckbox) {
                this.anonymousCheckbox = anonymousCheckbox;
                this.anonymousCheckbox.setTarget(this.id());
                this.anonymousCheckbox.setAction(Foundation.selector("anonymousCheckboxClicked:"));
            }

            public void anonymousCheckboxClicked(NSButton sender) {
                if (sender.state() == 1) {
                    credentials.setUsername(Preferences.instance().getProperty("connection.login.anon.name"));
                    credentials.setPassword(Preferences.instance().getProperty("connection.login.anon.pass"));
                }
                if (sender.state() == 0) {
                    credentials.setUsername(Preferences.instance().getProperty("connection.login.name"));
                    credentials.setPassword(null);
                }
                this.updateField(this.usernameField, credentials.getUsername());
                this.updateField(this.passwordField, credentials.getPassword());
                this.update();
            }

            public void setPkLabel(NSTextField pkLabel) {
                this.pkLabel = pkLabel;
            }

            public void setPkCheckbox(NSButton pkCheckbox) {
                this.pkCheckbox = pkCheckbox;
                this.pkCheckbox.setTarget(this.id());
                this.pkCheckbox.setAction(Foundation.selector("pkCheckboxSelectionChanged:"));
            }

            public void pkCheckboxSelectionChanged(NSButton sender) {
                if (sender.state() == 1) {
                    this.publicKeyPanel = NSOpenPanel.openPanel();
                    this.publicKeyPanel.setCanChooseDirectories(false);
                    this.publicKeyPanel.setCanChooseFiles(true);
                    this.publicKeyPanel.setAllowsMultipleSelection(false);
                    this.publicKeyPanel.setMessage(Locale.localizedString((String)"Select the private key in PEM or PuTTY format", (String)"Credentials"));
                    this.publicKeyPanel.setPrompt(Locale.localizedString((String)"Choose"));
                    this.publicKeyPanel.beginSheetForDirectory(LocalFactory.createLocal((String)"~/.ssh").getAbsolute(), null, this.window(), this.id(), Foundation.selector("pkSelectionPanelDidEnd:returnCode:contextInfo:"), null);
                } else {
                    this.pkSelectionPanelDidEnd_returnCode_contextInfo(this.publicKeyPanel, 0, null);
                }
            }

            public void pkSelectionPanelDidEnd_returnCode_contextInfo(NSOpenPanel sheet, int returncode, ID contextInfo) {
                if (returncode == 1) {
                    NSObject next;
                    NSArray selected = sheet.filenames();
                    NSEnumerator enumerator = selected.objectEnumerator();
                    while ((next = enumerator.nextObject()) != null) {
                        credentials.setIdentity(LocalFactory.createLocal((String)next.toString()));
                    }
                }
                if (returncode == 0) {
                    credentials.setIdentity(null);
                }
                this.update();
            }

            private void update() {
                this.usernameField.setEnabled(!credentials.isAnonymousLogin());
                this.passwordField.setEnabled(!credentials.isAnonymousLogin());
                boolean enable = enableKeychain && !credentials.isAnonymousLogin();
                this.keychainCheckbox.setEnabled(enable);
                if (!enable) {
                    this.keychainCheckbox.setState(0);
                }
                this.anonymousCheckbox.setEnabled(enableAnonymous);
                if (enableAnonymous && credentials.isAnonymousLogin()) {
                    this.anonymousCheckbox.setState(1);
                } else {
                    this.anonymousCheckbox.setState(0);
                }
                this.pkCheckbox.setEnabled(enablePublicKey);
                if (enablePublicKey && credentials.isPublicKeyAuthentication()) {
                    this.pkCheckbox.setState(1);
                    this.updateField(this.pkLabel, credentials.getIdentity().getAbbreviatedPath());
                    this.pkLabel.setTextColor(NSColor.textColor());
                } else {
                    this.pkCheckbox.setState(0);
                    this.pkLabel.setStringValue(Locale.localizedString((String)"No private key selected"));
                    this.pkLabel.setTextColor(NSColor.disabledControlTextColor());
                }
            }

            protected boolean validateInput() {
                return credentials.validate(protocol);
            }

            public void callback(int returncode) {
                if (returncode == 1) {
                    this.window().endEditingFor(null);
                    credentials.setUseKeychain(this.keychainCheckbox.state() == 1);
                    credentials.setUsername(this.usernameField.stringValue());
                    credentials.setPassword(this.passwordField.stringValue());
                }
            }
        };
        c.beginSheet();
        if (c.returnCode() == -1) {
            throw new LoginCanceledException();
        }
    }

    private static class Factory
    extends LoginControllerFactory {
        private Factory() {
        }

        protected LoginController create() {
            return new PromptLoginController(TransferController.instance());
        }

        protected LoginController create(Controller c) {
            return new PromptLoginController((WindowController)c);
        }

        protected LoginController create(Session s) {
            for (BrowserController c : MainController.getBrowsers()) {
                if (c.getSession() != s) continue;
                return this.create((Controller)c);
            }
            return this.create();
        }
    }
}

