/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Acl;
import ch.cyberduck.core.ConnectionAdapter;
import ch.cyberduck.core.ConnectionListener;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.Status;
import ch.cyberduck.core.cdn.Distribution;
import ch.cyberduck.core.cloud.CloudSession;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.s3.S3Path;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.core.threading.MainAction;
import ch.cyberduck.ui.DateFormatterFactory;
import ch.cyberduck.ui.action.CalculateSizeWorker;
import ch.cyberduck.ui.action.ChecksumWorker;
import ch.cyberduck.ui.action.ReadAclWorker;
import ch.cyberduck.ui.action.ReadMetadataWorker;
import ch.cyberduck.ui.action.ReadPermissionWorker;
import ch.cyberduck.ui.action.ReadSizeWorker;
import ch.cyberduck.ui.action.WriteAclWorker;
import ch.cyberduck.ui.action.WriteMetadataWorker;
import ch.cyberduck.ui.action.WritePermissionWorker;
import ch.cyberduck.ui.cocoa.AbstractTableDelegate;
import ch.cyberduck.ui.cocoa.BrowserController;
import ch.cyberduck.ui.cocoa.BundleController;
import ch.cyberduck.ui.cocoa.IconCache;
import ch.cyberduck.ui.cocoa.ListDataSource;
import ch.cyberduck.ui.cocoa.ToolbarWindowController;
import ch.cyberduck.ui.cocoa.WindowListener;
import ch.cyberduck.ui.cocoa.application.AppKitFunctionsLibrary;
import ch.cyberduck.ui.cocoa.application.NSButton;
import ch.cyberduck.ui.cocoa.application.NSCell;
import ch.cyberduck.ui.cocoa.application.NSColor;
import ch.cyberduck.ui.cocoa.application.NSComboBoxCell;
import ch.cyberduck.ui.cocoa.application.NSFont;
import ch.cyberduck.ui.cocoa.application.NSImageView;
import ch.cyberduck.ui.cocoa.application.NSMenuItem;
import ch.cyberduck.ui.cocoa.application.NSPopUpButton;
import ch.cyberduck.ui.cocoa.application.NSProgressIndicator;
import ch.cyberduck.ui.cocoa.application.NSTabViewItem;
import ch.cyberduck.ui.cocoa.application.NSTableColumn;
import ch.cyberduck.ui.cocoa.application.NSTableView;
import ch.cyberduck.ui.cocoa.application.NSTextField;
import ch.cyberduck.ui.cocoa.application.NSTextFieldCell;
import ch.cyberduck.ui.cocoa.application.NSToolbar;
import ch.cyberduck.ui.cocoa.application.NSToolbarItem;
import ch.cyberduck.ui.cocoa.application.NSView;
import ch.cyberduck.ui.cocoa.application.NSWindow;
import ch.cyberduck.ui.cocoa.foundation.NSAttributedString;
import ch.cyberduck.ui.cocoa.foundation.NSIndexSet;
import ch.cyberduck.ui.cocoa.foundation.NSMutableAttributedString;
import ch.cyberduck.ui.cocoa.foundation.NSNotification;
import ch.cyberduck.ui.cocoa.foundation.NSNotificationCenter;
import ch.cyberduck.ui.cocoa.foundation.NSObject;
import ch.cyberduck.ui.cocoa.foundation.NSString;
import ch.cyberduck.ui.cocoa.threading.BrowserBackgroundAction;
import ch.cyberduck.ui.cocoa.threading.WindowMainAction;
import ch.cyberduck.ui.cocoa.threading.WorkerBackgroundAction;
import ch.cyberduck.ui.cocoa.util.HyperlinkAttributedStringFactory;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.ID;
import org.rococoa.Selector;
import org.rococoa.cocoa.foundation.NSInteger;
import org.rococoa.cocoa.foundation.NSPoint;
import org.rococoa.cocoa.foundation.NSUInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InfoController
extends ToolbarWindowController {
    private static Logger log = Logger.getLogger(InfoController.class);
    private List<Path> files = Collections.emptyList();
    private NSTextField filenameField;
    private NSTextField groupField;
    private NSTextField kindField;
    private NSTextField modifiedField;
    private NSTextField createdField;
    private NSTextField permissionsField;
    private NSTextField octalField;
    private NSTextField ownerField;
    private NSTextField sizeField;
    private NSTextField checksumField;
    private NSTextField pathField;
    private NSTextField webUrlField;
    private NSButton recursiveButton;
    private NSButton sizeButton;
    private NSProgressIndicator sizeProgress;
    private NSProgressIndicator permissionProgress;
    private NSProgressIndicator s3Progress;
    private NSProgressIndicator aclProgress;
    private NSProgressIndicator metadataProgress;
    private NSProgressIndicator distributionProgress;
    private NSButton distributionEnableButton;
    private NSButton distributionLoggingButton;
    private NSButton distributionInvalidateObjectsButton;
    private NSTextField distributionInvalidationStatusField;
    private NSPopUpButton distributionDeliveryPopup;
    private NSPopUpButton distributionDefaultRootPopup;
    private NSTextField bucketLocationField;
    private NSPopUpButton storageClassPopup;
    private NSButton bucketLoggingButton;
    private NSButton bucketVersioningButton;
    private NSButton bucketMfaButton;
    private NSTextField s3PublicUrlField;
    private NSTextField s3PublicUrlValidityField;
    private NSTextField s3torrentUrlField;
    private NSTextField distributionCnameField;
    private NSTextField distributionOriginField;
    private NSTextField distributionStatusField;
    private NSTextField distributionUrlField;
    private NSTextField distributionCnameUrlField;
    private NSTextField aclUrlField;
    private List<Acl.UserAndRole> acl = new ArrayList<Acl.UserAndRole>();
    private NSTableView aclTable;
    private ListDataSource aclTableModel;
    private AbstractTableDelegate<Acl.UserAndRole> aclTableDelegate;
    public static final String HEADER_ACL_GRANTEE_COLUMN = "GRANTEE";
    public static final String HEADER_ACL_PERMISSION_COLUMN = "PERMISSION";
    private final NSComboBoxCell aclPermissionCellPrototype = NSComboBoxCell.comboBoxCell();
    private NSPopUpButton aclAddButton;
    private NSButton aclRemoveButton;
    private NSTableView metadataTable;
    private ListDataSource metadataTableModel;
    private AbstractTableDelegate<String> metadataTableDelegate;
    public static final String HEADER_METADATA_NAME_COLUMN = "NAME";
    public static final String HEADER_METADATA_VALUE_COLUMN = "VALUE";
    private List<Header> metadata = new ArrayList<Header>();
    private NSPopUpButton metadataAddButton;
    private SimpleDateFormat rfc1123 = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", java.util.Locale.ENGLISH);
    private NSButton metadataRemoveButton;
    public NSButton ownerr;
    public NSButton ownerw;
    public NSButton ownerx;
    public NSButton groupr;
    public NSButton groupw;
    public NSButton groupx;
    public NSButton otherr;
    public NSButton otherw;
    public NSButton otherx;
    private NSImageView iconImageView;
    private String title;
    private BrowserController controller;
    private final WindowListener browserWindowListener;
    private static final String TOOLBAR_ITEM_GENERAL = "info";
    private static final String TOOLBAR_ITEM_PERMISSIONS = "permissions";
    private static final String TOOLBAR_ITEM_ACL = "acl";
    private static final String TOOLBAR_ITEM_DISTRIBUTION = "distribution";
    private static final String TOOLBAR_ITEM_S3 = "s3";
    private static final String TOOLBAR_ITEM_METADATA = "metadata";
    private NSView panelMetadata;
    private NSView panelCloud;
    private NSView panelDistribution;
    private NSView panelPermissions;
    private NSView panelAcl;
    private NSView panelGeneral;
    private static NSPoint cascadedWindowPoint;

    private Path getSelected() {
        Iterator<Path> i$ = this.files.iterator();
        if (i$.hasNext()) {
            Path file = i$.next();
            return file;
        }
        return null;
    }

    public void setFilenameField(NSTextField filenameField) {
        this.filenameField = filenameField;
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("filenameInputDidEndEditing:"), "NSControlTextDidEndEditingNotification", filenameField);
    }

    public void setGroupField(NSTextField t) {
        this.groupField = t;
    }

    public void setKindField(NSTextField t) {
        this.kindField = t;
    }

    public void setModifiedField(NSTextField t) {
        this.modifiedField = t;
    }

    public void setCreatedField(NSTextField t) {
        this.createdField = t;
    }

    public void setPermissionsField(NSTextField permissionsField) {
        this.permissionsField = permissionsField;
    }

    public void setOctalField(NSTextField octalField) {
        this.octalField = octalField;
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("octalPermissionsInputDidEndEditing:"), "NSControlTextDidEndEditingNotification", octalField);
    }

    public void setOwnerField(NSTextField ownerField) {
        this.ownerField = ownerField;
    }

    public void setSizeField(NSTextField sizeField) {
        this.sizeField = sizeField;
    }

    public void setChecksumField(NSTextField checksumField) {
        this.checksumField = checksumField;
    }

    public void setPathField(NSTextField pathField) {
        this.pathField = pathField;
    }

    public void setWebUrlField(NSTextField webUrlField) {
        this.webUrlField = webUrlField;
        this.webUrlField.setAllowsEditingTextAttributes(true);
        this.webUrlField.setSelectable(true);
    }

    public void setRecursiveButton(NSButton b) {
        this.recursiveButton = b;
        this.recursiveButton.setTarget(this.id());
        this.recursiveButton.setAction(Foundation.selector("recursiveButtonClicked:"));
    }

    public void setSizeButton(NSButton b) {
        this.sizeButton = b;
        this.sizeButton.setTarget(this.id());
        this.sizeButton.setAction(Foundation.selector("calculateSizeButtonClicked:"));
    }

    public void setSizeProgress(NSProgressIndicator p) {
        this.sizeProgress = p;
        this.sizeProgress.setDisplayedWhenStopped(false);
        this.sizeProgress.setStyle(1);
    }

    public void setPermissionProgress(NSProgressIndicator p) {
        this.permissionProgress = p;
        this.permissionProgress.setDisplayedWhenStopped(false);
        this.permissionProgress.setStyle(1);
    }

    public void setS3Progress(NSProgressIndicator p) {
        this.s3Progress = p;
        this.s3Progress.setDisplayedWhenStopped(false);
        this.s3Progress.setStyle(1);
    }

    public void setAclProgress(NSProgressIndicator p) {
        this.aclProgress = p;
        this.aclProgress.setDisplayedWhenStopped(false);
        this.aclProgress.setStyle(1);
    }

    public void setMetadataProgress(NSProgressIndicator p) {
        this.metadataProgress = p;
        this.metadataProgress.setDisplayedWhenStopped(false);
        this.metadataProgress.setStyle(1);
    }

    public void setDistributionProgress(NSProgressIndicator p) {
        this.distributionProgress = p;
        this.distributionProgress.setDisplayedWhenStopped(false);
        this.distributionProgress.setStyle(1);
    }

    public void setDistributionEnableButton(NSButton b) {
        this.distributionEnableButton = b;
        this.distributionEnableButton.setTarget(this.id());
        this.distributionEnableButton.setAction(Foundation.selector("distributionApplyButtonClicked:"));
    }

    public void setDistributionLoggingButton(NSButton b) {
        this.distributionLoggingButton = b;
        this.distributionLoggingButton.setTarget(this.id());
        this.distributionLoggingButton.setAction(Foundation.selector("distributionApplyButtonClicked:"));
    }

    public void setDistributionInvalidateObjectsButton(NSButton b) {
        this.distributionInvalidateObjectsButton = b;
        this.distributionInvalidateObjectsButton.setTarget(this.id());
        this.distributionInvalidateObjectsButton.setAction(Foundation.selector("distributionInvalidateObjectsButtonClicked:"));
    }

    public void setDistributionInvalidationStatusField(NSTextField t) {
        this.distributionInvalidationStatusField = t;
    }

    public void setDistributionDeliveryPopup(NSPopUpButton b) {
        this.distributionDeliveryPopup = b;
        this.distributionDeliveryPopup.setTarget(this.id());
        this.distributionDeliveryPopup.setAction(Foundation.selector("distributionStatusButtonClicked:"));
    }

    public void setDistributionDefaultRootPopup(NSPopUpButton b) {
        this.distributionDefaultRootPopup = b;
        this.distributionDefaultRootPopup.setTarget(this.id());
        this.distributionDefaultRootPopup.setAction(Foundation.selector("distributionApplyButtonClicked:"));
    }

    public void setBucketLocationField(NSTextField t) {
        this.bucketLocationField = t;
    }

    public void setStorageClassPopup(NSPopUpButton b) {
        this.storageClassPopup = b;
        this.storageClassPopup.setAutoenablesItems(false);
        this.storageClassPopup.removeAllItems();
        this.storageClassPopup.setTarget(this.id());
        this.storageClassPopup.setAction(Foundation.selector("storageClassPopupClicked:"));
    }

    public void storageClassPopupClicked(final NSPopUpButton sender) {
        if (this.toggleS3Settings(false)) {
            this.controller.background((BackgroundAction)new BrowserBackgroundAction(this.controller){

                public void run() {
                    for (Path next : InfoController.this.files) {
                        next.attributes().setStorageClass(sender.selectedItem().representedObject());
                        next.copy((AbstractPath)next);
                    }
                }

                public void cleanup() {
                    InfoController.this.toggleS3Settings(true);
                    InfoController.this.initS3();
                }

                public String getActivity() {
                    return MessageFormat.format(Locale.localizedString((String)"Writing metadata of {0}", (String)"Status"), this.toString(InfoController.this.files));
                }
            });
        }
    }

    public void setBucketLoggingButton(NSButton b) {
        this.bucketLoggingButton = b;
        this.bucketLoggingButton.setAction(Foundation.selector("bucketLoggingButtonClicked:"));
    }

    public void bucketLoggingButtonClicked(NSButton sender) {
        if (this.toggleS3Settings(false)) {
            this.controller.background((BackgroundAction)new BrowserBackgroundAction(this.controller){

                public void run() {
                    String container = InfoController.this.getSelected().getContainerName();
                    ((S3Session)InfoController.this.controller.getSession()).setLogging(container, InfoController.this.bucketLoggingButton.state() == 1);
                }

                public void cleanup() {
                    InfoController.this.toggleS3Settings(true);
                    InfoController.this.initS3();
                }

                public String getActivity() {
                    return MessageFormat.format(Locale.localizedString((String)"Writing metadata of {0}", (String)"Status"), this.toString(InfoController.this.files));
                }
            });
        }
    }

    public void setBucketVersioningButton(NSButton b) {
        this.bucketVersioningButton = b;
        this.bucketVersioningButton.setAction(Foundation.selector("bucketVersioningButtonClicked:"));
    }

    public void bucketVersioningButtonClicked(NSButton sender) {
        if (this.toggleS3Settings(false)) {
            this.controller.background((BackgroundAction)new BrowserBackgroundAction(this.controller){

                public void run() {
                    String container = InfoController.this.getSelected().getContainerName();
                    ((S3Session)InfoController.this.controller.getSession()).setVersioning(container, InfoController.this.bucketMfaButton.state() == 1, InfoController.this.bucketVersioningButton.state() == 1);
                }

                public void cleanup() {
                    InfoController.this.toggleS3Settings(true);
                    InfoController.this.initS3();
                }
            });
        }
    }

    public void setBucketMfaButton(NSButton b) {
        this.bucketMfaButton = b;
        this.bucketMfaButton.setAction(Foundation.selector("bucketMfaButtonClicked:"));
    }

    public void bucketMfaButtonClicked(NSButton sender) {
        if (this.toggleS3Settings(false)) {
            this.controller.background((BackgroundAction)new BrowserBackgroundAction(this.controller){

                public void run() {
                    String container = InfoController.this.getSelected().getContainerName();
                    ((S3Session)InfoController.this.controller.getSession()).setVersioning(container, InfoController.this.bucketMfaButton.state() == 1, InfoController.this.bucketVersioningButton.state() == 1);
                }

                public void cleanup() {
                    InfoController.this.toggleS3Settings(true);
                    InfoController.this.initS3();
                }
            });
        }
    }

    public void setS3PublicUrlField(NSTextField t) {
        this.s3PublicUrlField = t;
        this.s3PublicUrlField.setAllowsEditingTextAttributes(true);
        this.s3PublicUrlField.setSelectable(true);
    }

    public void setS3PublicUrlValidityField(NSTextField s3PublicUrlValidityField) {
        this.s3PublicUrlValidityField = s3PublicUrlValidityField;
    }

    public void setS3torrentUrlField(NSTextField t) {
        this.s3torrentUrlField = t;
        this.s3torrentUrlField.setAllowsEditingTextAttributes(true);
        this.s3torrentUrlField.setSelectable(true);
    }

    public void setDistributionCnameField(NSTextField t) {
        this.distributionCnameField = t;
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector("distributionApplyButtonClicked:"), "NSControlTextDidEndEditingNotification", this.distributionCnameField);
    }

    public void setDistributionOriginField(NSTextField t) {
        this.distributionOriginField = t;
        this.distributionOriginField.setAllowsEditingTextAttributes(true);
        this.distributionOriginField.setSelectable(true);
    }

    public void setDistributionStatusField(NSTextField t) {
        this.distributionStatusField = t;
    }

    public void setDistributionUrlField(NSTextField t) {
        this.distributionUrlField = t;
        this.distributionUrlField.setAllowsEditingTextAttributes(true);
        this.distributionUrlField.setSelectable(true);
    }

    public void setDistributionCnameUrlField(NSTextField t) {
        this.distributionCnameUrlField = t;
        this.distributionCnameUrlField.setAllowsEditingTextAttributes(true);
        this.distributionCnameUrlField.setSelectable(true);
    }

    public void setAclUrlField(NSTextField t) {
        this.aclUrlField = t;
        this.aclUrlField.setAllowsEditingTextAttributes(true);
        this.aclUrlField.setSelectable(true);
    }

    private void setAcl(List<Acl.UserAndRole> acl) {
        this.acl.clear();
        this.acl.addAll(acl);
        this.aclTable.reloadData();
    }

    public void setAclTable(NSTableView t) {
        this.aclTable = t;
        this.aclTable.setAllowsMultipleSelection(true);
        this.aclPermissionCellPrototype.setFont(NSFont.systemFontOfSize(NSFont.smallSystemFontSize()));
        this.aclPermissionCellPrototype.setControlSize(1);
        this.aclPermissionCellPrototype.setCompletes(false);
        this.aclPermissionCellPrototype.setBordered(false);
        this.aclPermissionCellPrototype.setButtonBordered(false);
        this.aclTable.setColumnAutoresizingStyle(NSTableView.NSTableViewUniformColumnAutoresizingStyle);
        this.aclTable.tableColumnWithIdentifier(HEADER_ACL_PERMISSION_COLUMN).setDataCell(this.aclPermissionCellPrototype);
        this.aclTableModel = new ListDataSource(){

            public NSInteger numberOfRowsInTableView(NSTableView view) {
                return new NSInteger(InfoController.this.acl.size());
            }

            public NSObject tableView_objectValueForTableColumn_row(NSTableView view, NSTableColumn tableColumn, NSInteger row) {
                if (row.intValue() < InfoController.this.acl.size()) {
                    String identifier = tableColumn.identifier();
                    Acl.UserAndRole grant = (Acl.UserAndRole)InfoController.this.acl.get(row.intValue());
                    if (identifier.equals(InfoController.HEADER_ACL_GRANTEE_COLUMN)) {
                        return NSString.stringWithString(grant.getUser().getDisplayName());
                    }
                    if (identifier.equals(InfoController.HEADER_ACL_PERMISSION_COLUMN)) {
                        return NSString.stringWithString(grant.getRole().getName());
                    }
                }
                return null;
            }

            public void tableView_setObjectValue_forTableColumn_row(NSTableView view, NSObject value, NSTableColumn c, NSInteger row) {
                if (row.intValue() < InfoController.this.acl.size()) {
                    Acl.UserAndRole grant = (Acl.UserAndRole)InfoController.this.acl.get(row.intValue());
                    if (c.identifier().equals(InfoController.HEADER_ACL_GRANTEE_COLUMN)) {
                        grant.getUser().setIdentifier(value.toString());
                    }
                    if (c.identifier().equals(InfoController.HEADER_ACL_PERMISSION_COLUMN)) {
                        grant.getRole().setName(value.toString());
                    }
                    if (StringUtils.isNotBlank((String)grant.getUser().getIdentifier()) && StringUtils.isNotBlank((String)grant.getRole().getName())) {
                        InfoController.this.aclInputDidEndEditing();
                    }
                }
            }
        };
        this.aclTable.setDataSource(this.aclTableModel.id());
        this.aclTableDelegate = new AbstractTableDelegate<Acl.UserAndRole>(){

            @Override
            public boolean isColumnRowEditable(NSTableColumn column, int row) {
                if (column.identifier().equals(InfoController.HEADER_ACL_GRANTEE_COLUMN)) {
                    Acl.UserAndRole grant = (Acl.UserAndRole)InfoController.this.acl.get(row);
                    return grant.getUser().isEditable();
                }
                if (column.identifier().equals(InfoController.HEADER_ACL_PERMISSION_COLUMN)) {
                    Acl.UserAndRole grant = (Acl.UserAndRole)InfoController.this.acl.get(row);
                    return grant.getRole().isEditable();
                }
                return true;
            }

            @Override
            public void tableRowDoubleClicked(ID sender) {
                this.enterKeyPressed(sender);
            }

            @Override
            public void enterKeyPressed(ID sender) {
                InfoController.this.aclTable.editRow(InfoController.this.aclTable.columnWithIdentifier(InfoController.HEADER_ACL_GRANTEE_COLUMN), InfoController.this.aclTable.selectedRow(), true);
            }

            @Override
            public void deleteKeyPressed(ID sender) {
                InfoController.this.aclRemoveButtonClicked(sender);
            }

            public String tableView_toolTipForCell_rect_tableColumn_row_mouseLocation(NSTableView t, NSCell cell, ID rect, NSTableColumn c, NSInteger row, NSPoint mouseLocation) {
                return this.tooltip((Acl.UserAndRole)InfoController.this.acl.get(row.intValue()));
            }

            @Override
            public String tooltip(Acl.UserAndRole c) {
                return c.getUser().getIdentifier();
            }

            @Override
            public void tableColumnClicked(NSTableView view, NSTableColumn c) {
            }

            @Override
            public void selectionDidChange(NSNotification notification) {
                InfoController.this.aclRemoveButton.setEnabled(InfoController.this.aclTable.numberOfSelectedRows().intValue() > 0);
            }

            public void tableView_willDisplayCell_forTableColumn_row(NSTableView view, NSTextFieldCell cell, NSTableColumn c, NSInteger row) {
                if (c.identifier().equals(InfoController.HEADER_ACL_GRANTEE_COLUMN)) {
                    Acl.UserAndRole grant = (Acl.UserAndRole)InfoController.this.acl.get(row.intValue());
                    cell.setPlaceholderString(grant.getUser().getPlaceholder());
                    if (grant.getUser().isEditable()) {
                        cell.setTextColor(NSColor.controlTextColor());
                    } else {
                        cell.setTextColor(NSColor.disabledControlTextColor());
                    }
                }
            }

            @Override
            protected boolean isTypeSelectSupported() {
                return false;
            }
        };
        this.aclTable.setDelegate(this.aclTableDelegate.id());
        this.aclTable.sizeToFit();
    }

    public void setAclAddButton(NSPopUpButton b) {
        this.aclAddButton = b;
        this.aclAddButton.setTarget(this.id());
        this.aclAddButton.addItemWithTitle("");
        this.aclAddButton.lastItem().setImage(IconCache.iconNamed("gear.tiff"));
        for (Acl.User user : this.controller.getSession().getAvailableAclUsers()) {
            this.aclAddButton.addItemWithTitle(user.getPlaceholder());
            this.aclAddButton.lastItem().setAction(Foundation.selector("aclAddButtonClicked:"));
            this.aclAddButton.lastItem().setTarget(this.id());
            this.aclAddButton.lastItem().setRepresentedObject(user.getPlaceholder());
        }
    }

    public void aclAddButtonClicked(NSMenuItem sender) {
        for (Acl.User grantee : this.controller.getSession().getAvailableAclUsers()) {
            if (!sender.representedObject().equals(grantee.getPlaceholder())) continue;
            this.addAclItem(new Acl.UserAndRole(grantee, new Acl.Role("")));
        }
    }

    private void addAclItem(Acl.UserAndRole update) {
        ArrayList<Acl.UserAndRole> updated = new ArrayList<Acl.UserAndRole>(this.acl);
        int index = updated.size();
        updated.add(index, update);
        this.setAcl(updated);
        this.aclTable.selectRowIndexes(NSIndexSet.indexSetWithIndex(new NSInteger(index)), false);
        if (update.getUser().isEditable()) {
            this.aclTable.editRow(this.aclTable.columnWithIdentifier(HEADER_ACL_GRANTEE_COLUMN), new NSInteger(index), true);
        } else {
            this.aclTable.editRow(this.aclTable.columnWithIdentifier(HEADER_ACL_PERMISSION_COLUMN), new NSInteger(index), true);
        }
    }

    public void setAclRemoveButton(NSButton b) {
        this.aclRemoveButton = b;
        this.aclRemoveButton.setEnabled(false);
        this.aclRemoveButton.setAction(Foundation.selector("aclRemoveButtonClicked:"));
        this.aclRemoveButton.setTarget(this.id());
    }

    public void aclRemoveButtonClicked(ID sender) {
        ArrayList<Acl.UserAndRole> updated = new ArrayList<Acl.UserAndRole>(this.acl);
        NSIndexSet iterator = this.aclTable.selectedRowIndexes();
        ArrayList remove = new ArrayList();
        NSUInteger index = iterator.firstIndex();
        while (!index.equals((Object)NSIndexSet.NSNotFound)) {
            remove.add(updated.get(index.intValue()));
            index = iterator.indexGreaterThanIndex(index);
        }
        updated.removeAll(remove);
        this.setAcl(updated);
        this.aclInputDidEndEditing();
    }

    private void aclInputDidEndEditing() {
        if (this.toggleAclSettings(false)) {
            this.controller.background((BackgroundAction)new WorkerBackgroundAction(this.controller, new WriteAclWorker(this.files, new Acl(this.acl.toArray(new Acl.UserAndRole[this.acl.size()])), true){

                public void cleanup(Acl permission) {
                    InfoController.this.toggleAclSettings(true);
                    InfoController.this.initAcl();
                }
            }));
        }
    }

    private void setMetadata(List<Header> m) {
        this.metadata.clear();
        this.metadata.addAll(m);
        this.metadataTable.reloadData();
    }

    public void setMetadataTable(NSTableView t) {
        this.metadataTable = t;
        this.metadataTable.setAllowsMultipleSelection(true);
        this.metadataTable.setColumnAutoresizingStyle(NSTableView.NSTableViewUniformColumnAutoresizingStyle);
        this.metadataTableModel = new ListDataSource(){

            public NSInteger numberOfRowsInTableView(NSTableView view) {
                return new NSInteger(InfoController.this.metadata.size());
            }

            public NSObject tableView_objectValueForTableColumn_row(NSTableView view, NSTableColumn tableColumn, NSInteger row) {
                if (row.intValue() < InfoController.this.metadata.size()) {
                    String identifier = tableColumn.identifier();
                    if (identifier.equals(InfoController.HEADER_METADATA_NAME_COLUMN)) {
                        String name = ((Header)InfoController.this.metadata.get(row.intValue())).getName();
                        return NSAttributedString.attributedString(StringUtils.isNotEmpty((String)name) ? name : "");
                    }
                    if (identifier.equals(InfoController.HEADER_METADATA_VALUE_COLUMN)) {
                        String value = ((Header)InfoController.this.metadata.get(row.intValue())).getValue();
                        if (StringUtils.isEmpty((String)value)) {
                            return null;
                        }
                        return NSAttributedString.attributedString(StringUtils.isNotEmpty((String)value) ? value : "");
                    }
                }
                return null;
            }

            public void tableView_setObjectValue_forTableColumn_row(NSTableView view, NSObject value, NSTableColumn c, NSInteger row) {
                if (row.intValue() < InfoController.this.metadata.size()) {
                    Header header = (Header)InfoController.this.metadata.get(row.intValue());
                    if (c.identifier().equals(InfoController.HEADER_METADATA_NAME_COLUMN)) {
                        header.setName(value.toString());
                    }
                    if (c.identifier().equals(InfoController.HEADER_METADATA_VALUE_COLUMN)) {
                        header.setValue(value.toString());
                    }
                    if (StringUtils.isNotBlank((String)header.getName()) && StringUtils.isNotBlank((String)header.getValue())) {
                        InfoController.this.metadataInputDidEndEditing();
                    }
                }
            }
        };
        this.metadataTable.setDataSource(this.metadataTableModel.id());
        this.metadataTableDelegate = new AbstractTableDelegate<String>(){

            @Override
            public boolean isColumnRowEditable(NSTableColumn column, int row) {
                return true;
            }

            @Override
            public void tableRowDoubleClicked(ID sender) {
                this.enterKeyPressed(sender);
            }

            @Override
            public void enterKeyPressed(ID sender) {
                InfoController.this.metadataTable.editRow(InfoController.this.metadataTable.columnWithIdentifier(InfoController.HEADER_METADATA_VALUE_COLUMN), InfoController.this.metadataTable.selectedRow(), true);
            }

            @Override
            public void deleteKeyPressed(ID sender) {
                InfoController.this.metadataRemoveButtonClicked(sender);
            }

            @Override
            public String tooltip(String c) {
                return c;
            }

            @Override
            public void tableColumnClicked(NSTableView view, NSTableColumn c) {
            }

            @Override
            public void selectionDidChange(NSNotification notification) {
                InfoController.this.metadataRemoveButton.setEnabled(InfoController.this.metadataTable.numberOfSelectedRows().intValue() > 0);
            }

            @Override
            protected boolean isTypeSelectSupported() {
                return false;
            }

            public void tableView_willDisplayCell_forTableColumn_row(NSTableView view, NSTextFieldCell cell, NSTableColumn c, NSInteger row) {
                String value;
                if (c.identifier().equals(InfoController.HEADER_METADATA_VALUE_COLUMN) && null == (value = ((Header)InfoController.this.metadata.get(row.intValue())).getValue())) {
                    cell.setPlaceholderString(Locale.localizedString((String)"Multiple files"));
                }
            }
        };
        this.metadataTable.setDelegate(this.metadataTableDelegate.id());
        this.metadataTable.sizeToFit();
    }

    public void setMetadataAddButton(NSPopUpButton b) {
        this.metadataAddButton = b;
        this.metadataAddButton.setTarget(this.id());
        this.metadataAddButton.addItemWithTitle("");
        this.metadataAddButton.lastItem().setImage(IconCache.iconNamed("gear.tiff"));
        this.metadataAddButton.addItemWithTitle(Locale.localizedString((String)"Custom Header", (String)"S3"));
        this.metadataAddButton.lastItem().setAction(Foundation.selector("metadataAddCustomClicked:"));
        this.metadataAddButton.lastItem().setTarget(this.id());
        this.metadataAddButton.menu().addItem(NSMenuItem.separatorItem());
        this.metadataAddButton.addItemWithTitle("Cache-Control");
        this.metadataAddButton.lastItem().setAction(Foundation.selector("metadataAddCacheControlClicked:"));
        this.metadataAddButton.lastItem().setTarget(this.id());
        this.metadataAddButton.addItemWithTitle("Expires");
        this.metadataAddButton.lastItem().setAction(Foundation.selector("metadataAddExpiresClicked:"));
        this.metadataAddButton.lastItem().setTarget(this.id());
        this.metadataAddButton.addItemWithTitle("Pragma");
        this.metadataAddButton.lastItem().setAction(Foundation.selector("metadataAddPragmaClicked:"));
        this.metadataAddButton.lastItem().setTarget(this.id());
        this.metadataAddButton.addItemWithTitle("Content-Type");
        this.metadataAddButton.lastItem().setAction(Foundation.selector("metadataAddContentTypeClicked:"));
        this.metadataAddButton.lastItem().setTarget(this.id());
        this.metadataAddButton.addItemWithTitle("Content-Encoding");
        this.metadataAddButton.lastItem().setAction(Foundation.selector("metadataAddContentEncodingClicked:"));
        this.metadataAddButton.lastItem().setTarget(this.id());
    }

    public void metadataAddCustomClicked(ID sender) {
        this.addMetadataItem();
    }

    public void metadataAddCacheControlClicked(ID sender) {
        this.addMetadataItem("Cache-Control", "public,max-age=" + Preferences.instance().getInteger("s3.cache.seconds"));
    }

    public void metadataAddContentTypeClicked(ID sender) {
        this.addMetadataItem("Content-Type", "", true);
    }

    public void metadataAddContentEncodingClicked(ID sender) {
        this.addMetadataItem("Content-Encoding", "", true);
    }

    public void metadataAddExpiresClicked(ID sender) {
        Calendar time = Calendar.getInstance();
        time.add(13, Preferences.instance().getInteger("s3.cache.seconds"));
        this.addMetadataItem("Expires", this.rfc1123.format(time.getTime()));
    }

    public void metadataAddPragmaClicked(ID sender) {
        this.addMetadataItem("Pragma", "", true);
    }

    private void addMetadataItem() {
        this.addMetadataItem("");
    }

    private void addMetadataItem(String name) {
        this.addMetadataItem(name, "", false);
    }

    private void addMetadataItem(String name, String value) {
        this.addMetadataItem(name, value, true);
    }

    private void addMetadataItem(String name, String value, boolean selectValue) {
        log.debug((Object)("addMetadataItem:" + name));
        int row = this.metadata.size();
        ArrayList<Header> updated = new ArrayList<Header>(this.metadata);
        updated.add(row, new Header(name, value));
        this.setMetadata(updated);
        this.metadataTable.selectRowIndexes(NSIndexSet.indexSetWithIndex(new NSInteger(row)), false);
        this.metadataTable.editRow(selectValue ? this.metadataTable.columnWithIdentifier(HEADER_METADATA_VALUE_COLUMN) : this.metadataTable.columnWithIdentifier(HEADER_METADATA_NAME_COLUMN), new NSInteger(row), true);
    }

    public void setMetadataRemoveButton(NSButton b) {
        this.metadataRemoveButton = b;
        this.metadataRemoveButton.setEnabled(false);
        this.metadataRemoveButton.setAction(Foundation.selector("metadataRemoveButtonClicked:"));
        this.metadataRemoveButton.setTarget(this.id());
    }

    public void metadataRemoveButtonClicked(ID sender) {
        ArrayList<Header> updated = new ArrayList<Header>(this.metadata);
        NSIndexSet iterator = this.metadataTable.selectedRowIndexes();
        ArrayList remove = new ArrayList();
        NSUInteger index = iterator.firstIndex();
        while (!index.equals((Object)NSIndexSet.NSNotFound)) {
            remove.add(updated.get(index.intValue()));
            index = iterator.indexGreaterThanIndex(index);
        }
        updated.removeAll(remove);
        this.setMetadata(updated);
        this.metadataInputDidEndEditing();
    }

    private void metadataInputDidEndEditing() {
        if (this.toggleMetadataSettings(false)) {
            HashMap<String, String> update = new HashMap<String, String>();
            for (Header header : this.metadata) {
                update.put(header.getName(), header.getValue());
            }
            this.controller.background((BackgroundAction)new WorkerBackgroundAction(this.controller, new WriteMetadataWorker(this.files, update){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void cleanup(Map<String, String> metadata) {
                    try {
                        InfoController.this.initMetadata();
                        Object var3_2 = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        InfoController.this.toggleMetadataSettings(true);
                        throw throwable;
                    }
                    InfoController.this.toggleMetadataSettings(true);
                }
            }));
        }
    }

    public void setOwnerr(NSButton ownerr) {
        this.ownerr = ownerr;
    }

    public void setOwnerw(NSButton ownerw) {
        this.ownerw = ownerw;
    }

    public void setOwnerx(NSButton ownerx) {
        this.ownerx = ownerx;
    }

    public void setGroupr(NSButton groupr) {
        this.groupr = groupr;
    }

    public void setGroupw(NSButton groupw) {
        this.groupw = groupw;
    }

    public void setGroupx(NSButton groupx) {
        this.groupx = groupx;
    }

    public void setOtherr(NSButton otherr) {
        this.otherr = otherr;
    }

    public void setOtherw(NSButton otherw) {
        this.otherw = otherw;
    }

    public void setOtherx(NSButton otherx) {
        this.otherx = otherx;
    }

    public void setIconImageView(NSImageView iconImageView) {
        this.iconImageView = iconImageView;
    }

    @Override
    public void setWindow(NSWindow window) {
        this.title = window.title();
        window.setShowsResizeIndicator(true);
        super.setWindow(window);
    }

    @Override
    protected double getMaxWindowWidth() {
        return 600.0;
    }

    @Override
    public void windowWillClose(NSNotification notification) {
        this.window().endEditingFor(null);
        super.windowWillClose(notification);
    }

    @Override
    public boolean isSingleton() {
        return Preferences.instance().getBoolean("browser.info.isInspector");
    }

    private InfoController(BrowserController controller, List<Path> files) {
        this.rfc1123.setTimeZone(TimeZone.getDefault());
        this.browserWindowListener = new WindowListener(){

            public void windowWillClose() {
                NSWindow window = InfoController.this.window();
                if (null != window) {
                    window.close();
                }
            }
        };
        this.controller = controller;
        this.controller.addListener(this.browserWindowListener);
        this.files = files;
        this.loadBundle();
    }

    @Override
    protected void setSelectedTab(int tab) {
        String identifier;
        if (-1 == tab) {
            tab = 0;
        }
        if (!this.validateTabWithIdentifier(identifier = this.tabView.tabViewItemAtIndex(tab).identifier())) {
            tab = 0;
            identifier = this.tabView.tabViewItemAtIndex(tab).identifier();
        }
        super.setSelectedTab(tab);
        this.initTab(identifier);
    }

    private void initTab(String identifier) {
        if (identifier.equals(TOOLBAR_ITEM_GENERAL)) {
            this.initGeneral();
        }
        if (identifier.equals(TOOLBAR_ITEM_PERMISSIONS)) {
            this.initPermissions();
        }
        if (identifier.equals(TOOLBAR_ITEM_ACL)) {
            this.initAcl();
        }
        if (identifier.equals(TOOLBAR_ITEM_DISTRIBUTION)) {
            this.initDistribution();
        }
        if (identifier.equals(TOOLBAR_ITEM_S3)) {
            this.initS3();
        }
        if (identifier.equals(TOOLBAR_ITEM_METADATA)) {
            this.initMetadata();
        }
    }

    @Override
    public NSToolbarItem toolbar_itemForItemIdentifier_willBeInsertedIntoToolbar(NSToolbar toolbar, String itemIdentifier, boolean flag) {
        NSToolbarItem item = super.toolbar_itemForItemIdentifier_willBeInsertedIntoToolbar(toolbar, itemIdentifier, flag);
        Session session = this.controller.getSession();
        if (itemIdentifier.equals(TOOLBAR_ITEM_DISTRIBUTION)) {
            if (session instanceof CloudSession) {
                item.setImage(IconCache.iconNamed(session.getHost().getProtocol().disk(), 32));
            } else {
                item.setImage(IconCache.iconNamed(Protocol.S3.disk(), 32));
            }
        } else if (itemIdentifier.equals(TOOLBAR_ITEM_S3)) {
            if (session instanceof S3Session) {
                item.setLabel(session.getHost().getProtocol().getName());
                item.setImage(IconCache.iconNamed(session.getHost().getProtocol().disk(), 32));
            } else {
                item.setLabel(Protocol.S3.getName());
                item.setImage(IconCache.iconNamed(Protocol.S3.disk(), 32));
            }
        } else if (itemIdentifier.equals(TOOLBAR_ITEM_METADATA)) {
            item.setImage(IconCache.iconNamed("pencil.tiff", 32));
        } else if (itemIdentifier.equals(TOOLBAR_ITEM_ACL)) {
            item.setImage(IconCache.iconNamed("permissions.tiff", 32));
        }
        return item;
    }

    @Override
    protected boolean validateTabWithIdentifier(String itemIdentifier) {
        Session session = this.controller.getSession();
        boolean anonymous = session.getHost().getCredentials().isAnonymousLogin();
        if (itemIdentifier.equals(TOOLBAR_ITEM_PERMISSIONS)) {
            if (anonymous) {
                return false;
            }
            return session.isUnixPermissionsSupported();
        }
        if (itemIdentifier.equals(TOOLBAR_ITEM_ACL)) {
            if (anonymous) {
                return false;
            }
            return session.isAclSupported();
        }
        if (itemIdentifier.equals(TOOLBAR_ITEM_DISTRIBUTION)) {
            if (anonymous) {
                return false;
            }
            return session.isCDNSupported();
        }
        if (itemIdentifier.equals(TOOLBAR_ITEM_S3)) {
            if (session instanceof S3Session) {
                if (!((S3Session)session).isBucketLocationSupported()) {
                    return false;
                }
                return !anonymous;
            }
            return false;
        }
        if (itemIdentifier.equals(TOOLBAR_ITEM_METADATA)) {
            if (anonymous) {
                return false;
            }
            return session.isMetadataSupported();
        }
        return true;
    }

    @Override
    public String getTitle(NSTabViewItem item) {
        return item.label() + " \u2013 " + this.getName();
    }

    public void setPanelMetadata(NSView v) {
        this.panelMetadata = v;
    }

    public void setPanelCloud(NSView v) {
        this.panelCloud = v;
    }

    public void setPanelDistribution(NSView v) {
        this.panelDistribution = v;
    }

    public void setPanelPermissions(NSView v) {
        this.panelPermissions = v;
    }

    public void setPanelAcl(NSView v) {
        this.panelAcl = v;
    }

    public void setPanelGeneral(NSView v) {
        this.panelGeneral = v;
    }

    @Override
    protected void invalidate() {
        this.controller.removeListener(this.browserWindowListener);
        super.invalidate();
    }

    @Override
    protected String getBundleName() {
        return "Info";
    }

    public void setFiles(List<Path> files) {
        if (files.isEmpty()) {
            return;
        }
        this.files = files;
        this.initTab(this.getSelectedTab());
    }

    @Override
    protected void cascade() {
        cascadedWindowPoint = null == cascadedWindowPoint ? this.window.cascadeTopLeftFromPoint(this.window.frame().origin) : this.window.cascadeTopLeftFromPoint(cascadedWindowPoint);
    }

    @Override
    public void awakeFromNib() {
        this.cascade();
        this.ownerr.setTarget(this.id());
        Selector s = Foundation.selector("permissionSelectionChanged:");
        this.ownerr.setAction(s);
        this.ownerr.setAllowsMixedState(true);
        this.ownerw.setTarget(this.id());
        this.ownerw.setAction(s);
        this.ownerw.setAllowsMixedState(true);
        this.ownerx.setTarget(this.id());
        this.ownerx.setAction(s);
        this.ownerx.setAllowsMixedState(true);
        this.groupr.setTarget(this.id());
        this.groupr.setAction(s);
        this.groupr.setAllowsMixedState(true);
        this.groupw.setTarget(this.id());
        this.groupw.setAction(s);
        this.groupw.setAllowsMixedState(true);
        this.groupx.setTarget(this.id());
        this.groupx.setAction(s);
        this.groupx.setAllowsMixedState(true);
        this.otherr.setTarget(this.id());
        this.otherr.setAction(s);
        this.otherr.setAllowsMixedState(true);
        this.otherw.setTarget(this.id());
        this.otherw.setAction(s);
        this.otherw.setAllowsMixedState(true);
        this.otherx.setTarget(this.id());
        this.otherx.setAction(s);
        this.otherx.setAllowsMixedState(true);
        super.awakeFromNib();
    }

    @Override
    protected List<NSView> getPanels() {
        ArrayList<NSView> views = new ArrayList<NSView>();
        views.add(this.panelGeneral);
        if (this.controller.getSession().isUnixPermissionsSupported()) {
            views.add(this.panelPermissions);
        }
        if (this.controller.getSession().isAclSupported()) {
            views.add(this.panelAcl);
        }
        views.add(this.panelMetadata);
        views.add(this.panelDistribution);
        views.add(this.panelCloud);
        return views;
    }

    @Override
    protected List<String> getPanelIdentifiers() {
        ArrayList<String> identifiers = new ArrayList<String>();
        identifiers.add(TOOLBAR_ITEM_GENERAL);
        if (this.controller.getSession().isUnixPermissionsSupported()) {
            identifiers.add(TOOLBAR_ITEM_PERMISSIONS);
        }
        if (this.controller.getSession().isAclSupported()) {
            identifiers.add(TOOLBAR_ITEM_ACL);
        }
        identifiers.add(TOOLBAR_ITEM_METADATA);
        identifiers.add(TOOLBAR_ITEM_DISTRIBUTION);
        identifiers.add(TOOLBAR_ITEM_S3);
        return identifiers;
    }

    private String getName() {
        int count = this.numberOfFiles();
        if (count > 1) {
            return "(" + Locale.localizedString((String)"Multiple files") + ")";
        }
        return this.getSelected().getName();
    }

    @Override
    protected NSUInteger getToolbarSize() {
        return NSToolbar.NSToolbarSizeModeSmall;
    }

    private void initGeneral() {
        int count = this.numberOfFiles();
        if (count > 0) {
            Path file = this.getSelected();
            String filename = this.getName();
            this.filenameField.setStringValue(filename);
            this.window().setTitle(this.title + " \u2013 " + filename);
            this.filenameField.setEnabled(1 == count && this.controller.getSession().isRenameSupported(file));
            String path = file.attributes().isSymbolicLink() ? file.getSymlinkTarget().getAbsolute() : file.getParent().getAbsolute();
            this.updateField(this.pathField, path, TRUNCATE_MIDDLE_ATTRIBUTES);
            this.pathField.setToolTip(path);
            this.groupField.setStringValue(count > 1 ? "(" + Locale.localizedString((String)"Multiple files") + ")" : file.attributes().getGroup());
            if (count > 1) {
                this.kindField.setStringValue("(" + Locale.localizedString((String)"Multiple files") + ")");
                this.checksumField.setStringValue("(" + Locale.localizedString((String)"Multiple files") + ")");
            } else {
                this.updateField(this.kindField, file.kind(), TRUNCATE_MIDDLE_ATTRIBUTES);
            }
            if (count > 1) {
                this.modifiedField.setStringValue("(" + Locale.localizedString((String)"Multiple files") + ")");
                this.createdField.setStringValue("(" + Locale.localizedString((String)"Multiple files") + ")");
            } else {
                if (-1L == file.attributes().getModificationDate()) {
                    this.updateField(this.modifiedField, Locale.localizedString((String)"Unknown"));
                } else {
                    this.updateField(this.modifiedField, DateFormatterFactory.instance().getLongFormat(file.attributes().getModificationDate()), TRUNCATE_MIDDLE_ATTRIBUTES);
                }
                if (-1L == file.attributes().getCreationDate()) {
                    this.updateField(this.createdField, Locale.localizedString((String)"Unknown"));
                } else {
                    this.updateField(this.createdField, DateFormatterFactory.instance().getLongFormat(file.attributes().getCreationDate()), TRUNCATE_MIDDLE_ATTRIBUTES);
                }
            }
            this.updateField(this.ownerField, count > 1 ? "(" + Locale.localizedString((String)"Multiple files") + ")" : file.attributes().getOwner(), TRUNCATE_MIDDLE_ATTRIBUTES);
            if (count > 1) {
                this.iconImageView.setImage(IconCache.iconNamed("NSMultipleDocuments", 32));
            } else {
                this.iconImageView.setImage(IconCache.instance().iconForPath(this.getSelected(), (Integer)32));
            }
        }
        this.initSize();
        this.initChecksum();
        this.initPermissions();
        this.initWebUrl();
    }

    private void initWebUrl() {
        if (this.numberOfFiles() > 1) {
            this.updateField(this.webUrlField, "(" + Locale.localizedString((String)"Multiple files") + ")");
            this.webUrlField.setToolTip("");
        } else {
            this.updateField(this.webUrlField, Locale.localizedString((String)"Unknown"));
            String url = this.getSelected().toHttpURL();
            if (StringUtils.isNotBlank((String)url)) {
                this.webUrlField.setAttributedStringValue(HyperlinkAttributedStringFactory.create(NSMutableAttributedString.create(url, TRUNCATE_MIDDLE_ATTRIBUTES), url));
                this.webUrlField.setToolTip(Locale.localizedString((String)"Open in Web Browser"));
            }
        }
    }

    private void initPermissions() {
        this.permissionsField.setStringValue(Locale.localizedString((String)"Unknown"));
        if (this.togglePermissionSettings(false)) {
            this.controller.background((BackgroundAction)new WorkerBackgroundAction(this.controller, new ReadPermissionWorker(this.files){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void cleanup(List<Permission> permissions) {
                    try {
                        InfoController.this.initPermissions(permissions);
                        Object var3_2 = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        InfoController.this.togglePermissionSettings(true);
                        throw throwable;
                    }
                    InfoController.this.togglePermissionSettings(true);
                }
            }));
        }
    }

    private void initPermissions(List<Permission> permissions) {
        boolean overwrite = true;
        for (Permission permission : permissions) {
            this.updateCheckbox(this.ownerr, overwrite, permission.getOwnerPermissions()[0]);
            this.updateCheckbox(this.ownerw, overwrite, permission.getOwnerPermissions()[1]);
            this.updateCheckbox(this.ownerx, overwrite, permission.getOwnerPermissions()[2]);
            this.updateCheckbox(this.groupr, overwrite, permission.getGroupPermissions()[0]);
            this.updateCheckbox(this.groupw, overwrite, permission.getGroupPermissions()[1]);
            this.updateCheckbox(this.groupx, overwrite, permission.getGroupPermissions()[2]);
            this.updateCheckbox(this.otherr, overwrite, permission.getOtherPermissions()[0]);
            this.updateCheckbox(this.otherw, overwrite, permission.getOtherPermissions()[1]);
            this.updateCheckbox(this.otherx, overwrite, permission.getOtherPermissions()[2]);
            overwrite = false;
        }
        int count = permissions.size();
        if (count > 1) {
            this.permissionsField.setStringValue("(" + Locale.localizedString((String)"Multiple files") + ")");
        } else {
            for (Permission permission : permissions) {
                this.permissionsField.setStringValue(permission.toString());
                this.octalField.setStringValue(permission.getOctalString());
            }
        }
    }

    private void updateCheckbox(NSButton checkbox, boolean overwrite, boolean on) {
        if ((checkbox.state() == 0 || overwrite) && !on) {
            checkbox.setState(0);
        } else if ((checkbox.state() == 1 || overwrite) && on) {
            checkbox.setState(1);
        } else {
            checkbox.setState(-1);
        }
        checkbox.setEnabled(true);
    }

    private void initDistribution() {
        this.distributionStatusField.setStringValue(Locale.localizedString((String)"Unknown"));
        this.distributionCnameField.cell().setPlaceholderString(Locale.localizedString((String)"None"));
        this.distributionOriginField.setStringValue(Locale.localizedString((String)"Unknown"));
        this.distributionUrlField.setStringValue(Locale.localizedString((String)"Unknown"));
        this.distributionInvalidationStatusField.setStringValue(Locale.localizedString((String)"None"));
        String selected = this.distributionDeliveryPopup.titleOfSelectedItem();
        this.distributionDeliveryPopup.removeAllItems();
        this.distributionDeliveryPopup.addItemWithTitle(Locale.localizedString((String)"None"));
        this.distributionDefaultRootPopup.removeAllItems();
        this.distributionDefaultRootPopup.addItemWithTitle(Locale.localizedString((String)"None"));
        this.distributionDefaultRootPopup.menu().addItem(NSMenuItem.separatorItem());
        Session session = this.controller.getSession();
        this.distributionEnableButton.setTitle(MessageFormat.format(Locale.localizedString((String)"Enable {0} Distribution", (String)"Status"), session.cdn().toString()));
        this.distributionDeliveryPopup.removeItemWithTitle(Locale.localizedString((String)"None"));
        for (Distribution.Method method : session.cdn().getMethods()) {
            this.distributionDeliveryPopup.addItemWithTitle(method.toString());
            this.distributionDeliveryPopup.itemWithTitle(method.toString()).setRepresentedObject(method.toString());
        }
        this.distributionDeliveryPopup.selectItemWithTitle(selected);
        if (null == this.distributionDeliveryPopup.selectedItem()) {
            Distribution.Method method = (Distribution.Method)session.cdn().getMethods().iterator().next();
            this.distributionDeliveryPopup.selectItemWithTitle(method.toString());
        }
        this.distributionStatusButtonClicked(null);
    }

    private void initSize() {
        if (this.toggleSizeSettings(false)) {
            this.controller.background((BackgroundAction)new WorkerBackgroundAction(this.controller, new ReadSizeWorker(this.files){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void cleanup(Long size) {
                    try {
                        InfoController.this.updateSize(size);
                        Object var3_2 = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        InfoController.this.toggleSizeSettings(true);
                        throw throwable;
                    }
                    InfoController.this.toggleSizeSettings(true);
                }
            }));
        }
    }

    private void updateSize(long size) {
        this.sizeField.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes(Status.getSizeAsString((double)size, (boolean)true), TRUNCATE_MIDDLE_ATTRIBUTES));
    }

    private void initChecksum() {
        if (this.numberOfFiles() > 1) {
            this.checksumField.setStringValue("(" + Locale.localizedString((String)"Multiple files") + ")");
        } else {
            this.checksumField.setStringValue(Locale.localizedString((String)"Unknown"));
            if (this.toggleSizeSettings(false)) {
                this.controller.background((BackgroundAction)new WorkerBackgroundAction(this.controller, new ChecksumWorker(this.files){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void cleanup(List<String> checksums) {
                        try {
                            for (String checksum : checksums) {
                                if (!StringUtils.isNotBlank((String)checksum)) continue;
                                InfoController.this.updateField(InfoController.this.checksumField, checksum);
                            }
                            Object var5_4 = null;
                        }
                        catch (Throwable throwable) {
                            Object var5_5 = null;
                            InfoController.this.toggleSizeSettings(true);
                            throw throwable;
                        }
                        InfoController.this.toggleSizeSettings(true);
                    }
                }));
            }
        }
    }

    private boolean toggleS3Settings(boolean stop) {
        this.window().endEditingFor(null);
        Session session = this.controller.getSession();
        boolean enable = session instanceof S3Session;
        if (enable) {
            Credentials credentials = session.getHost().getCredentials();
            enable = !credentials.isAnonymousLogin();
        }
        boolean logging = false;
        boolean versioning = false;
        boolean storageclass = false;
        if (enable) {
            logging = ((S3Session)session).isLoggingSupported();
            versioning = ((S3Session)session).isVersioningSupported();
        }
        this.bucketVersioningButton.setEnabled(stop && enable && versioning);
        this.bucketMfaButton.setEnabled(stop && enable && versioning && this.bucketVersioningButton.state() == 1);
        this.bucketLoggingButton.setEnabled(stop && enable && logging);
        if (stop) {
            this.s3Progress.stopAnimation(null);
        } else if (enable) {
            this.s3Progress.startAnimation(null);
        }
        return enable;
    }

    private void initS3() {
        this.bucketLocationField.setStringValue(Locale.localizedString((String)"Unknown"));
        this.bucketLoggingButton.setToolTip(Locale.localizedString((String)"Unknown"));
        this.s3PublicUrlField.setStringValue(Locale.localizedString((String)"None"));
        this.s3PublicUrlValidityField.setStringValue(Locale.localizedString((String)"Unknown"));
        this.s3torrentUrlField.setStringValue(Locale.localizedString((String)"None"));
        this.storageClassPopup.addItemWithTitle(Locale.localizedString((String)"Unknown"));
        this.storageClassPopup.itemWithTitle(Locale.localizedString((String)"Unknown")).setEnabled(false);
        this.storageClassPopup.selectItemWithTitle(Locale.localizedString((String)"Unknown"));
        if (this.toggleS3Settings(false)) {
            for (String redundancy : ((CloudSession)this.controller.getSession()).getSupportedStorageClasses()) {
                this.storageClassPopup.addItemWithTitle(Locale.localizedString((String)redundancy, (String)"S3"));
                this.storageClassPopup.lastItem().setRepresentedObject(redundancy);
            }
            if (this.numberOfFiles() > 1) {
                this.s3PublicUrlField.setStringValue("(" + Locale.localizedString((String)"Multiple files") + ")");
                this.s3PublicUrlField.setToolTip("");
                this.s3torrentUrlField.setStringValue("(" + Locale.localizedString((String)"Multiple files") + ")");
                this.s3torrentUrlField.setToolTip("");
            } else {
                String redundancy;
                Path file = this.getSelected();
                redundancy = file.attributes().getStorageClass();
                if (StringUtils.isNotEmpty((String)redundancy)) {
                    this.storageClassPopup.removeItemWithTitle(Locale.localizedString((String)"Unknown"));
                    this.storageClassPopup.selectItemWithTitle(Locale.localizedString((String)redundancy, (String)"S3"));
                }
                if (file.attributes().isFile()) {
                    AbstractPath.DescriptiveUrl torrent;
                    S3Path s3 = (S3Path)file;
                    this.bucketLoggingButton.setToolTip(s3.getContainerName() + "/" + Preferences.instance().getProperty("s3.logging.prefix"));
                    AbstractPath.DescriptiveUrl url = s3.toSignedUrl();
                    if (StringUtils.isNotBlank((String)url.getUrl())) {
                        this.s3PublicUrlField.setAttributedStringValue(HyperlinkAttributedStringFactory.create(NSMutableAttributedString.create(url.getUrl(), TRUNCATE_MIDDLE_ATTRIBUTES), url.getUrl()));
                        this.s3PublicUrlField.setToolTip(url.getHelp());
                    }
                    if (StringUtils.isNotBlank((String)url.getHelp())) {
                        this.s3PublicUrlValidityField.setStringValue(url.getHelp());
                    }
                    if (StringUtils.isNotBlank((String)(torrent = s3.toTorrentUrl()).getUrl())) {
                        this.s3torrentUrlField.setAttributedStringValue(HyperlinkAttributedStringFactory.create(NSMutableAttributedString.create(torrent.getUrl(), TRUNCATE_MIDDLE_ATTRIBUTES), torrent.getUrl()));
                        this.s3torrentUrlField.setToolTip(Locale.localizedString((String)"Open in Web Browser"));
                    }
                }
            }
            this.controller.background((BackgroundAction)new BrowserBackgroundAction(this.controller){
                private String location;
                private boolean logging;
                private boolean versioning;
                private boolean mfa;
                {
                    this.location = null;
                    this.logging = false;
                    this.versioning = false;
                    this.mfa = false;
                }

                public void run() {
                    S3Session s = (S3Session)InfoController.this.controller.getSession();
                    String container = InfoController.this.getSelected().getContainerName();
                    this.location = s.getLocation(container);
                    this.logging = s.isLogging(container);
                    this.versioning = s.isVersioning(container);
                    this.mfa = s.isMultiFactorAuthentication(container);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void cleanup() {
                    try {
                        InfoController.this.bucketLoggingButton.setState(this.logging ? 1 : 0);
                        if (StringUtils.isNotBlank((String)this.location)) {
                            InfoController.this.bucketLocationField.setStringValue(Locale.localizedString((String)this.location, (String)"S3"));
                        }
                        InfoController.this.bucketVersioningButton.setState(this.versioning ? 1 : 0);
                        InfoController.this.bucketMfaButton.setEnabled(this.versioning);
                        InfoController.this.bucketMfaButton.setState(this.mfa ? 1 : 0);
                        Object var2_1 = null;
                    }
                    catch (Throwable throwable) {
                        Object var2_2 = null;
                        InfoController.this.toggleS3Settings(true);
                        throw throwable;
                    }
                    InfoController.this.toggleS3Settings(true);
                }

                public String getActivity() {
                    return MessageFormat.format(Locale.localizedString((String)"Reading metadata of {0}", (String)"Status"), this.toString(InfoController.this.files));
                }
            });
        }
    }

    private boolean toggleAclSettings(boolean stop) {
        this.window().endEditingFor(null);
        Session session = this.controller.getSession();
        Credentials credentials = session.getHost().getCredentials();
        boolean enable = !credentials.isAnonymousLogin() && session.isAclSupported();
        this.aclTable.setEnabled(stop && enable);
        this.aclAddButton.setEnabled(stop && enable);
        boolean selection = this.aclTable.selectedRowIndexes().count().intValue() > 0;
        this.aclRemoveButton.setEnabled(stop && enable && selection);
        if (stop) {
            this.aclProgress.stopAnimation(null);
        } else if (enable) {
            this.aclProgress.startAnimation(null);
        }
        return enable;
    }

    private boolean toggleMetadataSettings(boolean stop) {
        boolean enable;
        this.window().endEditingFor(null);
        Session session = this.controller.getSession();
        Credentials credentials = session.getHost().getCredentials();
        boolean bl = enable = !credentials.isAnonymousLogin() && session.isMetadataSupported();
        if (enable) {
            for (Path file : this.files) {
                enable = enable && (file.attributes().isFile() || file.attributes().isPlaceholder());
            }
        }
        this.metadataTable.setEnabled(stop && enable);
        this.metadataAddButton.setEnabled(stop && enable);
        boolean selection = this.metadataTable.selectedRowIndexes().count().intValue() > 0;
        this.metadataRemoveButton.setEnabled(stop && enable && selection);
        if (stop) {
            this.metadataProgress.stopAnimation(null);
        } else if (enable) {
            this.metadataProgress.startAnimation(null);
        }
        return enable;
    }

    private void initMetadata() {
        this.setMetadata(Collections.<Header>emptyList());
        if (this.toggleMetadataSettings(false)) {
            this.controller.background((BackgroundAction)new WorkerBackgroundAction(this.controller, new ReadMetadataWorker(this.files){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void cleanup(Map<String, String> updated) {
                    try {
                        ArrayList<Header> m = new ArrayList<Header>();
                        for (String key : updated.keySet()) {
                            m.add(new Header(key, updated.get(key)));
                        }
                        InfoController.this.setMetadata(m);
                        Object var6_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        InfoController.this.toggleMetadataSettings(true);
                        throw throwable;
                    }
                    InfoController.this.toggleMetadataSettings(true);
                }
            }));
        }
    }

    private void initAcl() {
        this.setAcl(Collections.<Acl.UserAndRole>emptyList());
        this.aclUrlField.setStringValue(Locale.localizedString((String)"None"));
        if (this.toggleAclSettings(false)) {
            this.aclPermissionCellPrototype.removeAllItems();
            for (Acl.Role permission : this.controller.getSession().getAvailableAclRoles(this.files)) {
                this.aclPermissionCellPrototype.addItemWithObjectValue(NSString.stringWithString(permission.getName()));
            }
            if (this.numberOfFiles() > 1) {
                this.aclUrlField.setStringValue("(" + Locale.localizedString((String)"Multiple files") + ")");
                this.aclUrlField.setToolTip("");
            } else {
                for (Path file : this.files) {
                    AbstractPath.DescriptiveUrl url;
                    if (!file.attributes().isFile() || !StringUtils.isNotBlank((String)(url = file.toAuthenticatedUrl()).getUrl())) continue;
                    this.aclUrlField.setAttributedStringValue(HyperlinkAttributedStringFactory.create(NSMutableAttributedString.create(url.getUrl(), TRUNCATE_MIDDLE_ATTRIBUTES), url.getUrl()));
                    this.aclUrlField.setToolTip(url.getHelp());
                }
            }
            this.controller.background((BackgroundAction)new WorkerBackgroundAction(this.controller, new ReadAclWorker(this.files){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void cleanup(List<Acl.UserAndRole> updated) {
                    try {
                        InfoController.this.setAcl(updated);
                        Object var3_2 = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        InfoController.this.toggleAclSettings(true);
                        throw throwable;
                    }
                    InfoController.this.toggleAclSettings(true);
                }
            }));
        }
    }

    private int numberOfFiles() {
        return null == this.files ? 0 : this.files.size();
    }

    public void filenameInputDidEndEditing(NSNotification sender) {
        if (this.numberOfFiles() == 1) {
            Path current = this.getSelected();
            if (!this.filenameField.stringValue().equals(current.getName())) {
                if (StringUtils.contains((String)this.filenameField.stringValue(), (char)'/')) {
                    AppKitFunctionsLibrary.beep();
                    return;
                }
                if (StringUtils.isBlank((String)this.filenameField.stringValue())) {
                    this.filenameField.setStringValue(current.getName());
                } else {
                    Path renamed = PathFactory.createPath((Session)this.controller.getSession(), (String)current.getParent().getAbsolute(), (String)this.filenameField.stringValue(), (int)current.attributes().getType());
                    this.controller.renamePath(current, renamed);
                    this.initWebUrl();
                }
            }
        }
    }

    public void octalPermissionsInputDidEndEditing(NSNotification sender) {
        Permission permission = this.getPermissionFromOctalField();
        if (null == permission) {
            AppKitFunctionsLibrary.beep();
            this.initPermissions();
        } else {
            boolean change = false;
            for (Path file : this.files) {
                if (file.attributes().getPermission().equals((Object)permission)) continue;
                change = true;
            }
            if (change) {
                this.initPermissions(Collections.singletonList(permission));
                this.changePermissions(permission, false);
            }
        }
    }

    private Permission getPermissionFromOctalField() {
        if (StringUtils.isNotBlank((String)this.octalField.stringValue()) && StringUtils.length((String)this.octalField.stringValue()) >= 3 && StringUtils.isNumeric((String)this.octalField.stringValue())) {
            return new Permission(Integer.valueOf(this.octalField.stringValue()).intValue());
        }
        log.warn((Object)("Invalid octal field input:" + this.octalField.stringValue()));
        return null;
    }

    public void recursiveButtonClicked(NSButton sender) {
        Permission permission = this.getPermissionFromOctalField();
        if (null == permission) {
            AppKitFunctionsLibrary.beep();
            this.initPermissions();
        } else {
            this.changePermissions(permission, true);
        }
    }

    public void permissionSelectionChanged(NSButton sender) {
        if (sender.state() == -1) {
            sender.setState(1);
        }
        Permission p = this.getPermissionFromCheckboxes();
        this.initPermissions(Collections.singletonList(p));
        this.changePermissions(p, false);
    }

    private Permission getPermissionFromCheckboxes() {
        boolean[][] p = new boolean[3][3];
        p[0][0] = this.ownerr.state() == 1;
        p[0][1] = this.ownerw.state() == 1;
        p[0][2] = this.ownerx.state() == 1;
        p[1][0] = this.groupr.state() == 1;
        p[1][1] = this.groupw.state() == 1;
        p[1][2] = this.groupx.state() == 1;
        p[2][0] = this.otherr.state() == 1;
        p[2][1] = this.otherw.state() == 1;
        p[2][2] = this.otherx.state() == 1;
        return new Permission(p);
    }

    private void changePermissions(Permission permission, boolean recursive) {
        if (this.togglePermissionSettings(false)) {
            this.controller.background((BackgroundAction)new WorkerBackgroundAction(this.controller, new WritePermissionWorker(this.files, permission, recursive){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void cleanup(Permission permission) {
                    try {
                        InfoController.this.initPermissions(Collections.singletonList(permission));
                        Object var3_2 = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        InfoController.this.togglePermissionSettings(true);
                        throw throwable;
                    }
                    InfoController.this.togglePermissionSettings(true);
                }
            }));
        }
    }

    private boolean togglePermissionSettings(boolean stop) {
        this.window().endEditingFor(null);
        Session session = this.controller.getSession();
        Credentials credentials = session.getHost().getCredentials();
        boolean enable = !credentials.isAnonymousLogin() && session.isUnixPermissionsSupported();
        this.recursiveButton.setEnabled(stop && enable);
        for (Path next : this.files) {
            if (!next.attributes().isFile()) continue;
            this.recursiveButton.setEnabled(false);
            break;
        }
        this.octalField.setEnabled(stop && enable);
        this.ownerr.setEnabled(stop && enable);
        this.ownerw.setEnabled(stop && enable);
        this.ownerx.setEnabled(stop && enable);
        this.groupr.setEnabled(stop && enable);
        this.groupw.setEnabled(stop && enable);
        this.groupx.setEnabled(stop && enable);
        this.otherr.setEnabled(stop && enable);
        this.otherw.setEnabled(stop && enable);
        this.otherx.setEnabled(stop && enable);
        if (stop) {
            this.permissionProgress.stopAnimation(null);
        } else if (enable) {
            this.permissionProgress.startAnimation(null);
        }
        return enable;
    }

    private boolean toggleDistributionSettings(boolean stop) {
        boolean enable;
        this.window().endEditingFor(null);
        Session session = this.controller.getSession();
        Credentials credentials = session.getHost().getCredentials();
        boolean bl = enable = !credentials.isAnonymousLogin() && session.isCDNSupported();
        if (enable) {
            String container = this.getSelected().getContainerName();
            for (Path next : this.files) {
                if (next.getContainerName().equals(container)) continue;
                enable = false;
                break;
            }
        }
        Distribution.Method method = Distribution.Method.forName((String)this.distributionDeliveryPopup.selectedItem().representedObject());
        this.distributionEnableButton.setEnabled(stop && enable);
        this.distributionDeliveryPopup.setEnabled(stop && enable);
        this.distributionLoggingButton.setEnabled(stop && enable && session.cdn().isLoggingSupported(method));
        this.distributionCnameField.setEnabled(stop && enable && session.cdn().isCnameSupported(method));
        this.distributionInvalidateObjectsButton.setEnabled(stop && enable && session.cdn().isInvalidationSupported(method));
        this.distributionDefaultRootPopup.setEnabled(stop && enable && session.cdn().isDefaultRootSupported(method));
        if (stop) {
            this.distributionProgress.stopAnimation(null);
        } else if (enable) {
            this.distributionProgress.startAnimation(null);
        }
        return enable;
    }

    public void distributionInvalidateObjectsButtonClicked(final ID sender) {
        if (this.toggleDistributionSettings(false)) {
            this.controller.background((BackgroundAction)new BrowserBackgroundAction(this.controller){

                public void run() {
                    Session session = InfoController.this.controller.getSession();
                    Distribution.Method method = Distribution.Method.forName((String)InfoController.this.distributionDeliveryPopup.selectedItem().representedObject());
                    session.cdn().invalidate(session.cdn().getOrigin(method, InfoController.this.getSelected().getContainerName()), method, InfoController.this.files, false);
                }

                public void cleanup() {
                    InfoController.this.distributionStatusButtonClicked(sender);
                }

                public String getActivity() {
                    return MessageFormat.format(Locale.localizedString((String)"Writing CDN configuration of {0}", (String)"Status"), InfoController.this.getSelected().getContainerName());
                }
            });
        }
    }

    public void distributionApplyButtonClicked(final ID sender) {
        if (this.toggleDistributionSettings(false)) {
            this.controller.background((BackgroundAction)new BrowserBackgroundAction(this.controller){

                public void run() {
                    Session session = InfoController.this.controller.getSession();
                    Distribution.Method method = Distribution.Method.forName((String)InfoController.this.distributionDeliveryPopup.selectedItem().representedObject());
                    if (StringUtils.isNotBlank((String)InfoController.this.distributionCnameField.stringValue())) {
                        session.cdn().write(InfoController.this.distributionEnableButton.state() == 1, session.cdn().getOrigin(method, InfoController.this.getSelected().getContainerName()), method, StringUtils.split((String)InfoController.this.distributionCnameField.stringValue()), InfoController.this.distributionLoggingButton.state() == 1, InfoController.this.distributionDefaultRootPopup.selectedItem().representedObject());
                    } else {
                        session.cdn().write(InfoController.this.distributionEnableButton.state() == 1, session.cdn().getOrigin(method, InfoController.this.getSelected().getContainerName()), method, new String[]{}, InfoController.this.distributionLoggingButton.state() == 1, InfoController.this.distributionDefaultRootPopup.selectedItem().representedObject());
                    }
                }

                public void cleanup() {
                    InfoController.this.distributionStatusButtonClicked(sender);
                }

                public String getActivity() {
                    return MessageFormat.format(Locale.localizedString((String)"Writing CDN configuration of {0}", (String)"Status"), InfoController.this.getSelected().getContainerName());
                }
            });
        }
    }

    public void distributionStatusButtonClicked(ID sender) {
        if (this.toggleDistributionSettings(false)) {
            this.controller.background((BackgroundAction)new BrowserBackgroundAction(this.controller){
                Distribution distribution;

                public void run() {
                    Session session = InfoController.this.controller.getSession();
                    Distribution.Method method = Distribution.Method.forName((String)InfoController.this.distributionDeliveryPopup.selectedItem().representedObject());
                    this.distribution = session.cdn().read(session.cdn().getOrigin(method, InfoController.this.getSelected().getContainerName()), method);
                    InfoController.this.getSelected().getContainer().children();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void cleanup() {
                    try {
                        Session session = InfoController.this.controller.getSession();
                        InfoController.this.distributionEnableButton.setTitle(MessageFormat.format(Locale.localizedString((String)"Enable {0} Distribution", (String)"Status"), session.cdn().toString(this.distribution.getMethod())));
                        InfoController.this.distributionEnableButton.setState(this.distribution.isEnabled() ? 1 : 0);
                        InfoController.this.distributionStatusField.setAttributedStringValue(NSMutableAttributedString.create(this.distribution.getStatus(), BundleController.TRUNCATE_MIDDLE_ATTRIBUTES));
                        InfoController.this.distributionLoggingButton.setEnabled(this.distribution.isEnabled());
                        InfoController.this.distributionLoggingButton.setState(this.distribution.isLogging() ? 1 : 0);
                        String origin = this.distribution.getOrigin(InfoController.this.getSelected());
                        InfoController.this.distributionOriginField.setAttributedStringValue(HyperlinkAttributedStringFactory.create(NSMutableAttributedString.create(origin, BundleController.TRUNCATE_MIDDLE_ATTRIBUTES), origin));
                        Path file = InfoController.this.getSelected();
                        if (InfoController.this.numberOfFiles() > 1) {
                            InfoController.this.distributionUrlField.setStringValue("(" + Locale.localizedString((String)"Multiple files") + ")");
                            InfoController.this.distributionUrlField.setToolTip("");
                            InfoController.this.distributionCnameUrlField.setStringValue("(" + Locale.localizedString((String)"Multiple files") + ")");
                        } else {
                            String url = this.distribution.getURL(file);
                            if (StringUtils.isNotBlank((String)url)) {
                                InfoController.this.distributionUrlField.setAttributedStringValue(HyperlinkAttributedStringFactory.create(NSMutableAttributedString.create(url, BundleController.TRUNCATE_MIDDLE_ATTRIBUTES), url));
                                InfoController.this.distributionUrlField.setToolTip(Locale.localizedString((String)"CDN URL"));
                            } else {
                                InfoController.this.distributionUrlField.setStringValue(Locale.localizedString((String)"None"));
                                InfoController.this.distributionUrlField.setToolTip("");
                            }
                        }
                        Object[] cnames = this.distribution.getCNAMEs();
                        if (0 == cnames.length) {
                            InfoController.this.distributionCnameField.setStringValue("");
                            InfoController.this.distributionCnameUrlField.setStringValue("");
                            InfoController.this.distributionCnameUrlField.setToolTip("");
                        } else {
                            InfoController.this.distributionCnameField.setStringValue(StringUtils.join((Object[])cnames, (char)' '));
                            Iterator i$ = this.distribution.getCnameURL(file).iterator();
                            if (i$.hasNext()) {
                                AbstractPath.DescriptiveUrl url = (AbstractPath.DescriptiveUrl)i$.next();
                                InfoController.this.distributionCnameUrlField.setAttributedStringValue(HyperlinkAttributedStringFactory.create(NSMutableAttributedString.create(url.getUrl(), BundleController.TRUNCATE_MIDDLE_ATTRIBUTES), url.getUrl()));
                                InfoController.this.distributionCnameUrlField.setToolTip(Locale.localizedString((String)"CDN URL"));
                            }
                        }
                        if (session.cdn().isDefaultRootSupported(this.distribution.getMethod())) {
                            for (AbstractPath next : InfoController.this.getSelected().getContainer().children()) {
                                if (!next.attributes().isFile()) continue;
                                InfoController.this.distributionDefaultRootPopup.addItemWithTitle(next.getName());
                                InfoController.this.distributionDefaultRootPopup.lastItem().setRepresentedObject(next.getName());
                            }
                        }
                        if (StringUtils.isNotBlank((String)this.distribution.getDefaultRootObject())) {
                            if (null == InfoController.this.distributionDefaultRootPopup.itemWithTitle(this.distribution.getDefaultRootObject())) {
                                InfoController.this.distributionDefaultRootPopup.addItemWithTitle(this.distribution.getDefaultRootObject());
                            }
                            InfoController.this.distributionDefaultRootPopup.selectItemWithTitle(this.distribution.getDefaultRootObject());
                        } else {
                            InfoController.this.distributionDefaultRootPopup.selectItemWithTitle(Locale.localizedString((String)"None"));
                        }
                        StringBuilder tooltip = new StringBuilder();
                        Iterator iter = InfoController.this.files.iterator();
                        while (iter.hasNext()) {
                            Path f = (Path)iter.next();
                            tooltip.append(f.getAbsolute());
                            if (!iter.hasNext()) continue;
                            tooltip.append("\n");
                        }
                        InfoController.this.distributionInvalidateObjectsButton.setToolTip(tooltip.toString());
                        InfoController.this.distributionInvalidationStatusField.setStringValue(this.distribution.getInvalidationStatus());
                        Object var9_8 = null;
                    }
                    catch (Throwable throwable) {
                        Object var9_9 = null;
                        InfoController.this.toggleDistributionSettings(true);
                        throw throwable;
                    }
                    InfoController.this.toggleDistributionSettings(true);
                }

                public String getActivity() {
                    return MessageFormat.format(Locale.localizedString((String)"Reading CDN configuration of {0}", (String)"Status"), InfoController.this.getSelected().getContainerName());
                }
            });
        }
    }

    public void calculateSizeButtonClicked(ID sender) {
        if (this.toggleSizeSettings(false)) {
            this.controller.background((BackgroundAction)new WorkerBackgroundAction(this.controller, new CalculateSizeWorker(this.files){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void cleanup(Long size) {
                    try {
                        InfoController.this.updateSize(size);
                        Object var3_2 = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        InfoController.this.toggleSizeSettings(true);
                        throw throwable;
                    }
                    InfoController.this.toggleSizeSettings(true);
                }

                protected void update(final long size) {
                    InfoController.this.invoke((MainAction)new WindowMainAction(InfoController.this){

                        public void run() {
                            InfoController.this.updateSize(size);
                        }
                    });
                }
            }));
        }
    }

    private boolean toggleSizeSettings(boolean stop) {
        this.window().endEditingFor(null);
        this.sizeButton.setEnabled(false);
        for (Path next : this.files) {
            if (!next.attributes().isDirectory()) continue;
            this.sizeButton.setEnabled(stop);
            break;
        }
        if (stop) {
            this.sizeProgress.stopAnimation(null);
        } else {
            this.sizeProgress.startAnimation(null);
        }
        return true;
    }

    @Override
    public void helpButtonClicked(NSButton sender) {
        String tab = this.getSelectedTab();
        StringBuilder site = new StringBuilder(Preferences.instance().getProperty("website.help"));
        if (tab.equals(TOOLBAR_ITEM_GENERAL)) {
            site.append("/howto/info");
        } else if (tab.equals(TOOLBAR_ITEM_PERMISSIONS)) {
            site.append("/howto/permissions");
        } else if (tab.equals(TOOLBAR_ITEM_ACL)) {
            site.append("/howto/acl");
        } else if (tab.equals(TOOLBAR_ITEM_METADATA)) {
            site.append("/").append(this.controller.getSession().getHost().getProtocol().getIdentifier());
        } else if (tab.equals(TOOLBAR_ITEM_S3)) {
            site.append("/").append(this.controller.getSession().getHost().getProtocol().getIdentifier());
        } else if (tab.equals(TOOLBAR_ITEM_DISTRIBUTION)) {
            site.append("/howto/cdn");
        }
        InfoController.openUrl(site.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory {
        private static Map<BrowserController, InfoController> open = new HashMap<BrowserController, InfoController>();

        public static InfoController create(final BrowserController controller, List<Path> files) {
            if (Preferences.instance().getBoolean("browser.info.isInspector") && open.containsKey(controller)) {
                InfoController c = open.get(controller);
                c.setFiles(files);
                return c;
            }
            final InfoController c = new InfoController(controller, files){

                public void windowWillClose(NSNotification notification) {
                    open.remove(controller);
                    super.windowWillClose(notification);
                }
            };
            controller.getSession().addConnectionListener((ConnectionListener)new ConnectionAdapter(){

                public void connectionDidClose() {
                    c.window().close();
                    controller.getSession().removeConnectionListener((ConnectionListener)this);
                }
            });
            open.put(controller, c);
            return c;
        }

        public static InfoController get(BrowserController controller) {
            return open.get(controller);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Header
    implements Comparable<Header> {
        private String name;
        private String value;

        private Header(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        @Override
        public int compareTo(Header o) {
            return this.getName().compareTo(o.getName());
        }
    }
}

